/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import javax.swing.ListModel;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.TextField;

public class SearchList
extends Panel {
    protected TextField field;
    protected List list;
    protected ListSelectionListener listSelectionListener;
    private LabelProvider labelProvider;

    public SearchList(UiContainer parent, Object[] listData) {
        super(parent);
        RelativeLayout layout = new RelativeLayout();
        this.labelProvider = this.createDefaultProvider();
        this.setLayout(layout);
        this.list = List.create((UiContainer)this, listData);
        this.list.setLabelProvider(this.labelProvider);
        this.field = new TextField(this);
        this.add(this.field, "field");
        this.add(this.list, "list");
        this.layoutComponents(layout);
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = SearchList.this.list.getSelectedValue();
                if (value != null) {
                    SearchList.this.field.setText((String)value);
                    SearchList.this.field.transferFocus();
                }
            }
        });
        this.field.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchList.this.updateProperty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchList.this.updateProperty();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchList.this.updateProperty();
            }
        });
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object obj = SearchList.this.list.getSelectedValue();
                if (obj != null) {
                    SearchList.this.field.setText(SearchList.this.labelProvider.getText(obj));
                }
            }
        };
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    public static void main(String[] args) {
        int i;
        Dialog d = new Dialog((UiWindow)null);
        Object[] data = new String[3000];
        for (i = 0; i < 1000; ++i) {
            data[i] = "Ale " + i + " abcdefghijklm?opqrstuvwxyz";
        }
        for (i = 1000; i < 2000; ++i) {
            data[i] = "Diego " + i + " abcdefghijklm?opqrstuvwxyz";
        }
        for (i = 2000; i < 3000; ++i) {
            data[i] = "Caro " + i + " abcdefghijklm?opqrstuvwxyz";
        }
        UiContainer contentPane = d.getContentPane();
        contentPane.add(new SearchList(contentPane, data), "Center");
        d.pack();
        d.setVisible(true);
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.list.setLabelProvider(labelProvider);
    }

    public TextField getField() {
        return this.field;
    }

    public List getList() {
        return this.list;
    }

    @Override
    public Dimension getMaximumSize() {
        Margin ins = this.getInsets();
        Dimension d2 = this.field.getMaximumSize();
        Dimension d3 = this.list.getMaximumSize();
        int w = Math.max(d2.getWidth(), d3.getWidth());
        int h = d2.getHeight() + d3.getHeight();
        return Dimension.valueOf(w + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        Margin ins = this.getInsets();
        Dimension d2 = this.field.getMinimumSize();
        Dimension d3 = this.list.getMinimumSize();
        int w = Math.max(d2.getWidth(), d3.getWidth());
        int h = d2.getHeight() + d3.getHeight();
        return Dimension.valueOf(w + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        Margin ins = this.getInsets();
        Dimension d2 = this.field.getPreferredSize();
        Dimension d3 = this.list.getPreferredSize();
        int w = Math.max(d2.getWidth(), d3.getWidth());
        int h = d2.getHeight() + d3.getHeight();
        return Dimension.valueOf(w + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    public void setSelected(String value) {
        this.list.setSelectedValue(value, true);
        this.field.setText(value);
    }

    public String getSelected() {
        return this.field.getText();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    protected void doSearch() {
        ListModel model = this.list.getModel();
        String key = this.field.getText().toLowerCase();
        for (int i = 0; i < model.getSize(); ++i) {
            Object data = model.getElementAt(i);
            if (!this.labelProvider.getText(data).toLowerCase().startsWith(key)) continue;
            this.list.removeListSelectionListener(this.listSelectionListener);
            this.list.setSelectedValue(data, true);
            this.list.addListSelectionListener(this.listSelectionListener);
            break;
        }
    }

    private LabelProvider createDefaultProvider() {
        return new LabelProvider(){

            public Image getIcon(Object element) {
                return null;
            }

            public String getText(Object element) {
                return element.toString();
            }
        };
    }

    private void layoutComponents(RelativeLayout layout) {
        layout.addConstraint("field", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 1));
        layout.addConstraint("field", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("field", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("list", AttributeType.TOP, new AttributeConstraint("field", AttributeType.BOTTOM, 5));
        layout.addConstraint("list", AttributeType.LEFT, new AttributeConstraint("field", AttributeType.LEFT));
        layout.addConstraint("list", AttributeType.RIGHT, new AttributeConstraint("field", AttributeType.RIGHT));
        layout.addConstraint("list", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, -1));
    }

    private void updateProperty() {
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int loc = SearchList.this.field.getCaretPosition();
                String propertyText = SearchList.this.field.getText();
                if (propertyText.length() >= loc) {
                    SearchList.this.field.setCaretPosition(loc);
                } else {
                    SearchList.this.field.setCaretPosition(propertyText.length());
                }
                SearchList.this.doSearch();
            }
        });
    }
}

