/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.peer.AbstractButtonPeer;
import oracle.bpm.ui.peer.Peer;

public class RadioButton<I>
extends AbstractButton
implements Editable {
    private ItemListener changeListener;
    private I item;
    private ArrayList<ModificationListener> modificationListeners = new ArrayList();
    private boolean oldValue;
    public static int OPTIONS = 255;

    public RadioButton(UiContainer parent) {
        super(parent, OPTIONS);
        UiUtilities.addToEditableContainer(this, parent);
    }

    public RadioButton(UiContainer parent, BaseAction a) {
        this(parent, a.getMsg());
        this.setAction(a);
    }

    public RadioButton(UiContainer parent, Msg msg) {
        this(parent);
        this.setMsg(msg);
    }

    public RadioButton(UiContainer parent, String text) {
        this(parent);
        this.setText(text);
    }

    @Override
    public boolean isModified() {
        return this.oldValue != this.isSelected();
    }

    @Override
    public void resetModified() {
        this.oldValue = this.isSelected();
    }

    @Override
    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
        if (this.changeListener == null) {
            this.changeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RadioButton.this.fireChanged();
                }
            };
            this.addItemListener(this.changeListener);
        }
    }

    @Override
    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
        if (this.modificationListeners.isEmpty()) {
            this.removeItemListener(this.changeListener);
            this.changeListener = null;
        }
    }

    public void addItemListener(ItemListener listener) {
        this.getAbstractPeer().addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.getAbstractPeer().removeItemListener(listener);
    }

    public I getItem() {
        return this.item;
    }

    public void setItem(I item) {
        this.item = item;
    }

    @Override
    protected AbstractButtonPeer getAbstractPeer() {
        return (AbstractButtonPeer)this.getPeer();
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createRadioButton(this.getParentPeer());
    }

    @Override
    protected void update() {
        Msg msg = this.getMsg();
        int options = this.getOptions();
        if (msg == null) {
            return;
        }
        if ((options & 1) != 0) {
            super.setText(msg.getString());
        }
        if ((options & 4) != 0) {
            super.setMnemonic(msg.getMnemonic());
        }
        if ((options & 8) != 0) {
            String tooltip = msg.getDetail();
            if ("".equals(tooltip)) {
                tooltip = msg.getString();
            }
            super.setToolTipText(tooltip);
        }
    }

    private void fireChanged() {
        for (ModificationListener modificationListener : this.modificationListeners) {
            modificationListener.objectModified(new ModificationEvent<RadioButton>(this, !this.isSelected(), this.isSelected()));
        }
    }
}

