/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComponentBuilder;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;

public abstract class OkCancelDialog
extends Dialog {
    protected UiContainer additionalButtons;
    protected Button cancelButton;
    protected Button okButton;
    private UiContainer contentPane;
    private CheckBox dontShowAgainCheck;
    private boolean dontShowAgainDialog = false;

    public OkCancelDialog(UiWindow parent) {
        this(parent, true);
    }

    public OkCancelDialog(UiWindow parent, Msg title) {
        this(parent, title, true);
    }

    public OkCancelDialog(UiWindow owner, boolean modal) {
        super(owner, modal);
        this.build();
    }

    public OkCancelDialog(UiWindow owner, Msg msg, boolean modal) {
        this(owner, msg, modal, false);
    }

    public OkCancelDialog(UiWindow owner, Msg msg, boolean modal, boolean dontShowAgainDialog) {
        super(owner, msg, modal);
        this.dontShowAgainDialog = dontShowAgainDialog;
        this.build();
    }

    public abstract void ok();

    public static boolean showComponent(UiWindow owner, ComponentBuilder builder, Msg title) {
        OkCancelDialog dialog = new OkCancelDialog(owner, title, true){

            @Override
            public void ok() {
                this.close();
            }
        };
        return OkCancelDialog.doShowDialog(dialog, builder);
    }

    public static boolean showComponent(UiWindow owner, UiComponent component, Msg title) {
        OkCancelDialog dialog = new OkCancelDialog(owner, title, true){

            @Override
            public void ok() {
                this.close();
            }
        };
        return OkCancelDialog.doShowDialog(dialog, component);
    }

    public static boolean doShowDialog(OkCancelDialog dialog, UiComponent component) {
        dialog.getContentPane().add(component, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    public static boolean doShowDialog(OkCancelDialog dialog, ComponentBuilder builder) {
        UiComponent component = builder.buildComponent(dialog.getContentPane());
        return OkCancelDialog.doShowDialog(dialog, component);
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWING);
        OkCancelDialog dialog = new OkCancelDialog(null){

            @Override
            public void ok() {
            }

            @Override
            protected UiComponent internalBuildButtons(UiContainer parent) {
                UiComponent component = super.internalBuildButtons(parent);
                this.addAditionalButton(new Button[]{new Button(this.getAditionalButtonsAddPoint(), UIMsg.WARNING), new Button(this.getAditionalButtonsAddPoint(), UIMsg.ERROR)});
                return component;
            }
        };
        dialog.setTitle("test");
        UiContainer contentPane = ((UiWindow)dialog).getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(OkCancelDialog.buildTabbedPane(contentPane), "Center");
        dialog.setSize(400, 300);
        ((UiComponent)dialog).setVisible(true);
    }

    public void enableOk(boolean enable) {
        this.okButton.setEnabled(enable);
    }

    @Override
    public UiContainer getContentPane() {
        return this.contentPane;
    }

    @Override
    public void accept() {
        this.ok();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setDefaultButton(this.okButton);
        }
        super.setVisible(visible);
    }

    public boolean doShowDialogAgain() {
        return this.dontShowAgainCheck != null && !this.dontShowAgainCheck.isSelected();
    }

    protected UiContainer getAditionalButtonsAddPoint() {
        return this.additionalButtons;
    }

    protected void addAditionalButton(Button[] newButtons) {
        for (Button additionalButton : newButtons) {
            this.additionalButtons.add(additionalButton);
            this.additionalButtons.add(Box.createHorizontalStrut(this.additionalButtons, 5));
        }
    }

    protected UiComponent internalBuildButtons(UiContainer parent) {
        Panel buttonPanel = new Panel(parent);
        buttonPanel.setLayout(new BorderLayout(5, 5));
        Box regularButtons = Box.createHorizontalBox(buttonPanel);
        this.additionalButtons = Box.createHorizontalBox(regularButtons);
        regularButtons.add(this.additionalButtons);
        this.okButton = Button.createOk(regularButtons);
        this.okButton.addActionListener(new OkAction());
        regularButtons.add(this.okButton);
        regularButtons.add(Box.createHorizontalStrut(regularButtons, 5));
        this.cancelButton = Button.createCancel(regularButtons);
        this.cancelButton.addActionListener(new CancelAction());
        regularButtons.add(this.cancelButton);
        regularButtons.add(Box.createHorizontalStrut(regularButtons, 5));
        Box helpPanel = Box.createHorizontalBox(buttonPanel);
        helpPanel.add(Box.createHorizontalStrut(helpPanel, 5));
        helpPanel.add(this.createHelpButton(buttonPanel));
        buttonPanel.add(Box.createVerticalStrut(buttonPanel, 3), "North");
        buttonPanel.add(helpPanel, "West");
        buttonPanel.add(regularButtons, "East");
        buttonPanel.add(Box.createVerticalStrut(buttonPanel, 3), "South");
        this.okButton.setDefaultCapable(true);
        this.setDefaultButton(this.okButton);
        return buttonPanel;
    }

    private static TabbedPane buildTabbedPane(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent);
        TabbedPane tabbedPane2 = new TabbedPane(tabbedPane);
        TextArea ta = new TextArea(tabbedPane2);
        ta.setText("This is a textArea");
        ta.setColumns(40);
        ta.setRows(5);
        SplitPane splitPane = new SplitPane(tabbedPane2);
        splitPane.setOneTouchExpandable(true);
        Panel redPanel = new Panel(splitPane, UIMsg.TO_MSG("RED"));
        redPanel.setBackground(Color.RED);
        splitPane.setLeftComponent(redPanel);
        redPanel.add(new TextField((UiContainer)redPanel, 20));
        Panel rightPanel = new Panel(splitPane, UIMsg.TO_MSG("The Big Table"));
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add(new TextField((UiContainer)rightPanel, 20), "Center");
        splitPane.setRightComponent(rightPanel);
        splitPane.setResizeWeight(0.25);
        tabbedPane2.addTab(UIMsg.TO_MSG("TextArea"), (UiComponent)ta);
        tabbedPane2.addTab(UIMsg.TO_MSG("ComplexTable"), (UiComponent)splitPane);
        TextArea ta2 = new TextArea(tabbedPane);
        ta.setColumns(40);
        ta.setRows(5);
        tabbedPane.addTab(UIMsg.TO_MSG("My Tab"), (UiComponent)ta2);
        tabbedPane.addTab(UIMsg.TO_MSG("My Label"), (UiComponent)tabbedPane2);
        return tabbedPane;
    }

    private void build() {
        UiContainer pane = super.getContentPane();
        if (this.dontShowAgainDialog) {
            BorderPanel newContainer = new BorderPanel(pane);
            newContainer.setLayout(new BorderLayout());
            pane.add(newContainer, "Center");
            pane.add(this.createDontShowAgain(pane), "South");
            pane = newContainer;
        }
        this.contentPane = new Panel(pane);
        this.contentPane.setLayout(new BorderLayout());
        pane.add(this.contentPane, "Center");
        pane.add(this.internalBuildButtons(pane), "South");
    }

    private CheckBox createDontShowAgain(UiContainer parent) {
        this.dontShowAgainCheck = CheckBox.create(parent, UIMsg.DO_NOT_SHOW_THIS_MESSAGE);
        return this.dontShowAgainCheck;
    }

    private final class OkAction
    extends BaseAction
    implements ActionListener {
        private OkAction() {
        }

        @Override
        public void run() {
            boolean focus = OkCancelDialog.this.okButton.requestFocusInWindow();
            if (!focus && !OkCancelDialog.this.okButton.hasFocus()) {
                return;
            }
            OkCancelDialog.this.setUserAccepted(true);
            OkCancelDialog.this.ok();
        }
    }

    private final class CancelAction
    extends BaseAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void run() {
            OkCancelDialog.this.cancel();
        }
    }
}

