/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.Component;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonEffect;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.event.SwingChangeListener;
import oracle.bpm.ui.text.TextArea;

public class HScroll
extends Panel
implements ActionListener,
SwingConstants {
    private Component component;
    private int currentX = 0;
    private int diff;
    private Button eastButton;
    private float eval = 0.1f;
    private int increment = 22;
    private boolean isUpdating;
    private int targetX = 0;
    private Timer timer;
    private JViewport viewport;
    private Button westButton;

    public HScroll(UiContainer parent, UiComponent component) {
        this(parent, component.asSwing(), 4);
    }

    public HScroll(UiContainer parent, Component component) {
        this(parent, component, 4);
    }

    public HScroll(UiContainer parent, Component component, int buttonPosition) {
        super(parent);
        this.component = component;
        this.init(buttonPosition);
    }

    public static void main(String[] args) {
        Frame frame = new Frame();
        frame.centerOnScreen();
        ToolBar toolBar = new ToolBar((UiContainer)null);
        UiContainer contentPane = frame.getContentPane();
        HScroll hScrollToolBar = new HScroll(contentPane, toolBar);
        hScrollToolBar.setIncrement(22);
        toolBar.add(HScroll.createAction(UIMsg.OPEN));
        toolBar.add(HScroll.createAction(UIMsg.CLOSE));
        toolBar.add(HScroll.createAction(UIMsg.CLOSE_ALL));
        toolBar.add(HScroll.createAction(UIMsg.ADD));
        contentPane.add(hScrollToolBar, "North");
        TextArea textArea = new TextArea(contentPane);
        textArea.setRows(30);
        textArea.setColumns(40);
        contentPane.add(textArea, "Center");
        frame.setSize(200, 200);
        frame.setVisible(true);
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getIncrement() {
        return this.increment;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Dimension viewportSize = AwtConverter.fromAwt(this.viewport.getExtentSize());
        Dimension componentSize = AwtConverter.fromAwt(this.viewport.getView().getPreferredSize());
        Point position = AwtConverter.fromAwt(this.viewport.getViewPosition());
        int increment = this.getIncrement();
        if (event.getSource() == this.westButton) {
            if (componentSize.getWidth() > viewportSize.getWidth()) {
                this.eastButton.setEnabled(true);
            }
            if (position.getX() <= increment) {
                this.update(0, position.getX());
                this.westButton.setEnabled(false);
            } else {
                this.update(position.getX() - increment, position.getX());
                if (position.getX() == 0) {
                    this.westButton.setEnabled(false);
                }
            }
        } else if (event.getSource() == this.eastButton) {
            if (componentSize.getWidth() > viewportSize.getWidth()) {
                this.westButton.setEnabled(true);
            }
            int max = componentSize.getWidth() - viewportSize.getWidth();
            if (position.getX() >= max - increment) {
                viewportSize = AwtConverter.fromAwt(this.viewport.getExtentSize());
                int targetx = componentSize.getWidth() - viewportSize.getWidth();
                this.update(targetx, position.getX());
                this.eastButton.setEnabled(false);
            } else {
                this.update(position.getX() + increment, position.getX());
            }
        } else {
            this.updateViewport();
        }
        this.revalidate();
    }

    public Component getComponent() {
        return this.component;
    }

    private static BaseAction createAction(Msg msg) {
        return new BaseAction(msg){

            @Override
            public void run() {
            }
        };
    }

    private static Button createButton(UiContainer parent, Msg msg) {
        Button button = new Button(parent, msg, 2);
        Image icon = Image.create(msg);
        Dimension buttonSize = Dimension.valueOf(icon.getIconWidth() + 4, ToolBar.ICON_HEIGHT);
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ButtonEffect.setEffect(button);
        button.setMinimumSize(buttonSize);
        button.setPreferredSize(buttonSize);
        button.setMaximumSize(buttonSize);
        return button;
    }

    private ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (HScroll.this.isUpdating) {
                    return;
                }
                JViewport viewport = (JViewport)e.getSource().asSwing();
                if (viewport == null || viewport.getView() == null) {
                    return;
                }
                Dimension componentSize = UiComponent.get(viewport.getView()).getPreferredSize();
                Dimension viewportSize = AwtConverter.fromAwt(viewport.getExtentSize());
                int compWidth = componentSize.getWidth();
                int viewWidth = viewportSize.getWidth();
                HScroll.this.eastButton.setEnabled(false);
                if (compWidth > viewWidth) {
                    HScroll.this.eastButton.setEnabled(true);
                } else {
                    HScroll.this.westButton.setEnabled(false);
                    HScroll.this.eastButton.setEnabled(false);
                }
                HScroll.this.updateLayout();
            }
        };
    }

    private Button createSeparator(UiContainer parent) {
        Button button = new Button(parent, UIMsg.HTOOLBAR_SEP, 2);
        Image icon = Image.create(UIMsg.HTOOLBAR_SEP);
        Dimension buttonSize = Dimension.valueOf(icon.getIconWidth(), icon.getIconHeight());
        button.setBorder(null);
        button.setFocusPainted(false);
        button.setMinimumSize(buttonSize);
        button.setPreferredSize(buttonSize);
        button.setMaximumSize(buttonSize);
        button.setEnabled(false);
        return button;
    }

    private void init(int buttonPosition) {
        this.setLayout(new BorderLayout());
        this.viewport = new JViewport();
        this.viewport.setView(this.component);
        this.add(UiComponent.get(this.viewport), "Center");
        this.westButton = HScroll.createButton(this, UIMsg.HTOOLBAR_LEFT);
        this.eastButton = HScroll.createButton(this, UIMsg.HTOOLBAR_RIGHT);
        this.layoutButtons(buttonPosition);
        this.westButton.setEnabled(false);
        this.eastButton.setEnabled(false);
        this.viewport.addChangeListener(SwingChangeListener.get(this.createChangeListener()));
        this.westButton.addActionListener(this);
        this.eastButton.addActionListener(this);
        this.timer = new Timer(20, this);
        this.timer.setCoalesce(true);
        this.timer.setRepeats(true);
    }

    private void layoutButtons(int buttonPosition) {
        if (buttonPosition == 0) {
            this.add(this.eastButton, "East");
            this.add(this.westButton, "West");
        } else if (buttonPosition == 2) {
            Panel panel = new Panel(this);
            panel.setLayout(new FlowLayout(1, 0, 0));
            panel.add(this.westButton);
            panel.add(this.eastButton);
            this.add(panel, "West");
        } else {
            Panel panel = new Panel(this);
            panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            FormLayout layout = new FormLayout("pref, pref, pref", "pref");
            PanelBuilder builder = layout.createBuilder(panel);
            CellConstraints cc = layout.createCellConstraints();
            builder.add((UiComponent)this.createSeparator(panel), cc.xy(1, 1));
            builder.add((UiComponent)this.westButton, cc.xy(2, 1));
            builder.add((UiComponent)this.eastButton, cc.xy(3, 1));
            this.add(panel, "East");
        }
    }

    private void startTimer() {
        this.timer.start();
    }

    private void stopTimer() {
        this.timer.stop();
        this.isUpdating = false;
    }

    private void update(int targetX, int currentX) {
        this.isUpdating = true;
        this.targetX = targetX;
        this.currentX = currentX;
        this.diff = targetX - currentX;
        this.startTimer();
    }

    private void updateLayout() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HScroll.this.revalidate();
                HScroll.this.repaint();
            }
        };
        UiUtilities.invokeLater(runnable);
    }

    private void updateViewport() {
        this.eval = (float)((double)this.eval + 0.1);
        this.currentX = (int)((float)this.currentX + (float)this.diff * this.eval);
        if (this.diff >= 0) {
            if (this.currentX >= this.targetX) {
                this.currentX = this.targetX;
                this.eval = 0.1f;
                this.viewport.setViewPosition(AwtConverter.toAwt(new Point(this.currentX, 0)));
                this.stopTimer();
                return;
            }
        } else if (this.targetX >= this.currentX) {
            this.currentX = this.targetX;
            this.eval = 0.1f;
            this.viewport.setViewPosition(AwtConverter.toAwt(new Point(this.currentX, 0)));
            this.stopTimer();
            return;
        }
        this.viewport.setViewPosition(AwtConverter.toAwt(new Point(this.currentX, 0)));
    }
}

