/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemListener;

public class EnumRadioPanel
extends Panel {
    private final Enum[] enumValues;
    private boolean horizontalAlignment;
    private TreeMap<Enum, RadioButton> radioButtons;

    private EnumRadioPanel(UiContainer parent, Enum[] enumValue, boolean horizontalAlignment) {
        super(parent);
        this.enumValues = enumValue;
        this.horizontalAlignment = horizontalAlignment;
        this.build();
    }

    public static EnumRadioPanel create(UiContainer parent, Enum[] enumValue, boolean horizontalAlignment) {
        return new EnumRadioPanel(parent, enumValue, horizontalAlignment);
    }

    public boolean isHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (RadioButton radioButton : this.getRadioButtons().values()) {
            radioButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void addItemListener(ItemListener itemListener) {
        Collection<RadioButton> radioButtons = this.getRadioButtons().values();
        for (RadioButton radioButton : radioButtons) {
            radioButton.addItemListener(itemListener);
        }
    }

    public Enum getSelectedEnumValue() {
        for (Map.Entry<Enum, RadioButton> entry : this.getRadioButtons().entrySet()) {
            Enum theEnum = entry.getKey();
            RadioButton radioButton = entry.getValue();
            if (!radioButton.isSelected()) continue;
            return theEnum;
        }
        return null;
    }

    public void setSelectedEnumValue(Enum value) {
        RadioButton radioButton = this.getRadioButtons().get(value);
        radioButton.setSelected(true);
    }

    protected TreeMap<Enum, RadioButton> getRadioButtons() {
        return this.radioButtons;
    }

    private void build() {
        this.radioButtons = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                Enum a = (Enum)o1;
                Enum b = (Enum)o2;
                return a.ordinal() - b.ordinal();
            }
        });
        ButtonGroup group = new ButtonGroup();
        for (Enum anEnum : this.enumValues) {
            String s = anEnum instanceof I18nProvider ? ((I18nProvider)((Object)anEnum)).getString() : anEnum.toString();
            RadioButton radioButton = new RadioButton((UiContainer)this, s);
            this.getRadioButtons().put(anEnum, radioButton);
            group.add(radioButton);
        }
    }
}

