/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public abstract class EditedTreeCombo
extends Panel {
    private Button button;
    private List<TreeSelectionListener> listeners = new ArrayList<TreeSelectionListener>();
    private TextField textField;
    private String textValue;
    private TreeNode value;

    protected EditedTreeCombo(UiContainer parent) {
        super(parent);
        String cols = "pref, 1dlu, pref";
        String rows = "pref";
        FormLayout layout = new FormLayout("pref, 1dlu, pref", "pref");
        PanelBuilder builder = layout.createBuilder(this);
        CellConstraints cc = layout.createCellConstraints();
        this.textField = new TextField(this);
        this.textField.setPreferredSize(Dimension.valueOf(250, 20));
        this.textField.setEditable(false);
        this.createArrowButton();
        builder.add((UiComponent)this.textField, cc.xy(1, 1));
        builder.add((UiComponent)this.button, cc.xy(3, 1));
    }

    public String getTextToSetInTextField(TreeNode node) {
        return node.toString();
    }

    public void setValue(String textValue) {
        this.textValue = textValue;
        this.textField.setText(this.textValue);
    }

    public String getValue() {
        return this.textValue;
    }

    public Object getValueObject() {
        return this.value;
    }

    public TreeNode getValueTreeNode() {
        return this.value;
    }

    public void addNodeSelectedListener(TreeSelectionListener treeSelectionListener) {
        this.listeners.add(treeSelectionListener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    protected abstract Tree createTree(UiContainer var1);

    protected void fireNodeSelected(TreeSelectionEvent e) {
        for (TreeSelectionListener treeSelectionListener : this.listeners) {
            treeSelectionListener.valueChanged(e);
        }
    }

    protected boolean doChange(TreeNode e) {
        return true;
    }

    private PopUpWindow buildPopup(UiWindow parent) {
        final PopUpWindow popup = new PopUpWindow(parent);
        popup.setBackground(Color.WHITE);
        Tree tree = this.createTree(popup);
        tree.addTreeSelectionListener(new TreeSelectionListener(){
            Timer timer;

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                EditedTreeCombo.this.value = (TreeNode)e.getPath().getLastPathComponent();
                if (EditedTreeCombo.this.doChange(EditedTreeCombo.this.value)) {
                    EditedTreeCombo.this.textValue = EditedTreeCombo.this.getTextToSetInTextField(EditedTreeCombo.this.value);
                    EditedTreeCombo.this.textField.setText(EditedTreeCombo.this.textValue);
                    EditedTreeCombo.this.fireNodeSelected(e);
                    this.timer = new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            timer.stop();
                        }
                    });
                    this.timer.start();
                }
            }
        });
        tree.setPreferredSize(Dimension.valueOf(250, 180));
        popup.add(tree);
        return popup;
    }

    private void createArrowButton() {
        this.button = new Button((UiContainer)this, UIMsg.COMBO_ARROW, 10);
        this.button.setRolloverEnabled(true);
        this.button.setRolloverIcon(Image.create(UIMsg.COMBO_ARROW_ROLL));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpWindow popup = EditedTreeCombo.this.buildPopup(EditedTreeCombo.this.textField.getOwnerWindow());
                popup.show(EditedTreeCombo.this.textField);
            }
        });
        this.button.setBorder(null);
        this.button.setBorderPainted(false);
        this.button.setContentAreaFilled(false);
    }
}

