/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DatesSimpleFormat
extends SimpleDateFormat {
    private int dayIndex;
    private int dayIndexEnd;
    private int[] daysInMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int monthIndex;
    private int monthIndexEnd;
    private int yearIndex;
    private int yearIndexEnd;
    static final long serialVersionUID = -4766450228056927035L;
    static final long serialCheck = 1237413705377792084L;

    public DatesSimpleFormat(String pattern) {
        super(pattern);
        int length = pattern.length();
        this.yearIndex = pattern.indexOf("yyyy");
        this.yearIndexEnd = this.yearIndex + 4;
        if (length > this.yearIndexEnd && pattern.charAt(this.yearIndexEnd) == 'y') {
            this.yearIndex = -1;
        }
        this.monthIndex = pattern.indexOf("MM");
        this.monthIndexEnd = this.monthIndex + 2;
        if (length > this.monthIndexEnd && pattern.charAt(this.monthIndexEnd) == 'M') {
            this.monthIndex = -1;
        }
        this.dayIndex = pattern.indexOf("dd");
        this.dayIndexEnd = this.dayIndex + 2;
        if (length > this.dayIndexEnd && pattern.charAt(this.dayIndexEnd) == 'd') {
            this.dayIndex = -1;
        }
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        try {
            int length;
            int n = length = source == null ? 0 : source.length();
            if (length == 0) {
                return null;
            }
            if ("20    -  -  ".equals(source)) {
                return null;
            }
            if (this.monthIndex != -1 && length >= this.monthIndexEnd) {
                int month = Integer.parseInt(source.substring(this.monthIndex, this.monthIndexEnd));
                if (month > 12) {
                    month = 12;
                    source = source.substring(0, this.monthIndex) + "12" + (length > 7 ? source.substring(this.monthIndexEnd) : "");
                } else if (month == 0) {
                    month = 1;
                    source = source.substring(0, this.monthIndex) + "01" + (length > 7 ? source.substring(this.monthIndexEnd) : "");
                }
                if (length >= 10 && this.dayIndex != -1) {
                    int day = Integer.parseInt(source.substring(this.dayIndex, this.dayIndexEnd));
                    if (day == 0) {
                        source = source.substring(0, this.dayIndex) + "01" + (length > 10 ? source.substring(this.dayIndexEnd) : "");
                    } else {
                        int limit = this.daysInMonth[month - 1];
                        if (day > limit) {
                            int year;
                            day = limit;
                            if (month == 2 && this.yearIndex != -1 && ((year = Integer.parseInt(source.substring(this.yearIndex, this.yearIndexEnd))) % 4 != 0 || year % 100 == 0 && year % 400 != 0)) {
                                day = 28;
                            }
                            source = source.substring(0, 8) + day + (length > 10 ? source.substring(10) : "");
                        }
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return super.parseObject(source);
    }
}

