/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiPeer;
import oracle.bpm.ui.peer.CursorPeer;
import oracle.bpm.ui.peer.Peer;

public class Cursor
extends UiPeer {
    private CursorPeer cursor;
    private CursorType cursorType;
    private static Map<CursorType, Cursor> cursors = new HashMap<CursorType, Cursor>();
    public static final Cursor WAIT_CURSOR = new Cursor(CursorType.WAIT_CURSOR);
    public static final Cursor DEFAULT_CURSOR = new Cursor(CursorType.DEFAULT_CURSOR);
    public static final Cursor HAND_CURSOR = new Cursor(CursorType.HAND_CURSOR);
    public static final Cursor TEXT_CURSOR = new Cursor(CursorType.TEXT_CURSOR);
    public static final Cursor CROSSHAIR_CURSOR = new Cursor(CursorType.CROSSHAIR_CURSOR);
    public static final Cursor CROSS_HAIR_CURSOR = new Cursor(CursorType.CROSSHAIR_CURSOR);
    public static final Cursor MOVE_CURSOR = new Cursor(CursorType.MOVE_CURSOR);
    public static final Cursor COPY_DROP = new Cursor(CursorType.COPY_DROP);
    public static final Cursor COPY_NO_DROP = new Cursor(CursorType.COPY_NO_DROP);
    public static final Cursor LINK_DROP = new Cursor(CursorType.LINK_DROP);
    public static final Cursor LINK_NO_DROP = new Cursor(CursorType.LINK_NO_DROP);
    public static final Cursor MOVE_DROP = new Cursor(CursorType.MOVE_DROP);
    public static final Cursor N_RESIZE_CURSOR = new Cursor(CursorType.N_RESIZE_CURSOR);
    public static final Cursor W_RESIZE_CURSOR = new Cursor(CursorType.W_RESIZE_CURSOR);
    public static final Cursor S_RESIZE_CURSOR = new Cursor(CursorType.S_RESIZE_CURSOR);
    public static final Cursor E_RESIZE_CURSOR = new Cursor(CursorType.E_RESIZE_CURSOR);
    public static final Cursor NS_RESIZE_CURSOR = new Cursor(CursorType.NS_RESIZE_CURSOR);
    public static final Cursor WE_RESIZE_CURSOR = new Cursor(CursorType.WE_RESIZE_CURSOR);
    public static final Cursor SW_RESIZE_CURSOR = new Cursor(CursorType.SW_RESIZE_CURSOR);
    public static final Cursor SE_RESIZE_CURSOR = new Cursor(CursorType.SE_RESIZE_CURSOR);
    public static final Cursor NW_RESIZE_CURSOR = new Cursor(CursorType.NW_RESIZE_CURSOR);
    public static final Cursor NE_RESIZE_CURSOR = new Cursor(CursorType.NE_RESIZE_CURSOR);

    private Cursor(CursorType cursorType) {
        this.cursorType = cursorType;
    }

    private Cursor(CursorPeer peer) {
        this.cursor = peer;
    }

    public static Cursor getDefaultCursor() {
        return DEFAULT_CURSOR;
    }

    public static Cursor get(CursorType cursorType) {
        Cursor result = cursors.get((Object)cursorType);
        if (result == null) {
            result = new Cursor(cursorType);
            cursors.put(cursorType, result);
        }
        return result;
    }

    public static Cursor createCustom(Image image, Point hotSpot, String name) {
        return new Cursor(Ui.getUiFactory().createCursor(image, hotSpot, name));
    }

    public java.awt.Cursor asAwtCursor() {
        Object nativeComponent = this.getCursor().getNative();
        if (!(nativeComponent instanceof java.awt.Cursor)) {
            throw new UnsupportedOperationException("Cannot return as Swing. It's a " + nativeComponent.getClass().getName());
        }
        java.awt.Cursor awtCursor = (java.awt.Cursor)nativeComponent;
        return awtCursor;
    }

    public CursorPeer getCursor() {
        return (CursorPeer)this.createPeer();
    }

    @Override
    protected Peer createPeer() {
        if (this.cursor == null) {
            this.cursor = Ui.getUiFactory().createCursor(this.cursorType);
        }
        return this.cursor;
    }

    public static enum CursorType {
        WAIT_CURSOR,
        DEFAULT_CURSOR,
        HAND_CURSOR,
        E_RESIZE_CURSOR,
        TEXT_CURSOR,
        CROSSHAIR_CURSOR,
        S_RESIZE_CURSOR,
        MOVE_CURSOR,
        W_RESIZE_CURSOR,
        WE_RESIZE_CURSOR,
        NS_RESIZE_CURSOR,
        N_RESIZE_CURSOR,
        SW_RESIZE_CURSOR,
        SE_RESIZE_CURSOR,
        NW_RESIZE_CURSOR,
        NE_RESIZE_CURSOR,
        COPY_DROP,
        LINK_DROP,
        LINK_NO_DROP,
        COPY_NO_DROP,
        MOVE_DROP,
        MOVE_NO_DROP;

    }
}

