/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Properties;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.CommonPreferences;

public class ConnectionPreferencesPanel
extends Panel {
    private TextField httpProxyHostTextField;
    private NumericField<Integer> httpProxyPortTextField;
    private RadioButton manualProxyRadio;

    public ConnectionPreferencesPanel(UiContainer parent) {
        super(parent);
        this.init();
    }

    public void store() {
        String proxyHost = this.httpProxyHostTextField.getText();
        String proxyPort = this.httpProxyPortTextField.getValue().toString();
        boolean manualProxyConfiguration = this.manualProxyRadio.isSelected();
        CommonPreferences preferences = CommonPreferences.getInstance();
        preferences.setUseProxyConfiguration(manualProxyConfiguration);
        preferences.setHttpProxyHost(proxyHost);
        preferences.setHttpProxyPort(proxyPort);
        preferences.store();
        Properties newProps = System.getProperties();
        if (manualProxyConfiguration) {
            newProps.setProperty("http.proxyHost", proxyHost);
            newProps.setProperty("http.proxyPort", proxyPort);
        } else {
            newProps.remove("http.proxyHost");
            newProps.remove("http.proxyPort");
        }
        System.setProperties(newProps);
    }

    public void registerChange() {
    }

    private void init() {
        CommonPreferences preferences = CommonPreferences.getInstance();
        final RadioButton directConnectionRadio = new RadioButton((UiContainer)this, UIMsg.DIRECT_CONNECTION_TO_THE_INTERNET);
        directConnectionRadio.setSelected(!preferences.getUseProxyConfiguration());
        this.manualProxyRadio = new RadioButton((UiContainer)this, UIMsg.MANUAL_PROXY_CONFIGURATION);
        this.manualProxyRadio.setSelected(preferences.getUseProxyConfiguration());
        Panel manualProxyPanel = new Panel(this);
        this.httpProxyHostTextField = this.addTextField(manualProxyPanel, UIMsg.HTTP_PROXY, preferences.getHttpProxyHost(), 20);
        this.httpProxyPortTextField = this.addNumericField(manualProxyPanel, UIMsg.PORT, preferences.getHttpProxyPort(), 10);
        final ItemListener directConnectionItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConnectionPreferencesPanel.this.manualProxyRadio.setSelected(!directConnectionRadio.isSelected());
                ConnectionPreferencesPanel.this.registerChange();
            }
        };
        directConnectionRadio.addItemListener(directConnectionItemListener);
        this.manualProxyRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean manualProxySelected = ConnectionPreferencesPanel.this.manualProxyRadio.isSelected();
                directConnectionRadio.removeItemListener(directConnectionItemListener);
                directConnectionRadio.setSelected(!manualProxySelected);
                directConnectionRadio.addItemListener(directConnectionItemListener);
                ConnectionPreferencesPanel.this.httpProxyHostTextField.setEnabled(manualProxySelected);
                ConnectionPreferencesPanel.this.httpProxyPortTextField.setEnabled(manualProxySelected);
                ConnectionPreferencesPanel.this.registerChange();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.add(directConnectionRadio);
        this.add(this.manualProxyRadio);
        this.add(manualProxyPanel);
    }

    private TextField addTextField(Panel container, Msg label, String text, int columns) {
        boolean useProxyConfiguration = CommonPreferences.getInstance().getUseProxyConfiguration();
        container.add(Label.create((UiContainer)container, label));
        TextField textField = new TextField((UiContainer)container, text, columns);
        textField.setEnabled(useProxyConfiguration);
        textField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                ConnectionPreferencesPanel.this.registerChange();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        container.add(textField);
        return textField;
    }

    private NumericField<Integer> addNumericField(Panel container, Msg label, String text, int columns) {
        boolean useProxyConfiguration = CommonPreferences.getInstance().getUseProxyConfiguration();
        container.add(Label.create((UiContainer)container, label));
        NumericField<Integer> numericField = NumericField.createIntegerNumericField(container);
        numericField.setColumns(columns);
        numericField.setEnabled(useProxyConfiguration);
        numericField.setGroupingUsed(false);
        numericField.setRange(0, 32768);
        try {
            numericField.setValue(Integer.valueOf(text));
        }
        catch (NumberFormatException nfe) {
            numericField.setValue(0);
        }
        numericField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                ConnectionPreferencesPanel.this.registerChange();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        container.add(numericField);
        return numericField;
    }
}

