/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public abstract class CloseableDialog
extends Dialog {
    private Panel buttonsPanel;
    private UiContainer contentPane;

    public CloseableDialog(UiWindow owner) {
        super(owner);
        this.build();
    }

    public CloseableDialog(UiWindow owner, Msg msg) {
        this(owner, msg, true);
    }

    public CloseableDialog(UiWindow owner, Msg msg, boolean modal) {
        super(owner, msg, modal);
        this.build();
    }

    public abstract void ok();

    public static boolean showComponent(UiWindow owner, UiComponent component, Msg title) {
        CloseableDialog dialog = new CloseableDialog(owner, title, true){

            @Override
            public void ok() {
                this.close();
            }
        };
        Panel panel = new Panel(dialog);
        String colSpecs = "5dlu,pref,5dlu";
        String rowSpecs = "5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add(component, cc.xy(2, 2));
        dialog.getContentPane().add(panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    public Panel getButtonsPanel() {
        return this.buttonsPanel;
    }

    @Override
    public UiContainer getContentPane() {
        return this.contentPane;
    }

    @Override
    public void accept() {
        this.ok();
    }

    private Panel buildButtons(UiContainer parent) {
        Panel buttonPanel = new Panel(parent);
        buttonPanel.setLayout(new BorderLayout(5, 5));
        Box regularButtons = Box.createHorizontalBox(buttonPanel);
        Button closeButton = Button.createClose(buttonPanel);
        closeButton.setDefaultCapable(true);
        this.setDefaultButton(closeButton);
        closeButton.addActionListener(new OkAction());
        regularButtons.add(closeButton);
        regularButtons.add(Box.createHorizontalStrut(regularButtons, 5));
        Box helpPanel = Box.createHorizontalBox(buttonPanel);
        helpPanel.add(Box.createHorizontalStrut(helpPanel, 5));
        helpPanel.add(this.createHelpButton(buttonPanel));
        buttonPanel.add(helpPanel, "West");
        buttonPanel.add(regularButtons, "East");
        buttonPanel.add(Box.createVerticalStrut(buttonPanel, 3), "South");
        return buttonPanel;
    }

    private void build() {
        UiContainer uiContainer = super.getContentPane();
        this.contentPane = new Panel(uiContainer);
        this.contentPane.setLayout(new BorderLayout());
        uiContainer.add(this.contentPane, "Center");
        this.buttonsPanel = this.buildButtons(uiContainer);
        uiContainer.add(this.buttonsPanel, "South");
    }

    private final class OkAction
    extends BaseAction
    implements ActionListener {
        private OkAction() {
        }

        @Override
        public void run() {
            CloseableDialog.this.ok();
            CloseableDialog.this.setUserAccepted(true);
        }
    }
}

