/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.peer.AbstractButtonPeer;
import oracle.bpm.ui.peer.Peer;

public class CheckBox
extends ToggleButton
implements Editable {
    private ItemListener changeListener;
    private ArrayList<ModificationListener> modificationListeners = new ArrayList();
    private boolean oldValue;
    public static int OPTIONS = 255;

    public CheckBox(UiContainer parent) {
        super(parent, OPTIONS);
        UiUtilities.addToEditableContainer(this, this.getParent());
    }

    protected CheckBox(UiContainer parent, String text, boolean selected) {
        super(parent, OPTIONS);
        this.setText(text);
        this.setSelected(selected);
        UiUtilities.addToEditableContainer(this, this.getParent());
    }

    private CheckBox(UiContainer parent, BaseAction a) {
        super(parent, a);
        UiUtilities.addToEditableContainer(this, this.getParent());
    }

    private CheckBox(UiContainer parent, Msg msg, boolean selected) {
        super(parent, OPTIONS);
        this.setMsg(msg);
        this.setSelected(selected);
        if (msg != null) {
            this.setName(msg.getCode());
        }
        UiUtilities.addToEditableContainer(this, this.getParent());
    }

    public static CheckBox create(UiContainer parent) {
        return CheckBox.create(parent, (Msg)null);
    }

    public static CheckBox create(UiContainer parent, Msg msg) {
        return CheckBox.create(parent, msg, false);
    }

    public static CheckBox create(UiContainer parent, Msg msg, boolean selected) {
        return new CheckBox(parent, msg, selected);
    }

    public static CheckBox create(UiContainer parent, BaseAction action) {
        return new CheckBox(parent, action);
    }

    @Override
    public AbstractButtonPeer getAbstractPeer() {
        return (AbstractButtonPeer)this.getPeer();
    }

    @Override
    public boolean isModified() {
        return this.oldValue != this.isSelected();
    }

    @Override
    public void resetModified() {
        this.oldValue = this.isSelected();
    }

    @Override
    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
        if (this.changeListener == null) {
            this.changeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CheckBox.this.fireChanged();
                }
            };
            this.addItemListener(this.changeListener);
        }
    }

    @Override
    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
        if (this.modificationListeners.isEmpty()) {
            this.removeItemListener(this.changeListener);
            this.changeListener = null;
        }
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createCheckBox(this.getParentPeer());
    }

    @Override
    protected void update() {
        Msg msg = this.getMsg();
        if (msg == null) {
            return;
        }
        int options = this.getOptions();
        if ((options & 1) != 0) {
            super.setText(msg.getString());
        }
        if ((options & 4) != 0) {
            super.setMnemonic(msg.getMnemonic());
        }
        if ((options & 8) != 0) {
            String tooltip = msg.getDetail();
            if ("".equals(tooltip)) {
                tooltip = msg.getString();
            }
            super.setToolTipText(tooltip);
        }
    }

    private void fireChanged() {
        for (ModificationListener modificationListener : this.modificationListeners) {
            modificationListener.objectModified(new ModificationEvent<CheckBox>(this, !this.isSelected(), this.isSelected()));
        }
    }
}

