/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.utils.Layout;

public class ChangePasswordDialog
extends OkCancelDialog {
    private PasswordField confirmPasswordField;
    private String password;
    private PasswordField passwordField;
    private static final int DEFAULT_SIZE = 20;

    public ChangePasswordDialog(UiWindow parent) {
        super(parent);
        this.init();
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void ok() {
        String pass2;
        String pass1 = new String(this.passwordField.getPassword());
        if (this.verifyPassword(pass1, pass2 = new String(this.confirmPasswordField.getPassword()))) {
            this.password = pass1;
            this.dispose();
        }
    }

    private void init() {
        Panel dataPanel = new Panel(this.getContentPane());
        RelativeLayout layout = new RelativeLayout();
        dataPanel.setLayout(layout);
        this.confirmPasswordField = new PasswordField((UiContainer)dataPanel, "", 20);
        this.passwordField = new PasswordField((UiContainer)dataPanel, "", 20);
        Label label1 = Label.create((UiContainer)dataPanel, UIMsg.PASSWORD);
        Label label2 = Label.create((UiContainer)dataPanel, CoreMsg.CONFIRM_PASSWORD);
        dataPanel.add(label1, "passwordLabel");
        dataPanel.add(this.passwordField, "password");
        dataPanel.add(label2, "confirmationLabel");
        dataPanel.add(this.confirmPasswordField, "passwordConfirmation");
        Layout.fixToRoot(layout, "passwordLabel", AttributeType.LEFT, 5);
        Layout.fixToComp(layout, "passwordLabel", AttributeType.VERTICAL_CENTER, "password");
        Layout.fixToComp(layout, "password", AttributeType.LEFT, "passwordLabel", AttributeType.RIGHT, 5);
        Layout.fixToRoot(layout, "password", AttributeType.RIGHT, -5);
        Layout.fixToComp(layout, "confirmationLabel", AttributeType.VERTICAL_CENTER, "passwordConfirmation");
        Layout.fixToRoot(layout, "confirmationLabel", AttributeType.LEFT, 5);
        Layout.fixToRoot(layout, "password", AttributeType.TOP, 5);
        Layout.fixToComp(layout, "passwordConfirmation", AttributeType.TOP, "password", AttributeType.BOTTOM, 5);
        Layout.fixToComp(layout, "passwordConfirmation", AttributeType.LEFT, "confirmationLabel", AttributeType.RIGHT, 5);
        Layout.fixToRoot(layout, "passwordConfirmation", AttributeType.RIGHT, -5);
        layout.addConstraint("passwordLabel", AttributeType.WIDTH, new AttributeConstraint("confirmationLabel", AttributeType.WIDTH));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(dataPanel, "Center");
        this.requestFocus();
        this.setSize(250, 120);
        this.setLocationRelativeTo(this.getParent());
        this.passwordField.requestFocus();
        this.passwordField.grabFocus();
    }

    private boolean verifyPassword(String pass1, String pass2) {
        if (pass1.equals(pass2)) {
            return true;
        }
        MessageDialog.showError(UIMsg.PASSWORD, UIMsg.PASSWORDS_DONT_MATCH);
        return false;
    }
}

