/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.layout.BoxLayout;

public class Box
extends Panel {
    public Box(UiContainer target, int axis) {
        super(target);
        if (Ui.getType() == UiType.SWT && target == null) {
            throw new IllegalArgumentException("Parent cannot be null for Box");
        }
        this.setLayout(new BoxLayout(this, axis));
    }

    public static UiComponent createGlue(UiContainer parent) {
        return new Filler(parent, Dimension.ZERO, Dimension.ZERO, Dimension.valueOf(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public static Box createHorizontalBox(UiContainer target) {
        return new Box(target, 0);
    }

    public static UiComponent createHorizontalGlue(UiContainer parent) {
        return new Filler(parent, Dimension.ZERO, Dimension.ZERO, Dimension.valueOf(Short.MAX_VALUE, 0));
    }

    public static UiComponent createHorizontalStrut(UiContainer parent, int width) {
        return new Filler(parent, Dimension.valueOf(width, 0), Dimension.valueOf(width, 0), Dimension.valueOf(width, Short.MAX_VALUE));
    }

    public static UiComponent createRigidArea(UiContainer parent, Dimension d) {
        return new Filler(parent, d, d, d);
    }

    public static Box createVerticalBox(UiContainer target) {
        return new Box(target, 1);
    }

    public static UiComponent createVerticalGlue(UiContainer parent) {
        return new Filler(parent, Dimension.ZERO, Dimension.ZERO, Dimension.valueOf(0, Short.MAX_VALUE));
    }

    public static UiComponent createVerticalStrut(UiContainer parent, int height) {
        return new Filler(parent, Dimension.valueOf(0, height), Dimension.valueOf(0, height), Dimension.valueOf(Short.MAX_VALUE, height));
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWT);
        Frame frame = new Frame("Title");
        UiContainer contentPane = frame.getContentPane();
        Box panel = Box.createHorizontalBox(contentPane);
        panel.setBackground(Color.YELLOW);
        Button b1 = new Button(panel);
        b1.setText("b1");
        UiComponent rigidArea = Box.createRigidArea(panel, Dimension.valueOf(5, 0));
        Button b2 = new Button(panel);
        b2.setText("b2");
        UiComponent glueArea = Box.createHorizontalGlue(panel);
        Button b3 = new Button(panel);
        b3.setText("b3");
        panel.add(b1);
        panel.add(rigidArea);
        panel.add(b2);
        panel.add(glueArea);
        panel.add(b3);
        contentPane.add(panel, "Center");
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    public static class Filler
    extends Panel {
        private Dimension reqMax;
        private Dimension reqMin;
        private Dimension reqPref;

        public Filler(UiContainer parent, Dimension min, Dimension pref, Dimension max) {
            super(parent);
            this.setOpaque(false);
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.reqMax;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        public void changeShape(Dimension min, Dimension pref, Dimension max) {
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
        }
    }
}

