/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CollapsablePanel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class AccordeonPanelBuilder {
    private int componentCount = 0;
    private Panel container;
    private FormLayout formLayout;

    private AccordeonPanelBuilder(UiContainer parent) {
        this.container = new Panel(parent);
        this.formLayout = new FormLayout("pref:grow");
        this.container.setLayout(this.formLayout);
    }

    public static AccordeonPanelBuilder create(UiContainer parent) {
        return new AccordeonPanelBuilder(parent);
    }

    public static AccordeonPanelBuilder createScrollableSingleViewPanel(CollapsablePanel collapsablePanel) {
        ScrollPane scroll = new ScrollPane(collapsablePanel.getContainer());
        collapsablePanel.getContainer().add(scroll, "Center");
        AccordeonPanelBuilder panel = AccordeonPanelBuilder.createSingleViewPanel(scroll);
        scroll.setView(panel.getPanel());
        return panel;
    }

    public static AccordeonPanelBuilder createSingleViewPanel(UiContainer parent) {
        AccordeonPanelBuilder result = new AccordeonPanelBuilder(parent){
            private CollapsablePanel showingPanel;

            @Override
            public CollapsablePanel addCollapsable(Msg msg) {
                CollapsablePanel result = super.addCollapsable(msg);
                result.addVisibilityChangedListener(new CollapsablePanel.CollpaseStatusChangedListener(){

                    @Override
                    public void collapseStatusChanged(CollapsablePanel source, boolean newCollapsed) {
                        if (!newCollapsed) {
                            if (showingPanel != null && showingPanel != source) {
                                showingPanel.collapse(true);
                            }
                            showingPanel = source;
                        }
                    }
                });
                return result;
            }
        };
        return result;
    }

    public static AccordeonPanelBuilder addScrollableCollapsable(AccordeonPanelBuilder accordeonPanelBuilder, Msg msg) {
        CollapsablePanel collapsable = accordeonPanelBuilder.addCollapsable(msg);
        return AccordeonPanelBuilder.createScrollableSingleViewPanel(collapsable);
    }

    public final CollapsablePanel addCollapsable() {
        return this.addCollapsable(UIMsg.TO_MSG(""));
    }

    public CollapsablePanel addCollapsable(Msg msg) {
        this.formLayout.appendRow("pref");
        ++this.componentCount;
        CollapsablePanel panel = new CollapsablePanel(this.container, msg, true);
        this.container.add(panel, this.formLayout.createCellConstraints().xy(1, this.componentCount));
        return panel;
    }

    public Panel getPanel() {
        return this.container;
    }
}

