/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.swing.properties;

import java.io.StringWriter;
import java.util.List;
import java.util.WeakHashMap;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.swing.properties.AdvancedPropertyCategory;
import oracle.bpm.swing.properties.BasicPropertyCategory;
import oracle.bpm.swing.properties.FuegoPropertyCategory;
import oracle.bpm.swing.properties.InvalidPropertyValueException;
import oracle.bpm.swing.properties.MissingMandatoryValueException;
import oracle.bpm.swing.properties.PropertyListener;
import oracle.bpm.swing.properties.PropertyType;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

public class SingleProperty {
    protected FuegoPropertyCategory category_d;
    protected Object defaultValue_d;
    protected boolean editable_d;
    protected int index_d;
    protected String key_d;
    protected String label_d;
    protected WeakHashMap<PropertyListener, Object> listeners_d = new WeakHashMap();
    protected boolean required_d;
    protected String tooltip_d;
    protected PropertyType type_d;
    protected Object validatedValue_d;
    protected Object value_d;
    protected boolean visible_d;

    public SingleProperty(String key, String label, PropertyType type, Object value, boolean required, int index) {
        this(key, label, type, value, null, required, false, true, true, null, index);
    }

    public SingleProperty(String key, String label, PropertyType type, Object value, boolean required, boolean advanced, boolean isEditable, boolean isVisible, int index) {
        this(key, label, type, value, null, required, advanced, isEditable, isVisible, null, index);
    }

    public SingleProperty(String key, String label, PropertyType type, Object value, String tooltip, boolean required, boolean advanced, boolean isEditable, boolean isVisible, Object defaultValue, int index) {
        this.key_d = key;
        this.index_d = index;
        this.label_d = required ? label + " (*)" : label;
        this.editable_d = isEditable;
        this.visible_d = isVisible;
        this.category_d = advanced ? new AdvancedPropertyCategory() : new BasicPropertyCategory();
        this.tooltip_d = tooltip;
        this.required_d = required;
        this.value_d = value;
        this.defaultValue_d = defaultValue;
        this.type_d = type;
        this.validate(value);
    }

    public boolean isAdvanced() {
        return this.getCategory().isAdvanced();
    }

    public boolean isBasic() {
        return this.getCategory().isBasic();
    }

    public FuegoPropertyCategory getCategory() {
        return this.category_d;
    }

    public Object getDefaultValue() {
        if (this.defaultValue_d == null) {
            this.defaultValue_d = this.getType().getDefaultValue();
        }
        return this.defaultValue_d;
    }

    public void setEditable(boolean editable) {
        this.editable_d = editable;
    }

    public boolean isEditable() {
        return this.editable_d;
    }

    public UiComponent getField(UiContainer parent) {
        return this.getType().getField(parent, this);
    }

    public int getIndex() {
        return this.index_d;
    }

    public String getKey() {
        return this.key_d;
    }

    public String getLabel() {
        return this.label_d;
    }

    public List getPredefinedValues() {
        return this.getType().getPredefinedValues();
    }

    public void setRequired(boolean isRequired) {
        this.required_d = isRequired;
    }

    public boolean isRequired() {
        return this.required_d;
    }

    public String getTooltip() {
        return this.tooltip_d;
    }

    public PropertyType getType() {
        return this.type_d;
    }

    public void setValue(Object value) throws InvalidPropertyValueException {
        this.validate(value);
        this.value_d = value;
        this.fireDataChanged();
    }

    public Object getValue() {
        if (this.value_d != null) {
            return this.value_d;
        }
        return this.getDefaultValue();
    }

    public void setVisible(boolean visible) {
        this.visible_d = visible;
    }

    public boolean isVisible() {
        return this.visible_d;
    }

    public String getXMLString() {
        StringWriter writer = new StringWriter();
        IndentedPrintWriter indentedWriter = new IndentedPrintWriter(writer);
        this.writeXML(indentedWriter);
        return writer.toString();
    }

    public void addPropertyListener(PropertyListener listener) {
        this.listeners_d.put(listener, null);
    }

    public String displayString() {
        return "\n    > " + this.getKey() + " : " + this.getValue();
    }

    public boolean hasPredefinedValues() {
        return this.getPredefinedValues() == null || this.getPredefinedValues().size() != 0;
    }

    public void validate(Object value) throws InvalidPropertyValueException, MissingMandatoryValueException {
        this.getType().validate(this, value);
        this.setValidatedValue(value);
    }

    public void writeXML(IndentedPrintWriter writer) {
        writer.println();
        writer.println("<SingleProperty>");
        writer.indent();
        writer.println("<key>" + this.getKey() + "</key>");
        writer.println("<label>" + this.getLabel() + "</label>");
        writer.println("<tooltip>" + this.getTooltip() + "</tooltip>");
        writer.println("<editable>" + this.isEditable() + "</editable>");
        writer.println("<visible>" + this.isVisible() + "</visible>");
        writer.println("<required>" + this.isRequired() + "</required>");
        writer.println("<advanced>" + this.isAdvanced() + "</advanced>");
        writer.println("<default>" + this.getDefaultValue() + "</default>");
        writer.println("<value>" + this.getValue() + "</value>");
        writer.println("<type>" + this.getType().getName() + "</type>");
        writer.println("<predefinedVaues>");
        writer.indent();
        for (Object each : this.getPredefinedValues()) {
            writer.println("<predefinedValue>" + each + "</predefinedValue>");
        }
        writer.dedent();
        writer.println("</predefinedVaues>");
        writer.println("<index>" + this.getIndex() + "</index>");
    }

    protected Object getValidatedValue() {
        return this.validatedValue_d;
    }

    protected void fireDataChanged() {
        this.fireDataChanged(this);
    }

    protected void fireDataChanged(SingleProperty root) {
        for (PropertyListener listener : this.listeners_d.keySet().toArray(new PropertyListener[this.listeners_d.size()])) {
            if (listener == null) continue;
            listener.dataChanged(root);
        }
    }

    private void setValidatedValue(Object validatedValue) {
        this.validatedValue_d = validatedValue;
    }
}

