/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.swing.properties;

import oracle.bpm.swing.properties.InvalidPropertyValueException;
import oracle.bpm.swing.properties.MissingMandatoryValueException;
import oracle.bpm.swing.properties.PropertyFieldInterface;
import oracle.bpm.swing.properties.PropertyListener;
import oracle.bpm.swing.properties.SingleProperty;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

public class PropertyComboBox
extends ComboBox
implements PropertyFieldInterface,
PropertyListener,
ItemListener {
    volatile boolean doUpdate = true;
    SingleProperty property;

    PropertyComboBox(UiContainer parent, SingleProperty property) {
        super(parent, property.isEditable());
        this.property = property;
        this.updatePredefinedValues();
        if (property.getValue() != null) {
            this.setSelectedItem(property.getValue());
        }
        this.property.addPropertyListener(this);
        this.addItemListener(this);
    }

    public SingleProperty getProperty() {
        return this.property;
    }

    @Override
    public void dataChanged(SingleProperty root) {
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyComboBox.this.doUpdate = false;
                PropertyComboBox.this.setSelectedItem(PropertyComboBox.this.property.getValue());
                PropertyComboBox.this.doUpdate = true;
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateProperty();
    }

    @Override
    public void updatePredefinedValues() {
        this.removeAllItems();
        for (Object next : this.property.getPredefinedValues()) {
            this.addItem(next);
        }
    }

    @Override
    public void updateProperty() {
        if (!this.doUpdate) {
            return;
        }
        this.property.setValue(this.getSelectedItem());
    }

    @Override
    public void validateProperties() throws InvalidPropertyValueException, MissingMandatoryValueException {
        this.getProperty().validate(this.getSelectedItem());
    }
}

