/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.print;

import java.awt.print.Paper;
import java.io.Serializable;
import oracle.bpm.print.PaperModel;

public class PageFormat
implements Cloneable,
Serializable {
    private int mOrientation = 1;
    private PaperModel mPaperModel;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int REVERSE_LANDSCAPE = 2;
    static final long serialCheck = 2654670787020680848L;
    static final long serialVersionUID = -4428285063889963405L;

    public PageFormat() {
        this.mPaperModel = new PaperModel();
    }

    public PageFormat(java.awt.print.PageFormat pageFormat) {
        this.mOrientation = pageFormat.getOrientation();
        Paper paper = pageFormat.getPaper();
        this.mPaperModel = new PaperModel();
        this.mPaperModel.setImageableArea(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight());
        this.mPaperModel.setSize(paper.getWidth(), paper.getHeight());
    }

    public Object clone() throws CloneNotSupportedException {
        PageFormat newPage;
        try {
            newPage = (PageFormat)super.clone();
            newPage.mPaperModel = (PaperModel)this.mPaperModel.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            newPage = null;
        }
        return newPage;
    }

    public double getWidth() {
        int orientation = this.getOrientation();
        double width = orientation == 1 ? this.mPaperModel.getWidth() : this.mPaperModel.getHeight();
        return width;
    }

    public double getHeight() {
        int orientation = this.getOrientation();
        double height = orientation == 1 ? this.mPaperModel.getHeight() : this.mPaperModel.getWidth();
        return height;
    }

    public double getImageableX() {
        double x;
        switch (this.getOrientation()) {
            case 1: {
                x = this.mPaperModel.getImageableX();
                break;
            }
            case 0: {
                x = this.mPaperModel.getHeight() - (this.mPaperModel.getImageableY() + this.mPaperModel.getImageableHeight());
                break;
            }
            case 2: {
                x = this.mPaperModel.getImageableY();
                break;
            }
            default: {
                throw new InternalError("invalid orientation");
            }
        }
        return x;
    }

    public double getImageableY() {
        double y;
        switch (this.getOrientation()) {
            case 1: {
                y = this.mPaperModel.getImageableY();
                break;
            }
            case 0: {
                y = this.mPaperModel.getImageableX();
                break;
            }
            case 2: {
                y = this.mPaperModel.getWidth() - (this.mPaperModel.getImageableX() + this.mPaperModel.getImageableWidth());
                break;
            }
            default: {
                throw new InternalError("invalid orientation");
            }
        }
        return y;
    }

    public double getImageableWidth() {
        double width = this.getOrientation() == 1 ? this.mPaperModel.getImageableWidth() : this.mPaperModel.getImageableHeight();
        return width;
    }

    public double getImageableHeight() {
        double height = this.getOrientation() == 1 ? this.mPaperModel.getImageableHeight() : this.mPaperModel.getImageableWidth();
        return height;
    }

    public PaperModel getPaper() {
        return (PaperModel)this.mPaperModel.clone();
    }

    public void setPaper(PaperModel paperModel) {
        this.mPaperModel = (PaperModel)paperModel.clone();
    }

    public void setOrientation(int orientation) throws IllegalArgumentException {
        if (0 > orientation || orientation > 2) {
            throw new IllegalArgumentException();
        }
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(String name) {
        if (name.equals("landscape")) {
            this.setOrientation(0);
        } else if (name.equals("portrait")) {
            this.setOrientation(1);
        } else {
            this.setOrientation(1);
        }
    }

    public String getOrientationString() {
        switch (this.getOrientation()) {
            case 0: {
                return "landscape";
            }
        }
        return "portrait";
    }

    public void setmOrientation(int mOrientation) {
        this.mOrientation = mOrientation;
    }

    public void setmPaperModel(PaperModel mPaperModel) {
        this.mPaperModel = mPaperModel;
    }

    public int getmOrientation() {
        return this.mOrientation;
    }

    public PaperModel getmPaperModel() {
        return this.mPaperModel;
    }

    public double[] getMatrix() {
        double[] matrix = new double[6];
        switch (this.mOrientation) {
            case 0: {
                matrix[0] = 0.0;
                matrix[1] = -1.0;
                matrix[2] = 1.0;
                matrix[3] = 0.0;
                matrix[4] = 0.0;
                matrix[5] = this.mPaperModel.getHeight();
                break;
            }
            case 1: {
                matrix[0] = 1.0;
                matrix[1] = 0.0;
                matrix[2] = 0.0;
                matrix[3] = 1.0;
                matrix[4] = 0.0;
                matrix[5] = 0.0;
                break;
            }
            case 2: {
                matrix[0] = 0.0;
                matrix[1] = 1.0;
                matrix[2] = -1.0;
                matrix[3] = 0.0;
                matrix[4] = this.mPaperModel.getWidth();
                matrix[5] = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return matrix;
    }

    public java.awt.print.PageFormat asSwing() {
        Paper paper = new Paper();
        paper.setImageableArea(this.mPaperModel.getImageableX(), this.mPaperModel.getImageableY(), this.mPaperModel.getWidth(), this.mPaperModel.getHeight());
        paper.setSize(this.mPaperModel.getWidth(), this.mPaperModel.getHeight());
        java.awt.print.PageFormat pf = new java.awt.print.PageFormat();
        pf.setOrientation(this.mOrientation);
        pf.setPaper(paper);
        return pf;
    }
}

