/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.BasicStroke;
import oracle.bpm.draw.LineCap;
import oracle.bpm.draw.LineJoin;
import oracle.bpm.draw.LineStyle;

public class Stroke {
    private LineCap cap = CAP_DEFAULT;
    private int[] dash;
    private LineJoin join = JOIN_DEFAULT;
    private LineStyle style = STYLE_DEFAULT;
    private int width = 1;
    private static final LineCap CAP_DEFAULT = LineCap.SQUARE;
    private static final LineJoin JOIN_DEFAULT = LineJoin.MITER;
    private static final LineStyle STYLE_DEFAULT = LineStyle.SOLID;
    private static final int WIDTH_DEFAULT = 1;
    public static final Stroke ONE_SOLID = new Stroke(1);
    public static final Stroke ONE_DOTTED = new Stroke(1, LineStyle.DOT);
    public static final Stroke TWO_SOLID = new Stroke(2);
    public static final Stroke TWO_DOTTED = new Stroke(2, LineStyle.DOT);
    public static final Stroke THREE_SOLID = new Stroke(3);
    public static final Stroke FOUR_SOLID = new Stroke(4);

    public Stroke() {
    }

    public Stroke(LineStyle style) {
        this(1, style);
    }

    public Stroke(int lineWith) {
        this(lineWith, STYLE_DEFAULT);
    }

    public Stroke(int lineWith, int[] dash) {
        this(lineWith, dash, CAP_DEFAULT, JOIN_DEFAULT);
    }

    public Stroke(int lineWith, LineStyle style) {
        this(lineWith, style, CAP_DEFAULT, JOIN_DEFAULT);
    }

    public Stroke(int lineWith, LineStyle style, LineCap cap, LineJoin join) {
        this.style = style;
        this.width = lineWith;
        this.cap = cap;
        this.join = join;
    }

    public Stroke(int lineWith, int[] dash, LineCap cap, LineJoin join) {
        this(lineWith, LineStyle.CUSTOM, cap, join);
        this.dash = dash;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setStyle(LineStyle style) {
        this.style = style;
    }

    public LineStyle getStyle() {
        return this.style;
    }

    public int[] getDash() {
        return this.dash;
    }

    public void setDash(int[] dash) {
        this.dash = dash;
        this.style = LineStyle.CUSTOM;
    }

    public LineCap getCap() {
        return this.cap;
    }

    public void setCap(LineCap cap) {
        this.cap = cap;
    }

    public LineJoin getJoin() {
        return this.join;
    }

    public void setJoin(LineJoin join) {
        this.join = join;
    }

    public java.awt.Stroke asAwt() {
        return new BasicStroke(this.getWidth(), this.getCap().intValue(), this.getJoin().intValue(), 10.0f, this.getAwtDash(), 0.0f);
    }

    private float[] getAwtDash() {
        float[] result = null;
        switch (this.style) {
            case CUSTOM: {
                if (this.dash == null) break;
                int len = this.dash.length;
                result = new float[len];
                for (int i = 0; i < len; ++i) {
                    result[i] = this.dash[i];
                }
                break;
            }
            case DASH: {
                result = new float[]{18.0f, 6.0f};
                break;
            }
            case DOT: {
                result = new float[]{3.0f, 3.0f};
                break;
            }
            case DASHDOT: {
                result = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
                break;
            }
            case DASHDOTDOT: {
                result = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};
                break;
            }
        }
        return result;
    }
}

