/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.io.Serializable;
import oracle.bpm.collections.maps.LongMap;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.peer.ColorPeer;

public class Color
implements Serializable {
    private ColorInfo info;
    private ColorPeer peer;
    private static LongMap<Color> colors = new LongMap();
    static final long serialVersionUID = -3266093280599899853L;
    static final long serialCheck = 6073538702316179740L;
    private static final double FACTOR = 0.7;
    private static final int BFACTOR = 3;
    private static final Color BRIGHT_BLACK = Color.valueOf(3, 3, 3);
    public static final Color WHITE = Color.valueOf(255, 255, 255);
    public static final Color LIGHT_GRAY = Color.valueOf(192, 192, 192);
    public static final Color GRAY = Color.valueOf(128, 128, 128);
    public static final Color DARK_GRAY = Color.valueOf(64, 64, 64);
    public static final Color BLACK = Color.valueOf(0, 0, 0);
    public static final Color RED = Color.valueOf(255, 0, 0);
    public static final Color GREEN = Color.valueOf(0, 255, 0);
    public static final Color DARK_GREEN = Color.valueOf(60, 200, 60);
    public static final Color BLUE = Color.valueOf(0, 0, 255);
    public static final Color YELLOW = Color.valueOf(255, 255, 0);
    public static final Color MAGENTA = Color.valueOf(255, 0, 255);
    public static final Color CYAN = Color.valueOf(0, 255, 255);
    public static final Color ORANGE = Color.valueOf(255, 155, 0);
    public static final Color PINK = Color.valueOf(255, 175, 175);
    public static final Color FUEGO_BLUE = Color.valueOf(0, 40, 122);
    public static final Color FUEGO_LIGHT_BLUE = Color.valueOf(206, 212, 225);
    public static final Color TRANSLUCENT = Color.valueOf(WHITE, 170);
    public static final Color TRANSLUCENT_35 = Color.valueOf(WHITE, 90);

    private Color(ColorInfo info) {
        this.info = info;
    }

    public static Color valueOf(ColorPeer p) {
        Color c = Color.valueOf(ColorInfo.valueOf(p.getRed(), p.getGreen(), p.getBlue()));
        c.setPeer(p);
        return c;
    }

    public static Color valueOf(ColorInfo info) {
        return Color.findOrCreate(info);
    }

    public static Color valueOf(int red, int green, int blue) {
        return Color.valueOf(red, green, blue, 255);
    }

    public static Color valueOf(int red, int green, int blue, int alpha) {
        int rgb = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        ColorInfo.testColorValueRange(red, green, blue, alpha);
        return Color.findOrCreate(ColorInfo.valueOf(rgb));
    }

    public static Color valueOf(Color color, int alpha) {
        return Color.valueOf(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static synchronized Color valueOf(int rgb) {
        return Color.findOrCreate(ColorInfo.valueOf(0xFF000000 | rgb));
    }

    public static Color decode(String color) {
        int rgb = Integer.decode(color);
        return Color.valueOf(ColorInfo.valueOf(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getGreen() {
        return this.info.getGreen();
    }

    public int getRGB() {
        return this.info.getRgb();
    }

    public int getRed() {
        return this.info.getRed();
    }

    public ColorPeer getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer(this.getRed(), this.getGreen(), this.getBlue());
            assert (this.peer != null) : "Could not create peer for component " + this.getClass().getName();
        }
        return this.peer;
    }

    public Color brighter() {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        if (r == 0 && g == 0 && b == 0) {
            return BRIGHT_BLACK;
        }
        if (r > 0 && r < 3) {
            r = 3;
        }
        if (g > 0 && g < 3) {
            g = 3;
        }
        if (b > 0 && b < 3) {
            b = 3;
        }
        return Color.valueOf(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g / 0.7), 255), Math.min((int)((double)b / 0.7), 255));
    }

    public Color darker() {
        return Color.valueOf(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public boolean equals(Object that) {
        return this == that || that != null && that instanceof Color && ((Color)that).info.equals(this.info);
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Color(").append(this.getRed()).append(',').append(this.getGreen()).append(',').append(this.getBlue()).append(") alpha <").append(this.getAlpha()).append('>');
        return builder.toString();
    }

    public int getBlue() {
        return this.info.getBlue();
    }

    public ColorInfo getInfo() {
        return this.info;
    }

    private static Color findOrCreate(ColorInfo info) {
        Color c = colors.get(info.getRgb());
        if (c == null) {
            c = new Color(info);
            colors.put(info.getRgb(), c);
        }
        return c;
    }

    private void setPeer(ColorPeer peer) {
        this.peer = peer;
    }

    private ColorPeer createPeer(int r, int g, int b) {
        return Ui.getUiFactory().createColor(r, g, b);
    }
}

