/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oracle.bpm.servlet.multipart.MultipartWrapper;
import oracle.bpm.web.execution.Attachment;
import oracle.bpm.web.execution.Request;

public class ServletRequestAdapter
implements Request {
    private HttpServletRequest request;

    public ServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public List<Attachment> getAttachments() {
        List<Attachment> ret;
        if (this.request instanceof MultipartWrapper) {
            MultipartWrapper multipart = (MultipartWrapper)this.request;
            ret = new ArrayList<Attachment>();
            for (String name : multipart.getFileNames()) {
                ret.add(new Attachment(multipart.getFile(name), multipart.getContentType(name), name, multipart.getFileName(name)));
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Enumeration e = this.request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            ret.put(name, this.request.getAttribute(name));
        }
        return Collections.unmodifiableMap(ret);
    }

    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    @Override
    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    @Override
    public Map<String, String> getHeaderMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration e = this.request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            ret.put(name, this.request.getHeader(name));
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.request;
    }
}

