/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.ExternalContextProperties;
import oracle.bpm.web.execution.Request;
import oracle.bpm.web.execution.Session;
import oracle.bpm.web.execution.exception.InternalForwardException;
import oracle.bpm.web.execution.impl.WebExecutionManager;
import oracle.bpm.web.execution.impl.WebExternalContext;
import oracle.bpm.web.execution.impl.WebUtils;
import oracle.bpm.web.execution.servlet.HttpRequestAdapter;
import oracle.bpm.web.execution.servlet.HttpSessionAdapter;

public class ServletExternalContext
implements WebExternalContext {
    private HttpRequestAdapter httpRequestAdapter;
    private HttpSessionAdapter httpSessionAdapter;
    private ExternalContextProperties properties;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static final String CACHED_EXTERNAL_CONTEXT = "oracle.bpm.execution.cachedExternalContext";

    protected ServletExternalContext(HttpServletRequest request, HttpServletResponse response, ExternalContextProperties properties) {
        this.properties = properties;
        this.httpRequestAdapter = new HttpRequestAdapter(request);
        this.request = request;
        this.response = response;
    }

    public static ExternalContext create(HttpServletRequest request, HttpServletResponse response, ExternalContextProperties properties) {
        ExternalContext ret = (ExternalContext)request.getAttribute(CACHED_EXTERNAL_CONTEXT);
        if (ret == null) {
            ret = new ServletExternalContext(request, response, properties);
            request.setAttribute(CACHED_EXTERNAL_CONTEXT, (Object)ret);
        }
        return ret;
    }

    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public Request getRequest() {
        return this.httpRequestAdapter;
    }

    @Override
    public Session getSession(boolean create) {
        if (this.httpSessionAdapter == null) {
            this.httpSessionAdapter = new HttpSessionAdapter(this.request.getSession(create));
        }
        return this.httpSessionAdapter;
    }

    @Override
    public ExternalContextProperties getProperties() {
        return this.properties;
    }

    @Override
    public void finishExecution() {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        String url = manager.getFinishUrl(this);
        this.forwardInternal(url);
    }

    @Override
    public void processAction(String component, String action) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        String url = manager.urlForInternalForwardAction(component, action, this);
        this.forwardInternal(url);
    }

    @Override
    public void redirectView(String url, Map<String, Object> attributes) {
        HttpServletRequest request = this.getHttpRequest();
        HttpServletResponse response = this.getHttpResponse();
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(url);
        try {
            Set<String> keys = attributes.keySet();
            for (String key : keys) {
                request.setAttribute(key, attributes.get(key));
            }
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new InternalForwardException(e);
        }
        catch (IOException e) {
            throw new InternalForwardException(e);
        }
    }

    @Override
    public String getResourceRealPath(String path) {
        return this.request.getSession().getServletContext().getRealPath(path);
    }

    @Override
    public PrintWriter getResponseWriter() throws IOException {
        return this.response.getWriter();
    }

    @Override
    public void setResponseStatus(int status) {
        this.response.setStatus(status);
    }

    @Override
    public void setResponseLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    @Override
    public void setResponseContentType(String contextType) {
        this.response.setContentType(contextType);
    }

    @Override
    public void setResponseContentLength(int contextLength) {
        this.response.setContentLength(contextLength);
    }

    @Override
    public void addResponseHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    @Override
    public void sendResponseError(int code) throws IOException {
        this.response.sendError(code);
    }

    @Override
    public void sendResponseError(int code, String msg) throws IOException {
        this.response.sendError(code, msg);
    }

    @Override
    public OutputStream getResponseOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    private void forwardInternal(String url) {
        RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(url);
        try {
            requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new InternalForwardException(e);
        }
        catch (IOException e) {
            throw new InternalForwardException(e);
        }
    }
}

