/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.servlet;

import javax.servlet.http.HttpServletRequest;
import oracle.bpm.util.Properties;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.Request;
import oracle.bpm.web.execution.exception.InteractiveComponentNotSupportedException;
import oracle.bpm.web.execution.impl.WebExecutionIdentifier;
import oracle.bpm.web.execution.impl.WebExecutionManager;
import oracle.bpm.web.execution.servlet.ServletExternalContext;

public abstract class ServletExecutionManager
extends WebExecutionManager {
    public static final String PARAM_EXECUTION_ID = "execId";
    private static final String EXECUTION_ID_OBJECT = "execIdObj";

    @Override
    public void updateExecutionIdentifier(ExternalContext externalContext, ExecutionIdentifier executionIdentifier) {
        ServletExternalContext servletContext = (ServletExternalContext)externalContext;
        HttpServletRequest request = servletContext.getHttpRequest();
        request.setAttribute(PARAM_EXECUTION_ID, (Object)executionIdentifier.toString());
        request.setAttribute(EXECUTION_ID_OBJECT, (Object)executionIdentifier);
    }

    @Override
    public ExecutionIdentifier retrieveExecutionIdentifier(ExternalContext externalContext) {
        Request request = externalContext.getRequest();
        ExecutionIdentifier execId = (ExecutionIdentifier)request.getAttribute(EXECUTION_ID_OBJECT);
        if (execId != null) {
            return execId;
        }
        String execIdStr = (String)request.getAttribute(PARAM_EXECUTION_ID);
        if (execIdStr == null) {
            execIdStr = request.getParameter(PARAM_EXECUTION_ID);
        }
        if (execIdStr == null) {
            return null;
        }
        return WebExecutionIdentifier.loadFrom(execIdStr);
    }

    @Override
    public String findImageUrl(String component, String image, ExternalContext externalContext) {
        Properties properties = this.findComponentProperties(component);
        String img = properties.getProperty("servlet.img." + image);
        if (img == null) {
            img = super.findImageUrl(component, image, externalContext);
        }
        return img;
    }

    @Override
    public String findJSPIncludeUrl(String component, String jsp) throws InteractiveComponentNotSupportedException {
        Properties properties = this.findComponentProperties(component);
        String ret = properties.getProperty("servlet.jsp." + jsp);
        if (ret == null) {
            ret = super.findJSPIncludeUrl(component, jsp);
        }
        return ret;
    }

    @Override
    protected String findActionTarget(String component, String action) {
        Properties properties = this.findComponentProperties(component);
        String target = properties.getProperty("servlet." + action);
        if (target == null) {
            target = properties.getProperty("servlet.jsp." + action);
        }
        if (target == null) {
            target = super.findActionTarget(component, action);
        }
        return target;
    }
}

