/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution;

import fuego.papi.Execution;
import fuego.papi.Invocation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.AbortedException;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.ComponentAction;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.ExecutionData;
import oracle.bpm.web.execution.InvocationContext;
import oracle.bpm.web.execution.ModelAccessor;

public class InteractiveInvocation
implements InvocationContext {
    private Object[] arguments;
    private Map<String, Object> attributes;
    private Invocation invocation;
    private ModelAccessor modelAccessor;

    public InteractiveInvocation(ModelAccessor web, Invocation invocation, Object[] arguments) {
        this.modelAccessor = web;
        this.invocation = invocation;
        this.arguments = arguments;
        this.attributes = new HashMap<String, Object>();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, Object> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public void finishExecution() {
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public ComponentAction retryExecution(ExecutionData execData) throws Exception {
        return this.modelAccessor.prepare(execData);
    }

    public boolean supportsBack() {
        return this.invocation.isOutOfOrder();
    }

    public String toString() {
        return "WebInvocation: " + this.attributes.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(ExecutionData execData) {
        Execution execution = execData.getExecution();
        try {
            this.modelAccessor.aborted(execData);
        }
        catch (Exception e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
        }
        finally {
            AbortedException abort = new AbortedException();
            execution.setException(abort);
            try {
                Invocation inv = execution.next();
                while (inv != null) {
                    execution.setException(abort);
                    inv = execution.next();
                }
            }
            catch (Exception e) {}
        }
    }

    void finish(ExecutionData execData) throws Exception {
        Execution execution = execData.getExecution();
        Object retval = this.modelAccessor.commit(execData);
        execution.setInvocationResult(this.invocation.doPostInvoke(this.arguments, retval));
    }

    ComponentAction prepare(ComponentContext context) throws Exception {
        return this.modelAccessor.prepare(context);
    }
}

