/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.services.processdashboard.model.jaxb.OperatorTypeEnum;

public class SQLUtils {
    private static final String FLEX_NUMBER = "Number";
    private static final String FLEX_TIMESTAMP = "Timestamp";
    private static final String FLEX_STRING = "String";

    public static String getSQL(String variable, String operator, String value) {
        return SQLUtils.getSQL(variable, OperatorTypeEnum.valueOf((String)operator.toUpperCase()), value);
    }

    public static String getSQL(String variable, OperatorTypeEnum operator, String value) {
        return variable + " " + SQLUtils.getSQLOperator(operator) + " " + value;
    }

    public static Object getSQLValue(Object value, OperatorTypeEnum operator, String columnType) {
        Object sqlValue = null;
        if (columnType != null) {
            if (String.class.getName().equalsIgnoreCase(columnType)) {
                sqlValue = SQLUtils.getSQLStringValue(value.toString(), operator);
            } else if (Integer.class.getName().equalsIgnoreCase(columnType)) {
                sqlValue = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : (value instanceof Interval ? Integer.valueOf((int)((Interval)value).getMilliSeconds()) : SQLUtils.toInteger(value.toString()));
            } else if (Long.class.getName().equalsIgnoreCase(columnType)) {
                sqlValue = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : (value instanceof Interval ? Long.valueOf(((Interval)value).getMilliSeconds()) : SQLUtils.toLong(value.toString()));
            } else if (Double.class.getName().equalsIgnoreCase(columnType)) {
                sqlValue = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : (value instanceof Interval ? Double.valueOf(((Interval)value).getMilliSeconds()) : SQLUtils.toDouble(value.toString()));
            } else if (BigDecimal.class.getName().equalsIgnoreCase(columnType)) {
                sqlValue = value instanceof BigDecimal ? value : (value instanceof Number ? new BigDecimal(((Number)value).doubleValue()) : (value instanceof Interval ? new BigDecimal(((Interval)value).getMilliSeconds()) : SQLUtils.toBigDecimal(value.toString())));
            } else if (Timestamp.class.getName().equalsIgnoreCase(columnType)) {
                if (value instanceof Timestamp) {
                    sqlValue = value;
                } else if (value instanceof Interval) {
                    sqlValue = new Timestamp(Time.now().sub((Interval)value).getMilliSeconds());
                } else if (value instanceof Date) {
                    sqlValue = new Timestamp(((Date)value).getTime());
                } else {
                    try {
                        sqlValue = new Timestamp(SQLUtils.toDate(value.toString()).getTime());
                    }
                    catch (ParseException exception) {
                        sqlValue = SQLUtils.toTimestamp(value.toString());
                    }
                }
            } else if (Date.class.getName().equalsIgnoreCase(columnType)) {
                if (value instanceof Date) {
                    sqlValue = value;
                } else if (value instanceof Interval) {
                    sqlValue = Time.now().sub((Interval)value).dateValue();
                } else {
                    try {
                        sqlValue = DateFormat.getInstance().parse(value.toString());
                    }
                    catch (ParseException e) {}
                }
            } else if (FLEX_NUMBER.equalsIgnoreCase(columnType)) {
                sqlValue = value instanceof BigDecimal ? value : (value instanceof Number ? new BigDecimal(((Number)value).doubleValue()) : (value instanceof Interval ? new BigDecimal(((Interval)value).getMilliSeconds()) : new BigDecimal(value.toString())));
            } else if (FLEX_TIMESTAMP.equalsIgnoreCase(columnType)) {
                if (value instanceof Timestamp) {
                    sqlValue = value;
                } else if (value instanceof Interval) {
                    sqlValue = new Timestamp(Time.now().sub((Interval)value).getMilliSeconds());
                } else if (value instanceof Date) {
                    sqlValue = new Timestamp(((Date)value).getTime());
                } else {
                    try {
                        sqlValue = new Timestamp(SQLUtils.toDate(value.toString()).getTime());
                    }
                    catch (ParseException exception) {
                        sqlValue = SQLUtils.toTimestamp(value.toString());
                    }
                }
            } else if (FLEX_STRING.equalsIgnoreCase(columnType)) {
                sqlValue = SQLUtils.getSQLStringValue(value.toString(), operator);
            }
        }
        return sqlValue;
    }

    private static String getSQLStringValue(String value, OperatorTypeEnum operator) {
        String _value = "";
        switch (operator) {
            case CONTAINS: 
            case NOT_CONTAINS: {
                if (!value.startsWith("%")) {
                    _value = _value + "%";
                }
                _value = _value + value;
                if (value.endsWith("%")) break;
                _value = _value + "%";
                break;
            }
            case BEGIN_WITH: 
            case NOT_BEGIN_WITH: {
                _value = _value + value;
                if (value.endsWith("%")) break;
                _value = _value + "%";
                break;
            }
            case END_WITH: 
            case NOT_END_WITH: {
                if (!value.startsWith("%")) {
                    _value = _value + "%";
                }
                _value = _value + value;
                break;
            }
            default: {
                _value = value;
            }
        }
        return _value;
    }

    private static Integer toInteger(String value) {
        Integer interger = null;
        if (value != null && !value.isEmpty()) {
            try {
                Interval interval = Interval.valueOf(value);
                interger = (int)interval.getMilliSeconds();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interger = Integer.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (interger == null) {
                throw new IllegalArgumentException("Invalid Integer value '" + value + "'.");
            }
        }
        return interger;
    }

    private static Long toLong(String value) {
        Long longValue = null;
        if (value != null && !value.isEmpty()) {
            try {
                Interval interval = Interval.valueOf(value);
                longValue = interval.getMilliSeconds();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                longValue = Long.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (longValue == null) {
                throw new IllegalArgumentException("Invalid Long value '" + value + "'.");
            }
        }
        return longValue;
    }

    private static Double toDouble(String value) {
        Double doubleValue = null;
        if (value != null && !value.isEmpty()) {
            try {
                Interval interval = Interval.valueOf(value);
                doubleValue = new Double(interval.getMilliSeconds());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                doubleValue = Double.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (doubleValue == null) {
                throw new IllegalArgumentException("Invalid Long value '" + value + "'.");
            }
        }
        return doubleValue;
    }

    private static BigDecimal toBigDecimal(String value) {
        BigDecimal bigDecimal = null;
        if (value != null && !value.isEmpty()) {
            try {
                Interval interval = Interval.valueOf(value);
                bigDecimal = new BigDecimal(interval.getMilliSeconds());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bigDecimal = new BigDecimal(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bigDecimal == null) {
                throw new IllegalArgumentException("Invalid Long value '" + value + "'.");
            }
        }
        return bigDecimal;
    }

    private static Date toDate(String value) throws ParseException {
        return DateFormat.getDateInstance(3, Locale.US).parse(value);
    }

    private static Timestamp toTimestamp(String value) {
        Timestamp timestamp = null;
        if (value != null && !value.isEmpty()) {
            try {
                timestamp = Timestamp.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Date date = DateFormat.getInstance().parse(value);
                timestamp = new Timestamp(date.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Interval interval = Interval.valueOf(value);
                timestamp = new Timestamp(Time.now().sub(interval).getMilliSeconds());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                timestamp = new Timestamp(Double.valueOf(value).longValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (timestamp == null) {
                throw new IllegalArgumentException("Invalid Timestamp value '" + value + "'.");
            }
        }
        return timestamp;
    }

    private static String getSQLOperator(OperatorTypeEnum operatorType) {
        switch (operatorType) {
            case AFTER: {
                return ">";
            }
            case BEFORE: {
                return "<";
            }
            case BEGIN_WITH: {
                return "LIKE";
            }
            case CONTAINS: {
                return "LIKE";
            }
            case END_WITH: {
                return "LIKE";
            }
            case EQUALS: {
                return "=";
            }
            case GRATER_OR_EQUALS: {
                return ">=";
            }
            case GRATER_THAN: {
                return ">";
            }
            case IN: {
                return "IN";
            }
            case LESS_OR_EQUALS: {
                return "<=";
            }
            case LESS_THAN: {
                return "<";
            }
            case NOT_BEGIN_WITH: {
                return "NOT LIKE";
            }
            case NOT_CONTAINS: {
                return "NOT LIKE";
            }
            case NOT_END_WITH: {
                return "NOT LIKE";
            }
            case NOT_EQUALS: {
                return "<>";
            }
        }
        throw new IllegalArgumentException("Invalid TComparatorType");
    }
}

