/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import oracle.bpm.analytics.cube.persistence.model.CubeTaskPerformance;
import oracle.bpm.analytics.cube.persistence.model.CubeWorkload;
import oracle.bpm.analytics.dashboard.query.JPQLQuery;
import oracle.bpm.analytics.dashboard.query.SqlLookup;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.jaxb.RowDataType;
import oracle.bpm.services.processdashboard.model.jaxb.TabularDataType;
import oracle.bpm.services.processdashboard.model.jaxb.TabularMetadataType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueDataType;

public class JpqlTabularData
extends ArrayList<Item> {
    private Metadata metadata;
    private static final long serialVersionUID = -100L;
    public static final String SEPARATOR = "/";

    private JpqlTabularData() {
        super(5);
    }

    public static JpqlTabularData create() {
        return new JpqlTabularData();
    }

    public static JpqlTabularData create(List jpqlQueryResult) {
        JpqlTabularData jpqlTabularData = new JpqlTabularData();
        for (Object object : jpqlQueryResult) {
            jpqlTabularData.add(Item.create(object));
        }
        return jpqlTabularData;
    }

    public static JpqlTabularData create(JPQLQuery jpqlQuery, List jpqlQueryResult) {
        if (jpqlQuery.getMetadata() == null) {
            return JpqlTabularData.create(jpqlQueryResult);
        }
        JPQLQuery.Metadata jpqlMetadata = jpqlQuery.getMetadata();
        Metadata metadata = Metadata.create(jpqlMetadata.getMeasureLabel(), jpqlMetadata.getSeriesLabel(), jpqlMetadata.getGroupLabel());
        JpqlTabularData jpqlTabularData = new JpqlTabularData();
        jpqlTabularData.setMetadata(metadata);
        for (Object object : jpqlQueryResult) {
            jpqlTabularData.add(Item.create(jpqlMetadata, object, jpqlQuery.getAggregateFunctionType() != null));
        }
        return jpqlTabularData;
    }

    public Item[] toArray() {
        return super.toArray(new Item[this.size()]);
    }

    public List<Serializable[]> toList() {
        ArrayList<Serializable[]> list = new ArrayList<Serializable[]>();
        for (Item item : this.toArray()) {
            list.add(item.toArray());
        }
        return list;
    }

    @Override
    public String toString() {
        String tabularDataStr = "Jpql Tabular Data - size [" + this.size() + "]\n";
        for (Item item : this.toArray()) {
            tabularDataStr = tabularDataStr + item.toString() + "\n";
        }
        return tabularDataStr;
    }

    public TabularDataType toTabularDataType() {
        TabularDataType tabularDataType = ModelTypeFactory.getWidgetTypeFactory().createTabularDataType();
        if (this.getMetadata() != null) {
            TabularMetadataType tabularMetadataType = ModelTypeFactory.getWidgetTypeFactory().createTabularMetadataType();
            tabularMetadataType.setMeasure(this.getMetadata().getMeasure());
            tabularMetadataType.setSeries(this.getMetadata().getSeries());
            tabularMetadataType.setGroup(this.getMetadata().getGroup());
            tabularDataType.setMetadata(tabularMetadataType);
        }
        for (Item item : this.toArray()) {
            tabularDataType.getRows().add(item.toRowData());
        }
        return tabularDataType;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    private static class Utils {
        private Utils() {
        }

        public static Number getQuantity(JPQLQuery.Metadata metadata, Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                int initPos = metadata.getGroup().size() + metadata.getSeries().size();
                if (array.length == initPos + 2) {
                    return (Number)array[array.length - 1];
                }
                if (array.length == initPos + 1) {
                    return (Number)array[array.length - 1];
                }
            }
            return null;
        }

        public static Object getMeasure(JPQLQuery.Metadata metadata, Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                int initPos = metadata.getGroup().size() + metadata.getSeries().size();
                if (array.length == initPos + 1) {
                    return array[array.length - 1];
                }
                if (array.length == initPos + 2) {
                    return array[array.length - 2];
                }
                return null;
            }
            return value;
        }

        public static Item.Dimension getSeriesData(JPQLQuery.Metadata metadata, Object value) {
            Object[] array;
            if (value != null && value.getClass().isArray() && (array = (Object[])value).length > 1 && metadata.getSeries().size() > 0) {
                int initPos = metadata.getGroup().size();
                int length = metadata.getSeries().size();
                if (length + initPos <= array.length - 1) {
                    Object[] seriesData = new Object[length];
                    System.arraycopy(array, initPos, seriesData, 0, length);
                    return Utils.getDimension(metadata.getSeries(), seriesData, metadata.seriesUseRanges());
                }
            }
            return null;
        }

        public static Item.Dimension getGroupData(JPQLQuery.Metadata metadata, Object value) {
            Object[] array;
            if (value != null && value.getClass().isArray() && (array = (Object[])value).length > 2 && metadata.getGroup().size() > 0) {
                int initPos = 0;
                int length = metadata.getGroup().size();
                if (length <= array.length - 2) {
                    Object[] groupData = new Object[length];
                    System.arraycopy(array, initPos, groupData, 0, length);
                    return Utils.getDimension(metadata.getGroup(), groupData, metadata.groupUseRanges());
                }
            }
            return null;
        }

        public static Item.Dimension getParticipantDimention(Object[] value) {
            String participantId = null;
            String participantLabel = "default";
            if (value[0] != null) {
                String composite;
                participantId = value[0].toString();
                int typeSeparatorIndex = participantId.lastIndexOf(",");
                int compositeSeparatorIndex = participantId.lastIndexOf(".");
                String type = typeSeparatorIndex == -1 ? "user" : participantId.substring(typeSeparatorIndex + 1);
                String string = composite = compositeSeparatorIndex == -1 ? null : participantId.substring(0, compositeSeparatorIndex);
                String user = compositeSeparatorIndex == -1 ? (typeSeparatorIndex == -1 ? participantId : participantId.substring(0, typeSeparatorIndex)) : (typeSeparatorIndex == -1 ? participantId.substring(compositeSeparatorIndex + 1) : participantId.substring(compositeSeparatorIndex + 1, typeSeparatorIndex));
                participantLabel = (composite != null ? "[" + composite + "] " : "") + user + " (" + type + ")";
            }
            return new Item.Dimension(participantId, participantLabel);
        }

        private static Item.Dimension getDimension(List<String> qualifiedColumns, Object[] value, boolean useRanges) {
            Object id;
            if (Utils.isProcessDimension(qualifiedColumns)) {
                return Utils.getProcessDimension(qualifiedColumns, value);
            }
            if (Utils.isActivityDimension(qualifiedColumns)) {
                return Utils.getActivityDimension(qualifiedColumns, value);
            }
            if (Utils.isRoleDimension(qualifiedColumns)) {
                return Utils.getRoleDimension(qualifiedColumns, value);
            }
            if (Utils.isParticipantDimension(qualifiedColumns)) {
                return Utils.getParticipantDimention(value);
            }
            String label = null;
            int length = value.length;
            if (length > 1) {
                label = value[--length].toString();
                StringBuilder idStr = new StringBuilder("");
                boolean appendSeparator = false;
                for (int i = 0; i < length; ++i) {
                    if (appendSeparator) {
                        idStr.append(JpqlTabularData.SEPARATOR);
                    }
                    idStr.append(value[i].toString());
                    appendSeparator = true;
                }
                id = idStr.toString();
            } else {
                id = value[--length];
            }
            if (id == null && label == null) {
                if (useRanges) {
                    label = "Out of range";
                } else if (Utils.isParticipantDimension(qualifiedColumns)) {
                    label = "Default";
                }
            }
            return new Item.Dimension(id, label);
        }

        private static boolean isProcessDimension(List<String> qualifiedColumns) {
            List<SqlLookup.Column> columns = SqlLookup.standardDimensionsColumn.get("process");
            int quantity = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                boolean containsColumn = false;
                for (SqlLookup.Column column : columns) {
                    if (!column.getQualifiedColumn().equals(qualifiedColumn)) continue;
                    containsColumn = true;
                }
                if (containsColumn) {
                    ++quantity;
                    continue;
                }
                return false;
            }
            return quantity == columns.size();
        }

        private static Item.Dimension getProcessDimension(List<String> qualifiedColumns, Object[] value) {
            String domainName = null;
            String compositeName = null;
            String processName = null;
            String processLabel = null;
            int index = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                if (SqlLookup.getProcessDomainColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    domainName = value[index].toString();
                } else if (SqlLookup.getProcessCompositeNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    compositeName = value[index].toString();
                } else if (SqlLookup.getProcessNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processName = value[index].toString();
                } else if (SqlLookup.getProcessLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processLabel = value[index].toString();
                }
                ++index;
            }
            String id = domainName + JpqlTabularData.SEPARATOR + compositeName + JpqlTabularData.SEPARATOR + processName;
            String label = "[" + compositeName + "] " + (processLabel != null ? processLabel : processName);
            String shortLabel = processLabel != null ? processLabel : processName;
            return new Item.Dimension(id, label, shortLabel);
        }

        private static boolean isActivityDimension(List<String> qualifiedColumns) {
            List<SqlLookup.Column> columns = SqlLookup.standardDimensionsColumn.get("activity");
            int quantity = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                boolean containsColumn = false;
                for (SqlLookup.Column column : columns) {
                    if (!column.getQualifiedColumn().equals(qualifiedColumn)) continue;
                    containsColumn = true;
                }
                if (containsColumn) {
                    ++quantity;
                    continue;
                }
                return false;
            }
            return quantity == columns.size();
        }

        private static Item.Dimension getActivityDimension(List<String> qualifiedColumns, Object[] value) {
            String domainName = null;
            String compositeName = null;
            String processName = null;
            String processLabel = null;
            String activityName = null;
            String activityLabel = null;
            int index = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                if (SqlLookup.getProcessDomainColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    domainName = value[index].toString();
                } else if (SqlLookup.getProcessCompositeNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    compositeName = value[index].toString();
                } else if (SqlLookup.getProcessNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processName = value[index].toString();
                } else if (SqlLookup.getProcessLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    processLabel = value[index].toString();
                } else if (SqlLookup.getActivityNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    activityName = value[index].toString();
                } else if (SqlLookup.getActivityLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    activityLabel = value[index].toString();
                }
                ++index;
            }
            String id = domainName + JpqlTabularData.SEPARATOR + compositeName + JpqlTabularData.SEPARATOR + processName + JpqlTabularData.SEPARATOR + activityName;
            String label = "[" + compositeName + "] " + (processLabel == null || processLabel.isEmpty() ? processName : processLabel) + " > " + (activityLabel == null || activityLabel.isEmpty() ? activityName : activityLabel);
            String shortLabel = activityLabel == null || activityLabel.isEmpty() ? activityName : activityLabel;
            return new Item.Dimension(id, label, shortLabel);
        }

        private static boolean isRoleDimension(List<String> qualifiedColumns) {
            List<SqlLookup.Column> columns = SqlLookup.standardDimensionsColumn.get("role");
            int quantity = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                boolean containsColumn = false;
                for (SqlLookup.Column column : columns) {
                    if (!column.getQualifiedColumn().equals(qualifiedColumn)) continue;
                    containsColumn = true;
                }
                if (containsColumn) {
                    ++quantity;
                    continue;
                }
                return false;
            }
            return quantity == columns.size();
        }

        private static Item.Dimension getRoleDimension(List<String> qualifiedColumns, Object[] value) {
            String roleName = null;
            String roleLabel = null;
            int index = 0;
            for (String qualifiedColumn : qualifiedColumns) {
                if (SqlLookup.getRoleNameColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    roleName = value[index].toString();
                } else if (SqlLookup.getRoleLabelColumn().getQualifiedColumn().equals(qualifiedColumn)) {
                    roleLabel = value[index].toString();
                }
                ++index;
            }
            String id = roleName;
            String label = roleLabel == null || roleLabel.isEmpty() ? Utils.getUnqualifiedRoleName(roleName) : roleLabel;
            return new Item.Dimension(id, label);
        }

        private static String getUnqualifiedRoleName(String roleName) {
            String ROLE_QUALIFIED_SEPARATOR = ",";
            if (roleName == null) {
                return null;
            }
            int indexOf = roleName.lastIndexOf(",");
            return indexOf > 0 ? roleName.substring(0, indexOf) : roleName;
        }

        private static boolean isParticipantDimension(List<String> qualifiedColumns) {
            String workloadColumn = CubeWorkload.class.getSimpleName().toLowerCase() + "." + "participant";
            String taskPerformanceColumn = CubeTaskPerformance.class.getSimpleName().toLowerCase() + "." + "participant";
            if (qualifiedColumns != null && qualifiedColumns.size() == 1) {
                String qualifiedColumn = qualifiedColumns.get(0);
                return qualifiedColumn.equals(workloadColumn) || qualifiedColumn.equals(taskPerformanceColumn);
            }
            return false;
        }
    }

    public static class Metadata
    implements Serializable {
        private String group;
        private String measure;
        private String series;
        private static final long serialVersionUID = -100L;

        private Metadata(String measure, String series, String group) {
            this.measure = measure;
            this.series = series;
            this.group = group;
        }

        public static Metadata create(String measure, String series, String group) {
            return new Metadata(measure, series, group);
        }

        public String getMeasure() {
            return this.measure;
        }

        public void setMeasure(String measure) {
            this.measure = measure;
        }

        public String getSeries() {
            return this.series;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static class Item
    implements Serializable {
        private Dimension group = null;
        private Number quantity = null;
        private Dimension series = null;
        private Object value = null;
        private static final long serialVersionUID = -100L;

        private Item() {
        }

        public static Item create(Object value) {
            Item tabularDataItem = new Item();
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                switch (array.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        tabularDataItem.setValue(array[0]);
                        break;
                    }
                    case 2: {
                        tabularDataItem.setSeriesValue(array[0]);
                        tabularDataItem.setValue(array[1]);
                        break;
                    }
                    case 3: {
                        tabularDataItem.setGroupValue(array[0]);
                        tabularDataItem.setSeriesValue(array[1]);
                        tabularDataItem.setValue(array[2]);
                        break;
                    }
                    default: {
                        int length = array.length;
                        tabularDataItem.setQuantity((Number)array[--length]);
                        tabularDataItem.setValue(array[--length]);
                        tabularDataItem.setSeriesValue(array[--length]);
                        tabularDataItem.setGroupValue(array[--length]);
                        break;
                    }
                }
            } else {
                tabularDataItem.setValue(value);
            }
            return tabularDataItem;
        }

        public static Item create(JPQLQuery.Metadata metadata, Object value, boolean setQuantity) {
            Item tabularDataItem = new Item();
            tabularDataItem.setValue(Utils.getMeasure(metadata, value));
            tabularDataItem.setSeries(Utils.getSeriesData(metadata, value));
            tabularDataItem.setGroup(Utils.getGroupData(metadata, value));
            if (setQuantity && !"cubeworkload.quantity".equalsIgnoreCase(metadata.getColumn())) {
                tabularDataItem.setQuantity(Utils.getQuantity(metadata, value));
            } else {
                tabularDataItem.setQuantity(1);
            }
            return tabularDataItem;
        }

        public String getSeries() {
            if (this.series == null) {
                return "";
            }
            return this.getString(this.series.getId());
        }

        public Dimension getSeriesDimension() {
            return this.series;
        }

        public String getGroup() {
            if (this.group == null) {
                return "";
            }
            return this.getString(this.group.getId());
        }

        public Dimension getGroupDimension() {
            return this.group;
        }

        public Number getQuantity() {
            return this.quantity;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public String getAggregationId() {
            return this.getGroup() + "$" + this.getSeries();
        }

        public Serializable[] toArray() {
            Serializable[] array = new Serializable[]{this.getString(this.group.getId()), this.getString(this.series.getId()), (Serializable)this.value};
            return array;
        }

        public String toString() {
            String itemStr = "Item: group [";
            itemStr = itemStr + (this.group == null ? "null" : this.group.toString());
            itemStr = itemStr + "] series [";
            itemStr = itemStr + (this.series == null ? "null" : this.series.toString());
            itemStr = itemStr + "] value [";
            itemStr = itemStr + (this.value == null ? "null" : this.value.toString());
            itemStr = itemStr + "] quantity [";
            itemStr = itemStr + (this.quantity == null ? "null" : this.quantity.toString());
            itemStr = itemStr + "]\n";
            return itemStr;
        }

        public RowDataType toRowData() {
            ValueDataType measure = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();
            if (this.value == null) {
                measure.setNull(true);
            } else {
                measure.setNull(false);
                measure.setValue(this.getString(this.value));
                measure.setJavaType(this.value.getClass().getName());
                measure.setLabel(null);
            }
            ValueDataType xSeries = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();
            if (this.series == null) {
                xSeries.setNull(true);
            } else {
                xSeries.setNull(false);
                xSeries.setValue(this.getString(this.series.getId()));
                xSeries.setJavaType(this.series.getId().getClass().getName());
                xSeries.setLabel(this.series.getLabel());
            }
            ValueDataType xGroup = ModelTypeFactory.getWidgetTypeFactory().createValueDataType();
            if (this.group == null) {
                xGroup.setNull(true);
            } else {
                xGroup.setNull(false);
                xGroup.setValue(this.getString(this.group.getId()));
                xGroup.setJavaType(this.group.getId().getClass().getName());
                xGroup.setLabel(this.group.getLabel());
            }
            RowDataType rowData = ModelTypeFactory.getWidgetTypeFactory().createRowDataType();
            rowData.setMeasure(measure);
            rowData.setSeries(xSeries);
            rowData.setGroup(xGroup);
            return rowData;
        }

        public void setQuantity(Number quantity) {
            this.quantity = quantity;
        }

        private void setGroupValue(Object group) {
            this.group = new Dimension(group, null);
        }

        private void setGroup(Dimension group) {
            this.group = group;
        }

        private void setSeriesValue(Object series) {
            this.series = new Dimension(series, null);
        }

        private void setSeries(Dimension series) {
            this.series = series;
        }

        private void setValue(Object value) {
            this.value = value == null ? null : (value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : (value instanceof String ? value : (value instanceof Date ? value : null)));
        }

        private String getString(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof Date) {
                return DateFormat.getDateInstance(3, Locale.US).format((Date)object);
            }
            return object.toString();
        }

        public static class Dimension
        implements Serializable {
            private Object id;
            private String label;
            private String shortLabel;
            private static final long serialVersionUID = -100L;

            public Dimension(Object id, String label) {
                this.id = id == null ? "" : id;
                this.label = label;
            }

            public Dimension(Object id, String label, String shortLabel) {
                this.id = id == null ? "" : id;
                this.label = label;
                this.shortLabel = shortLabel;
            }

            public Object getId() {
                return this.id;
            }

            public String getLabel() {
                return this.label;
            }

            public String getShortLabel() {
                return this.shortLabel;
            }

            public String toString() {
                return "Dimension: id [" + this.id + "], label [" + this.label + "]";
            }
        }
    }
}

