/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;

public class JpqlQueryCache {
    private Queue<String> cacheQueue;
    private final int maxQuerySize = 100;
    private Map<String, String> queryCache;

    public JpqlQueryCache() {
        try {
            this.init();
        }
        catch (DashboardQueryException e) {
            e.printStackTrace();
        }
    }

    public void init() throws DashboardQueryException {
        this.queryCache = new Hashtable<String, String>();
        this.cacheQueue = new LinkedList<String>();
        this.addToCache("-10000", "SELECT cubeprocess.processName, SUM(cubeworkload.quantity)\n FROM CubeProcess cubeprocess JOIN cubeprocess.cubeActivityList cubeactivity JOIN cubeactivity.cubeWorkloadList cubeworkload\n GROUP BY cubeprocess.processName");
        this.addToCache("-10001", "SELECT cubeprocess.processName, cuberole.roleName, SUM(cubeworkload.quantity)\n FROM CubeProcess cubeprocess JOIN cubeprocess.cubeActivityList cubeactivity \n      JOIN cubeactivity.cubeWorkloadList cubeworkload, CubeRole cuberole \n      JOIN cuberole.cubeWorkloadList cubeworkload \n GROUP BY cubeprocess.processName, cuberole.roleName");
        this.addToCache("-10002", "SELECT cubeprocess.processName, AVG(cubeprocessperformance.taskTime)\n FROM CubeProcess cubeprocess JOIN cubeprocess.cubeProcessPerformanceList cubeprocessperformance\n GROUP BY cubeprocess.processName");
        this.addToCache("-10003", "SELECT cubeprocess.processName, cuberole.roleName, AVG(cubeprocessperformance.taskTime)\n FROM CubeProcess cubeprocess JOIN cubeprocess.cubeActivityList cubeactivity \n      JOIN cubeactivity.cubeWorkloadList cubeworkload, CubeRole cuberole JOIN cuberole.cubeWorkloadList cubeworkload1 \n GROUP BY cubeprocess.processName, cuberole.roleName");
    }

    public String resolveQueryCache(String seriesId) throws DashboardQueryException {
        return this.queryCache.get(seriesId);
    }

    public Map getCache() throws DashboardQueryException {
        return this.queryCache;
    }

    public Queue getCacheSequenceQueue() throws DashboardQueryException {
        return this.cacheQueue;
    }

    public void updateCacheSequence(String seriesId) {
        if (this.queryCache.get(seriesId) != null) {
            this.cacheQueue.remove(seriesId);
            this.cacheQueue.add(seriesId);
        }
    }

    public void addToCache(String seriesId, String jpqlQuery) throws DashboardQueryException {
        if (this.resolveQueryCache(seriesId) != null) {
            if (this.cacheQueue.contains(seriesId)) {
                this.updateCacheSequence(seriesId);
            }
        } else {
            if (this.queryCache.size() > 100) {
                this.removeOldCache();
            }
            this.queryCache.put(seriesId, jpqlQuery);
            this.cacheQueue.add(seriesId);
        }
    }

    public void removeFromCache(String seriesId) throws DashboardQueryException {
        this.cacheQueue.remove(seriesId);
        this.queryCache.remove(seriesId);
    }

    private void removeOldCache() throws DashboardQueryException {
        String seriesID = this.cacheQueue.remove();
        this.queryCache.remove(seriesID);
    }
}

