/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import org.jetbrains.annotations.NotNull;

public class JPQLQuery
implements Serializable {
    private AggregateFunctionTypeEnum aggregateFunctionType = null;
    private Map<String, Object> binding = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private DataSourceTypeEnum dataSourceType = null;
    private String jpqlQuery = null;
    private Metadata metadata = null;
    private ValueTypeEnum valueType = ValueTypeEnum.VALUE;
    private static final long serialVersionUID = -100L;

    private JPQLQuery() {
    }

    public static JPQLQuery create(@NotNull String jpqlQuery) {
        return JPQLQuery.create(jpqlQuery, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
    }

    public static JPQLQuery create(@NotNull String jpqlQuery, @NotNull Map<String, Object> binding) {
        return JPQLQuery.create(jpqlQuery, binding, ValueTypeEnum.VALUE);
    }

    public static JPQLQuery create(@NotNull String jpqlQuery, @NotNull Map<String, Object> binding, @NotNull ValueTypeEnum valueType) {
        return JPQLQuery.create(jpqlQuery, binding, valueType, null);
    }

    public static JPQLQuery create(@NotNull String jpqlQuery, @NotNull Map<String, Object> binding, @NotNull ValueTypeEnum valueType, Metadata metadata) {
        return JPQLQuery.create(jpqlQuery, binding, valueType, metadata, null, null);
    }

    public static JPQLQuery create(@NotNull String jpqlQuery, @NotNull Map<String, Object> binding, @NotNull ValueTypeEnum valueType, Metadata metadata, DataSourceTypeEnum dataSourceType, AggregateFunctionTypeEnum aggregateFunctionType) {
        JPQLQuery query = new JPQLQuery();
        query.jpqlQuery = jpqlQuery;
        query.binding = binding;
        query.valueType = valueType;
        query.metadata = metadata;
        query.dataSourceType = dataSourceType;
        query.aggregateFunctionType = aggregateFunctionType;
        return query;
    }

    public String getQuery() {
        return this.jpqlQuery;
    }

    public void setQuery(@NotNull String jpqlQuery) {
        this.jpqlQuery = jpqlQuery;
    }

    public boolean hasBinding() {
        return this.binding != null && !this.binding.isEmpty();
    }

    public void setBinding(@NotNull String variable, @NotNull Serializable value) {
        this.binding.put(variable, value);
    }

    public Map<String, Object> getBinding() {
        return this.binding;
    }

    public Object getBinding(@NotNull String variable) {
        return this.binding.get(variable);
    }

    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.jpqlQuery == null ? "" : this.jpqlQuery;
    }

    public DataSourceTypeEnum getDataSourceType() {
        return this.dataSourceType;
    }

    public AggregateFunctionTypeEnum getAggregateFunctionType() {
        return this.aggregateFunctionType;
    }

    public static class Metadata {
        private String aggregateFunction;
        private String column;
        private List<String> group;
        private String groupLabel;
        private boolean groupUseRanges;
        private String measureLabel;
        private List<String> series = new ArrayList<String>();
        private String seriesLabel;
        private boolean seriesUseRanges;

        public Metadata(@NotNull String column, String aggregateFunction) {
            this.group = new ArrayList<String>();
            this.aggregateFunction = aggregateFunction;
            this.column = column;
        }

        public String getMeasure() {
            return this.aggregateFunction + "(" + this.column + ")";
        }

        public String getColumn() {
            return this.column;
        }

        public void addSeries(@NotNull String series) {
            this.series.add(series);
        }

        public List<String> getSeries() {
            return this.series;
        }

        public void addGroup(@NotNull String group) {
            this.group.add(group);
        }

        public List<String> getGroup() {
            return this.group;
        }

        public String getMeasureLabel() {
            return this.measureLabel;
        }

        public void setMeasureLabel(String measureLabel) {
            this.measureLabel = measureLabel;
        }

        public String getSeriesLabel() {
            return this.seriesLabel;
        }

        public void setSeriesLabel(String seriesLabel) {
            this.seriesLabel = seriesLabel;
        }

        public boolean seriesUseRanges() {
            return this.seriesUseRanges;
        }

        public void setSeriesUseRanges(boolean seriesUseRanges) {
            this.seriesUseRanges = seriesUseRanges;
        }

        public String getGroupLabel() {
            return this.groupLabel;
        }

        public void setGroupLabel(String groupLabel) {
            this.groupLabel = groupLabel;
        }

        public boolean groupUseRanges() {
            return this.groupUseRanges;
        }

        public void setGroupUseRanges(boolean groupUseRanges) {
            this.groupUseRanges = groupUseRanges;
        }
    }
}

