/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.impl;

import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;

public class WidgetIdHelper {
    public static String setWidgetId(WidgetType widget) {
        String id = "";
        if (widget != null && widget.isSetData() && widget.getData().isSetSeries()) {
            for (SeriesType series : widget.getData().getSeries()) {
                id = id + WidgetIdHelper.setSeriesId(series);
            }
            widget.setId(id);
        }
        return id;
    }

    private static String setSeriesId(SeriesType series) {
        StringBuilder id = new StringBuilder("");
        if (series != null) {
            if (series.isSetDataSource()) {
                id.append(series.getDataSource().hashCode() % 100);
            }
            if (series.isSetMeasurement()) {
                id.append(series.getMeasurement().getVariable().hashCode() % 100);
                id.append(series.getMeasurement().getAggregateFunction().hashCode() % 100);
            }
            if (series.isSetDimensions()) {
                if (series.getDimensions().isSetXSeries()) {
                    id.append(series.getDimensions().getXSeries().hashCode() % 100);
                }
                if (series.getDimensions().isSetXGroup()) {
                    id.append(series.getDimensions().getXGroup().hashCode() % 100);
                }
            }
            if (series.isSetPredicate()) {
                id.append(WidgetIdHelper.generatePredicateId(series.getPredicate()));
            }
            series.setId(id.toString());
        }
        return id.toString();
    }

    private static String generatePredicateId(PredicateType predicate) {
        StringBuilder id = new StringBuilder("");
        if (predicate.isSetJoinOperator()) {
            id.append(predicate.getJoinOperator().hashCode() % 100);
        }
        if (predicate.isSetConditions()) {
            for (ConditionType condition : predicate.getConditions()) {
                id.append(condition.getVariable().hashCode() % 100);
                id.append(condition.getOperator().hashCode() % 100);
            }
        }
        if (predicate.isSetLeftCondition()) {
            id.append(WidgetIdHelper.generatePredicateId(predicate.getLeftCondition()));
        }
        if (predicate.isSetRightCondition()) {
            id.append(WidgetIdHelper.generatePredicateId(predicate.getRightCondition()));
        }
        return id.toString();
    }
}

