/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.dashboard.impl;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.analytics.dashboard.DashboardService;
import oracle.bpm.analytics.dashboard.impl.WidgetDrillDownBuilder;
import oracle.bpm.analytics.dashboard.impl.WidgetIdHelper;
import oracle.bpm.analytics.dashboard.query.DashboardQueryException;
import oracle.bpm.analytics.dashboard.query.ProcessCubeQueryManagerService;
import oracle.bpm.analytics.dashboard.query.SqlLookup;
import oracle.bpm.analytics.dashboard.query.WidgetData;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;

@Stateless(name="DashboardServiceBean", mappedName="BPMAnalytics")
public class DashboardServiceBean
implements DashboardService {
    @EJB(beanName="PersistenceQueryServiceBean", beanInterface=PersistenceQueryService.class, mappedName="BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceQueryService")
    private PersistenceQueryService persistenceQueryService;
    @EJB(beanName="ProcessCubeQueryManagerServiceBean", beanInterface=ProcessCubeQueryManagerService.class, mappedName="BPMAnalytics#oracle.bpm.analytics.dashboard.query.ProcessCubeQueryManagerService")
    private ProcessCubeQueryManagerService queryExecutor;

    @Override
    public WidgetData getWidgetData(WidgetType widget) throws DashboardQueryException {
        WidgetIdHelper.setWidgetId(widget);
        return this.queryExecutor.getWidgetData(widget);
    }

    @Override
    public WidgetType getWidgetDrillDown(WidgetType widget, String dimension, String value) {
        return WidgetDrillDownBuilder.buildWidgetDrillDown(widget, dimension, value, this.getValueLabel(dimension, value));
    }

    @Override
    public List<String> getComponentInstances(WidgetType widget, String dimension, String value) throws DashboardQueryException {
        return this.queryExecutor.getComponentInstances(widget, dimension, value);
    }

    private String getValueLabel(String dimension, String value) {
        String label = value;
        if (dimension != null && value != null) {
            if ("process".equals(dimension)) {
                label = this.getProcessLabel(value);
            } else if ("activity".equals(dimension)) {
                label = this.getActivityLabel(value);
            } else if ("role".equals(dimension)) {
                label = this.getRoleLabel(value);
            } else if ("participant".equals(dimension)) {
                label = this.getParticipantLabel(label);
            }
        }
        return label;
    }

    private String getProcessLabel(String value) {
        String label;
        block4: {
            label = value;
            ComponentDNModel componentDN = null;
            try {
                componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)value);
                if (componentDN != null) {
                    String processLabel = componentDN.getComponentName();
                    SqlLookup.Column domainColumn = SqlLookup.getProcessDomainColumn();
                    SqlLookup.Column compositeColumn = SqlLookup.getProcessCompositeNameColumn();
                    SqlLookup.Column processColumn = SqlLookup.getProcessNameColumn();
                    SqlLookup.Column labelColumn = SqlLookup.getProcessLabelColumn();
                    String query = "Select " + labelColumn.getQualifiedColumn() + " from CubeProcess cubeprocess where " + domainColumn.getQualifiedColumn() + " = '" + componentDN.getCompositeDN().getApplicationName() + "'" + " and " + compositeColumn.getQualifiedColumn() + " = '" + componentDN.getCompositeDN().getCompositeName() + "'" + " and " + processColumn.getQualifiedColumn() + " = '" + componentDN.getComponentName() + "'";
                    List labels = this.persistenceQueryService.select(query);
                    if (labels != null && labels.size() > 0) {
                        processLabel = labels.get(0).toString();
                    }
                    label = "[" + componentDN.getCompositeDN().getCompositeName() + "] " + processLabel;
                }
            }
            catch (Exception exception) {
                if (componentDN == null) break block4;
                label = "[" + componentDN.getCompositeDN().getCompositeName() + "] " + componentDN.getComponentName();
            }
        }
        return label;
    }

    private String getActivityLabel(String value) {
        String label;
        block5: {
            label = value;
            int indexOf = value.lastIndexOf("/");
            if (indexOf > 0) {
                ComponentDNModel componentDN = null;
                String activityName = value.substring(indexOf + 1);
                String processDN = value.substring(0, indexOf);
                try {
                    componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)processDN);
                    if (componentDN != null) {
                        Object values;
                        String processLabel = componentDN.getComponentName();
                        String activityLabel = activityName;
                        SqlLookup.Column domainColumn = SqlLookup.getProcessDomainColumn();
                        SqlLookup.Column compositeColumn = SqlLookup.getProcessCompositeNameColumn();
                        SqlLookup.Column processColumn = SqlLookup.getProcessNameColumn();
                        SqlLookup.Column activityColumn = SqlLookup.getActivityNameColumn();
                        SqlLookup.Column processLabelColumn = SqlLookup.getProcessLabelColumn();
                        SqlLookup.Column activityLabelColumn = SqlLookup.getActivityLabelColumn();
                        String query = "Select " + processLabelColumn.getQualifiedColumn() + ", " + activityLabelColumn.getQualifiedColumn() + " from CubeProcess cubeprocess JOIN cubeprocess.cubeActivityList cubeactivity " + " where " + domainColumn.getQualifiedColumn() + " = '" + componentDN.getCompositeDN().getApplicationName() + "'" + " and " + compositeColumn.getQualifiedColumn() + " = '" + componentDN.getCompositeDN().getCompositeName() + "'" + " and " + processColumn.getQualifiedColumn() + " = '" + componentDN.getComponentName() + "'" + " and " + activityColumn.getQualifiedColumn() + " = '" + activityName + "'";
                        List labels = this.persistenceQueryService.select(query);
                        if (labels != null && labels.size() > 0 && (values = labels.get(0)).getClass().isArray()) {
                            Object[] array = (Object[])values;
                            processLabel = array[0].toString();
                            activityLabel = array[1].toString();
                        }
                        label = "[" + componentDN.getCompositeDN().getCompositeName() + "] " + processLabel + " > " + activityLabel;
                    }
                }
                catch (Exception exception) {
                    if (componentDN == null) break block5;
                    label = "[" + componentDN.getCompositeDN().getCompositeName() + "] " + componentDN.getComponentName() + activityName;
                }
            }
        }
        return label;
    }

    private String getRoleLabel(String value) {
        String label = value;
        try {
            if (label != null) {
                SqlLookup.Column roleName = SqlLookup.getRoleNameColumn();
                SqlLookup.Column roleLabel = SqlLookup.getRoleLabelColumn();
                String query = "Select " + roleLabel.getQualifiedColumn() + " from CubeRole " + " where " + roleName.getQualifiedColumn() + " = '" + value + "'";
                List labels = this.persistenceQueryService.select(query);
                if (labels != null && labels.size() > 0) {
                    Object values = labels.get(0);
                    if (values.getClass().isArray()) {
                        Object[] array = (Object[])values;
                        label = array[0].toString();
                    } else {
                        label = values.toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return label;
    }

    private String getParticipantLabel(String value) {
        String label = value;
        if (value != null) {
            String composite;
            int typeSeparatorIndex = value.lastIndexOf(",");
            int compositeSeparatorIndex = value.lastIndexOf(".");
            String type = typeSeparatorIndex == -1 ? "user" : value.substring(typeSeparatorIndex + 1);
            String string = composite = compositeSeparatorIndex == -1 ? null : value.substring(0, compositeSeparatorIndex);
            String user = compositeSeparatorIndex == -1 ? (typeSeparatorIndex == -1 ? value : value.substring(0, typeSeparatorIndex)) : (typeSeparatorIndex == -1 ? value.substring(compositeSeparatorIndex + 1) : value.substring(compositeSeparatorIndex + 1, typeSeparatorIndex));
            label = (composite != null ? "[" + composite + "] " : "") + user + " (" + type + ")";
        }
        return label;
    }
}

