/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import java.awt.Component;
import java.net.URL;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.BusinessRuleData;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.rules.BusinessRulePanel;
import oracle.bpm.fusion.soa.rules.BusinessRuleUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.i18n.StringTranslator;

class BusinessRuleDialog
extends OkCancelDialog {
    private BusinessRuleData businessRuleData;
    private BusinessRulePanel businessRulePanel;
    private FlowNode flowNode;

    public BusinessRuleDialog(UiWindow parent, FlowNode flowNode) {
        super(parent, ProjectUiMsg.CREATE((Msg)ProjectModelMsg.BUSINESS_RULE));
        this.flowNode = flowNode;
        this.init();
    }

    public String getHelpId() {
        return this.businessRulePanel.getHelpId();
    }

    public void ok() {
        if (this.businessRulePanel.validateData()) {
            final StatusGlassPane glass = new StatusGlassPane((Component)this.getContentPane().asSwing());
            glass.setVisibilityDelay(0);
            glass.enableUserInput(false);
            glass.setStatusMessage(StringTranslator.getString((String)"RE_PLEASE_WAIT"), StringTranslator.getString((String)"RE_CREATING_DICTIONARY"));
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        final WizardData data = BusinessRuleDialog.this.businessRulePanel.getWizardData();
                        final Project jDevProject = BusinessRuleDialog.this.getJDevProject();
                        final Any.Holder url = new Any.Holder();
                        VFileSystem dataFileSystem = BusinessRuleDialog.this.getDataFileSystem();
                        dataFileSystem.runWithEventsDelayed(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    url.value = BusinessRuleUtils.createBusinessRule(jDevProject, data);
                                }
                                catch (Exception e) {
                                    MessageDialog.showError((Msg)FusionSoaMsg.ERROR_CREATING_BUSINESS_RULE(data.getName()), (Throwable)e);
                                }
                            }
                        });
                        if (url.value != null) {
                            final MutableComponentCatalog catalog = (MutableComponentCatalog)BusinessRuleDialog.this.getProject().getComponentCatalog();
                            dataFileSystem.runWithEventsDelayed(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        Transactable root = (Transactable)BusinessRuleDialog.this.getProject().getCatalogRoot();
                                        try {
                                            root.beginTransaction();
                                            catalog.sync();
                                        }
                                        finally {
                                            root.endTransaction();
                                        }
                                    }
                                    catch (Exception e) {
                                        MessageDialog.showError((Msg)FusionSoaMsg.ERROR_CATALOGING_BUSINESS_RULE(data.getName()));
                                        BusinessRuleDialog.this.closeDialog(false);
                                    }
                                }
                            });
                            Sequence<Tuple<String, String>> inputParameters = BusinessRuleDialog.this.businessRulePanel.createInputParameters();
                            Sequence<Tuple<String, String>> outputParameters = BusinessRuleDialog.this.businessRulePanel.createOutputParameters();
                            BusinessRuleData businessRuleData = new BusinessRuleData((URL)url.value, inputParameters, outputParameters);
                            BusinessRuleDialog.this.setBusinessRuleData(businessRuleData);
                            BusinessRuleDialog.this.closeDialog(true);
                        }
                    }
                    finally {
                        glass.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        }
    }

    BusinessRuleData getBusinessRuleData() {
        return this.businessRuleData;
    }

    private VFileSystem getDataFileSystem() {
        return this.getProjectLoader().getProjectFileSystem().getDataFileSystem();
    }

    private ProjectLoader getProjectLoader() {
        return this.getProject().getLoader();
    }

    private void setBusinessRuleData(BusinessRuleData businessRuleData) {
        this.businessRuleData = businessRuleData;
    }

    private oracle.bpm.project.model.Project getProject() {
        return this.flowNode.getProject();
    }

    private Project getJDevProject() {
        Project result = null;
        oracle.bpm.project.model.Project project = this.getProject();
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            result = adaptable.as(Project.class);
        }
        return result;
    }

    private void init() {
        UiContainer parent = this.getContentPane();
        this.businessRulePanel = new BusinessRulePanel(parent, this.flowNode, this.getJDevProject());
        parent.add((UiComponent)this.businessRulePanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void closeDialog(final boolean isOk) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BusinessRuleDialog.this.setUserAccepted(isOk);
                BusinessRuleDialog.this.close();
            }
        });
    }
}

