/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpel.services.common.util.JaxbUtil;
import oracle.bpel.services.workflow.metadata.config.model.CollectionType;
import oracle.bpel.services.workflow.metadata.config.model.CollectionsType;
import oracle.bpel.services.workflow.metadata.config.model.ExternalAttributeKeyType;
import oracle.bpel.services.workflow.metadata.config.model.ExternalAttributeKeysType;
import oracle.bpel.services.workflow.metadata.config.model.ExternalAttributeType;
import oracle.bpel.services.workflow.metadata.config.model.MessageAttributeType;
import oracle.bpel.services.workflow.metadata.config.model.ObjectFactory;
import oracle.bpel.services.workflow.metadata.config.model.PartType;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolverImpl;
import oracle.tip.tools.ide.workflow.api.EntityCollection;
import oracle.tip.tools.ide.workflow.api.EntityCollectionChooserData;
import oracle.tip.tools.ide.workflow.api.EntityDetailData;
import oracle.tip.tools.ide.workflow.api.ICollectionData;
import oracle.tip.tools.ide.workflow.api.IPayloadData;
import oracle.tip.tools.ide.workflow.api.SimpleCollection;
import oracle.tip.tools.ide.workflow.api.SimpleCollectionChooserData;
import oracle.tip.tools.ide.workflow.editor.PayloadManager;
import oracle.tip.tools.ide.workflow.editor.data.PayloadData;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

class PayloadIOHandler {
    private MapperNSResolver mNSResolver = new MapperNSResolverImpl();
    private String workflowName;
    private static final String ELEMENT = "ELEMENT";
    private static final String COMPLEX_TYPE = "COMPLEX_TYPE";
    private static final String SIMPLE_TYPE = "SIMPLE_TYPE";

    PayloadIOHandler(String workflowName) {
        this.workflowName = workflowName;
    }

    public void includePayloadData(TaskDefinition taskDefinition, ObjectFactory objectFactory, Collection<IPayloadData> dataCollection, File payloadFile) {
        WorkflowConfigurationType workflowConfiguration = taskDefinition.getWorkflowConfiguration();
        PayloadType payloadType = workflowConfiguration.getPayload();
        if (payloadType == null) {
            payloadType = objectFactory.createPayloadType();
        }
        payloadType.getMessageAttribute().clear();
        payloadType.getExternalAttribute().clear();
        if (payloadFile.getName() != null) {
            payloadType.setXmlSchemaDefinition("xsd/" + payloadFile.getName());
        }
        if (dataCollection != null) {
            for (IPayloadData payloadData : dataCollection) {
                this.createPayloadType(workflowConfiguration, payloadType, payloadData, objectFactory);
            }
        }
        workflowConfiguration.setPayload(payloadType);
        this.savePayloadDocument(payloadFile, dataCollection);
    }

    private void savePayloadDocument(File payloadFile, Collection<IPayloadData> data) {
        if (payloadFile == null) {
            return;
        }
        List list = PayloadManager.convertUIDataToPayloadItemData(data);
        Document d = this.getPayloadDocument(list);
        if (d instanceof XMLDocument) {
            XMLDocument xmld = (XMLDocument)d;
            try {
                xmld.print((OutputStream)new BufferedOutputStream(new FileOutputStream(payloadFile)), "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Document getPayloadDocument(List payloadItemList) {
        oracle.tip.tools.ide.common.bpelparser.extension.workflow.payload.PayloadManager pManager = new oracle.tip.tools.ide.common.bpelparser.extension.workflow.payload.PayloadManager(this.workflowName);
        return pManager.createDocument(payloadItemList);
    }

    private void createPayloadType(WorkflowConfigurationType pConfig, PayloadType payloadType, IPayloadData payloadData, ObjectFactory factory) {
        String type = payloadData.getPayloadType();
        if ("Normal".equals(type)) {
            this.createDefaultPayloadType(pConfig, payloadType, payloadData, factory, false);
        } else {
            this.createExternalPayloadType(pConfig, payloadType, payloadData, factory);
        }
    }

    private void createDefaultPayloadType(WorkflowConfigurationType pConfig, PayloadType payloadType, IPayloadData payloadData, ObjectFactory factory, boolean isExternal) {
        MessageAttributeType mt = factory.createMessageAttributeType();
        String prefix = this.mNSResolver.addNSEntry(null, payloadData.getNamespace());
        mt.setName(payloadData.getName());
        try {
            JaxbUtil.setNamespaceDeclaration((JaxbNode)((JaxbNode)pConfig), (String)prefix, (String)payloadData.getNamespace());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = payloadData.getType();
        if ("Element".equals(type)) {
            mt.setAttributeType(ELEMENT);
        } else if ("SimpleType".equals(type)) {
            mt.setAttributeType(SIMPLE_TYPE);
        } else if ("ComplexType".equals(type)) {
            mt.setAttributeType(COMPLEX_TYPE);
        }
        mt.setType(prefix + ":" + payloadData.getTypeData());
        mt.setUpdatable(payloadData.isModifiable());
        mt.setExternal(isExternal);
        payloadType.getMessageAttribute().add(mt);
        ICollectionData icd = (ICollectionData)payloadData.getProperty((Object)"Collections");
        CollectionsType ctype = mt.getCollections();
        if (ctype != null) {
            ctype.getCollection().clear();
        }
        if (icd != null && icd.size() > 0) {
            CollectionsType ct = mt.getCollections();
            if (ct == null) {
                ct = factory.createCollectionsType();
                mt.setCollections(ct);
            }
            List l = ct.getCollection();
            SimpleCollectionChooserData scd = (SimpleCollectionChooserData)icd;
            if (scd.isUse()) {
                for (SimpleCollection sc : scd.getCollection()) {
                    CollectionType ctt = factory.createCollectionType();
                    ctt.setName(sc.getName());
                    ctt.setXpath(sc.getXPath());
                    ctt.setRepeating(sc.isRepeating());
                    l.add(ctt);
                }
            }
        }
    }

    private void createExternalPayloadType(WorkflowConfigurationType pConfig, PayloadType payloadType, IPayloadData payloadData, ObjectFactory factory) {
        EntityDetailData edd = (EntityDetailData)payloadData;
        PayloadData ipd = new PayloadData();
        ipd.setName(edd.getInputMessage());
        ipd.setNamespace(edd.getNamespace());
        ipd.setType("Element");
        ipd.setTypeData(edd.getInputMessage());
        ipd.setModifiable(false);
        this.createDefaultPayloadType(pConfig, payloadType, (IPayloadData)ipd, factory, true);
        ExternalAttributeType ext = factory.createExternalAttributeType();
        ext.setName(edd.getOutputMessage());
        ext.setReferenceName(edd.getReference());
        ext.setOperationName(edd.getOperation());
        PartType ipt = factory.createPartType();
        String prefix = this.mNSResolver.addNSEntry(null, edd.getNamespace());
        ipt.setElement(prefix + ":" + edd.getInputMessage());
        ipt.setPartName(edd.getInputPartName());
        ext.setInput(ipt);
        PartType opt = factory.createPartType();
        opt.setElement(prefix + ":" + edd.getOutputMessage());
        opt.setPartName(edd.getOutputPartName());
        ext.setOutput(opt);
        payloadType.getExternalAttribute().add(ext);
        ICollectionData icd = (ICollectionData)edd.getProperty((Object)"Collections");
        if (icd != null && icd.size() > 0) {
            EntityCollectionChooserData ecc = (EntityCollectionChooserData)icd;
            Collection ece = ecc.getCollection();
            CollectionsType cst = factory.createCollectionsType();
            if (ecc.isUse()) {
                for (EntityCollection ec : ece) {
                    String name = ec.getName();
                    String xpath = ec.getXPath();
                    Collection keys = ec.getKeys();
                    if (name == null || name.trim().length() == 0 || xpath == null || xpath.trim().length() == 0) continue;
                    CollectionType ct = factory.createCollectionType();
                    ExternalAttributeKeysType extKeys = factory.createExternalAttributeKeysType();
                    ct.setKeys(extKeys);
                    ct.setName(name);
                    ct.setXpath(xpath);
                    ct.setRepeating(ec.isRepeating());
                    if (keys != null) {
                        List l = extKeys.getKey();
                        for (QName key : keys) {
                            ExternalAttributeKeyType keyType = factory.createExternalAttributeKeyType();
                            String uri = key.getNamespaceURI();
                            String localPart = key.getLocalPart();
                            String pre2 = this.mNSResolver.resolveNamespaceURI(uri);
                            StringBuilder sb = new StringBuilder();
                            sb.append(localPart);
                            keyType.setQName(sb.toString());
                            l.add(keyType);
                        }
                    }
                    cst.getCollection().add(ct);
                }
            }
            ext.setCollections(cst);
        }
    }
}

