/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.fusion.soa.humantask.DataDeclarationChooserDialog;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.IdentifierTextFieldEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.Identifier;
import oracle.tip.tools.ide.workflow.api.IPayloadContainer;
import oracle.tip.tools.ide.workflow.api.IPayloadData;
import oracle.tip.tools.ide.workflow.editor.data.PayloadData;
import oracle.tip.tools.ide.workflow.editor.data.PayloadEditorData;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import org.jetbrains.annotations.Nullable;

class ParametersPanel
extends Panel {
    private BaseAction addAction;
    private DataDeclarationChooserDialog dataDeclarationDialog;
    private ParametersTableModel model;
    private TextField outcomeTextField;
    private UserTask userTask;
    private static final String OUTCOME = "outcome";
    private static final String BASE_SCHEMA_FILE = "/xsd/humantaskschema.xsd";
    private static final Transfer[] TRANSFERS = new Transfer[]{LocalObjectTransfer.getInstance(Sequence.class)};

    ParametersPanel(UiContainer parent, UserTask userTask) {
        super(parent);
        this.userTask = userTask;
        this.init();
    }

    public Collection<Entry> getEntries() {
        return this.model.getData();
    }

    void applyToWFEditorData(WFEditorData data) {
        Collection<Entry> entries = this.getEntries();
        PayloadEditorData payloadEditorData = ParametersPanel.createPayloadEditorData(entries);
        data.setPayloadContainer((IPayloadContainer)payloadEditorData);
    }

    Sequence<Tuple<String, String>> createInputParameters() {
        return this.createParameters(true);
    }

    Sequence<Tuple<String, String>> createOutputParameters() {
        return this.createParameters(false);
    }

    boolean validateData() {
        return true;
    }

    private static PayloadEditorData createPayloadEditorData(Collection<Entry> entries) {
        PayloadEditorData payloadEditorData = new PayloadEditorData();
        ArrayList<IPayloadData> list = new ArrayList<IPayloadData>();
        for (Entry entry : entries) {
            list.add(ParametersPanel.createPayloadData(entry));
        }
        payloadEditorData.setPayloadData(list);
        return payloadEditorData;
    }

    private static IPayloadData createPayloadData(Entry entry) {
        String namespace;
        String typedata;
        String name;
        String type;
        SchemaObject schemaObject = entry.getSchemaObject();
        ArrayList<String> locations = new ArrayList<String>();
        if (schemaObject != null) {
            boolean isElement = schemaObject.isElement();
            type = isElement ? "Element" : (schemaObject.isBasicType() ? "SimpleType" : "ComplexType");
            name = entry.getName();
            typedata = schemaObject.getName();
            namespace = schemaObject.getNamespace();
            String location = schemaObject.getLocation();
            if (location != null) {
                locations.add(URLHelper.buildRelativeLocation((String)BASE_SCHEMA_FILE, (String)location));
            }
        } else {
            type = "SimpleType";
            typedata = name = entry.getName();
            namespace = "";
        }
        PayloadData payloadData = new PayloadData();
        payloadData.setName(name);
        payloadData.setModifiable(entry.isEditable());
        payloadData.setType(type);
        payloadData.setTypeData(typedata);
        payloadData.setNamespace(namespace);
        payloadData.setSchemaLocations(locations);
        return payloadData;
    }

    private Sequence<Tuple<String, String>> createParameters(boolean input) {
        String outcomeTarget;
        Collection<Entry> entries = this.getEntries();
        ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>(entries.size());
        for (Entry entry : entries) {
            if (!input && !entry.isEditable()) continue;
            String parameterName = Identifier.argument(entry.getName());
            String source = input ? entry.getDataDeclaration().getName() : parameterName;
            String target = input ? parameterName : entry.getDataDeclaration().getName();
            result.add(Tuple.create(source, target));
        }
        if (!input && !"".equals(outcomeTarget = this.outcomeTextField.getText())) {
            result.add(Tuple.create(OUTCOME, outcomeTarget));
        }
        return CollectionUtils.asSequence(result);
    }

    private FlowNode getFlowNode() {
        return this.userTask;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0, wrap 1"));
        this.model = new ParametersTableModel();
        Table table = new Table((UiContainer)this, (TableModel)this.model);
        table.setPreferredRows(3);
        TableColorProvider.Default<String> colorProvider = new TableColorProvider.Default<String>(){

            public Color getForeground(String element) {
                Entry entry = (Entry)ParametersPanel.this.model.getRow(this.getRow());
                return entry.isElement() ? Color.GRAY : null;
            }
        };
        TableColumn parameterColumn = table.getColumn(0);
        parameterColumn.setColorProvider((ColorProvider)colorProvider);
        parameterColumn.setCellEditor((TableCellEditor)new ParameterNameEditor(this.model));
        LabelProvider.Default<DataDeclaration> labelProvider = new LabelProvider.Default<DataDeclaration>(){

            public String getText(DataDeclaration element) {
                return element.getName();
            }
        };
        table.getColumn(1).setLabelProvider((LabelProvider)labelProvider);
        new DropTargetHandler((UiComponent)this, DndAction.COPY_OR_MOVE, TRANSFERS){

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                Sequence dataDeclarations = (Sequence)data;
                for (DataDeclaration dataDeclaration : dataDeclarations) {
                    Entry entry = Entry.create(ParametersPanel.this.model.getDefaultName(dataDeclaration.getName()), dataDeclaration);
                    ParametersPanel.this.model.addRow(entry);
                }
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                Sequence dataDeclarations;
                boolean result = false;
                if (data instanceof Sequence && !(dataDeclarations = (Sequence)data).isEmpty()) {
                    result = true;
                    for (DataDeclaration dataDeclaration : dataDeclarations) {
                        if (this.isValid(dataDeclaration)) continue;
                        result = false;
                        break;
                    }
                }
                return result;
            }

            private boolean isValid(DataDeclaration dataDeclaration) {
                boolean result = true;
                Entry entry = Entry.create(ParametersPanel.this.model.getDefaultName(dataDeclaration.getName()), dataDeclaration);
                if (entry.isElement()) {
                    if (ParametersPanel.this.model.existName(entry.getName())) {
                        result = false;
                    } else if (ParametersPanel.this.model.existElementType(entry)) {
                        result = false;
                    }
                }
                return result;
            }
        };
        UiComponent toolBarPanel = this.createToolBarPanel((UiContainer)this, table);
        UiComponent outcomePanel = this.createOutcomePanel((UiContainer)this);
        this.add(toolBarPanel, "growx");
        this.add((UiComponent)table, "grow");
        this.add(outcomePanel, "growx");
    }

    private UiComponent createToolBarPanel(UiContainer parent, final Table table) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
        ToolBar toolBar = new ToolBar((UiContainer)panel);
        final BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

            public void run() {
                int[] selected = table.getSelectedRows();
                ParametersPanel.this.model.removeRows(selected);
                ParametersPanel.this.updateSelection(table, selected);
            }
        };
        removeAction.setEnabled(false);
        table.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                removeAction.setEnabled(table.isEnabled() && table.getSelectedRows().length > 0);
            }
        });
        toolBar.add(this.getAddAction());
        toolBar.add(removeAction);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)LibMsg.PARAMETERS), (Object)"growx");
        panel.add((UiComponent)toolBar, (Object)"wrap");
        return panel;
    }

    private UiComponent createOutcomePanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
        this.outcomeTextField = new TextField((UiContainer)this);
        this.outcomeTextField.setEditable(false);
        new DropTargetHandler((UiComponent)this.outcomeTextField, DndAction.COPY_OR_MOVE, TRANSFERS){

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                Sequence dataDeclarations = (Sequence)data;
                for (DataDeclaration dataDeclaration : dataDeclarations) {
                    CatalogType type = dataDeclaration.getType();
                    if (!type.isString()) continue;
                    ParametersPanel.this.outcomeTextField.setText(dataDeclaration.getName());
                }
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                Sequence dataDeclarations;
                boolean result = false;
                if (data instanceof Sequence && !(dataDeclarations = (Sequence)data).isEmpty()) {
                    Iterator iterator = dataDeclarations.iterator();
                    CatalogType type = ((DataDeclaration)iterator.next()).getType();
                    result = type.isString();
                }
                return result;
            }
        };
        BaseAction clearAction = new BaseAction(UIMsg.CLEAR){

            public void run() {
                ParametersPanel.this.outcomeTextField.setText("");
            }
        };
        ToolBar toolBar = new ToolBar((UiContainer)panel);
        toolBar.add(this.getAddAction());
        toolBar.add(clearAction);
        panel.add((UiComponent)Label.create((UiContainer)this, (Msg)FusionSoaMsg.OUTCOME_TARGET));
        panel.add((UiComponent)this.outcomeTextField, (Object)"growx");
        panel.add((UiComponent)toolBar, (Object)"wrap");
        return panel;
    }

    private BaseAction getAddAction() {
        if (this.addAction == null) {
            this.addAction = new BaseAction(UIMsg.ADD){

                public void run() {
                    if (ParametersPanel.this.dataDeclarationDialog == null) {
                        ParametersPanel.this.dataDeclarationDialog = new DataDeclarationChooserDialog(ParametersPanel.this.getOwnerWindow(), (DataDeclarationContainer)ParametersPanel.this.getFlowNode());
                    }
                    if (!ParametersPanel.this.dataDeclarationDialog.isVisible()) {
                        ParametersPanel.this.dataDeclarationDialog.setVisible(true);
                    }
                }
            };
        }
        return this.addAction;
    }

    private void updateSelection(Table table, int[] selection) {
        int rowCount = table.getRowCount();
        if (selection.length > 0 && rowCount > 0) {
            int newSelection = selection[0];
            if (selection[0] >= rowCount) {
                newSelection = rowCount - 1;
            }
            table.setSelectionInterval(newSelection, newSelection);
        }
    }

    private static class ParametersTableModel
    extends ProviderTableModel<Entry> {
        private static final MsgList TITLES = MsgList.create(DesignerMsg.PARAMETER, ProjectMsg.NAME, ProjectMsg.TYPE, DesignerMsg.PROPERTY_EDITABLE);
        private static final int COLUMN_PARAMETER = 0;
        private static final int COLUMN_DATAOBJECT = 1;
        private static final int COLUMN_TYPE = 2;
        private static final int COLUMN_EDITABLE = 3;

        ParametersTableModel() {
            super(TITLES);
        }

        public Object getValueAt(int row, int column) {
            Entry entry = (Entry)this.getRow(row);
            switch (column) {
                case 0: {
                    return entry.getName();
                }
                case 1: {
                    return entry.getDataDeclaration();
                }
                case 2: {
                    return entry.getType();
                }
                case 3: {
                    return entry.isEditable();
                }
            }
            return "";
        }

        public void setValueAt(Object value, int row, int column) {
            Entry entry = (Entry)this.getRow(row);
            switch (column) {
                case 0: {
                    entry.setName((String)value);
                    break;
                }
                case 3: {
                    entry.setEditable((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return DataDeclaration.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int row, int column) {
            Entry entry;
            boolean result = column == 0 ? !(entry = (Entry)this.getRow(row)).isElement() : column == 3;
            return result;
        }

        public String getDefaultName(String suggestedName) {
            int i = 0;
            String result = suggestedName;
            boolean exist = this.existName(result);
            while (exist) {
                result = suggestedName + i++;
                exist = this.existName(result);
            }
            return result;
        }

        private boolean existName(String parameter) {
            List data = this.getData();
            for (Entry entry : data) {
                if (!entry.getName().equals(parameter)) continue;
                return true;
            }
            return false;
        }

        private boolean existElementType(Entry newEntry) {
            List data = this.getData();
            String newType = newEntry.getType();
            for (Entry entry : data) {
                if (!entry.getType().equals(newType)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ParameterNameEditor
    extends IdentifierTextFieldEditor {
        private TextComponent editor;
        private Color INVALID_TYPE_COLOR = Color.RED;
        private ParametersTableModel model;
        private String previousValue;
        private Set<String> usedValues;
        private Color validForegroundColor;

        ParameterNameEditor(ParametersTableModel model) {
            this.setAllowsFirstInUpperCase(true);
            this.model = model;
        }

        public Object getCellEditorValue() {
            String value = (String)super.getCellEditorValue();
            return this.isValidValue(value) ? value : this.previousValue;
        }

        protected TextComponent createEditor(UiContainer parent) {
            this.editor = super.createEditor(parent);
            this.validForegroundColor = this.editor.getForeground();
            this.editor.addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    ParameterNameEditor.this.checkValidValue();
                }

                public void insertUpdate(DocumentEvent e) {
                    ParameterNameEditor.this.checkValidValue();
                }

                public void removeUpdate(DocumentEvent e) {
                    ParameterNameEditor.this.checkValidValue();
                }
            });
            return this.editor;
        }

        protected void setValue(Object value) {
            this.previousValue = value.toString();
            this.usedValues = null;
            super.setValue(value);
        }

        private void checkValidValue() {
            String value = this.editor.getText();
            boolean isValid = this.isValidValue(value);
            this.editor.setForeground(isValid ? this.validForegroundColor : this.INVALID_TYPE_COLOR);
        }

        private boolean isValidValue(String value) {
            return !Str.isEmpty(value) && this.isNotUsed(value);
        }

        private boolean isNotUsed(String value) {
            return !this.getUsedValues().contains(value);
        }

        private Set<String> getUsedValues() {
            if (this.usedValues == null) {
                this.usedValues = new HashSet<String>();
                List entries = this.model.getData();
                for (Entry entry : entries) {
                    String name;
                    if (entry.isElement() || (name = entry.getName()).equals(this.previousValue)) continue;
                    this.usedValues.add(name);
                }
            }
            return this.usedValues;
        }
    }

    static class Entry {
        private DataDeclaration dataDeclaration;
        private Boolean editable;
        private boolean initializedSchemaObject;
        private String name;
        private SchemaObject schemaObject;

        public Entry(String name, DataDeclaration dataDeclaration, boolean editable) {
            this.name = name;
            this.dataDeclaration = dataDeclaration;
            this.editable = editable;
        }

        public static Entry create(String parameter, DataDeclaration dataDeclaration) {
            return new Entry(parameter, dataDeclaration, false);
        }

        public String getName() {
            return this.isElement() ? this.getSchemaObject().getName() : this.name;
        }

        public String getType() {
            return this.getDataDeclaration().getType().getDelegate().getText();
        }

        public DataDeclaration getDataDeclaration() {
            return this.dataDeclaration;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEditable(Boolean editable) {
            this.editable = editable;
        }

        private boolean isElement() {
            SchemaObject schemaObject = this.getSchemaObject();
            return schemaObject != null && schemaObject.isElement();
        }

        @Nullable
        private SchemaObject getSchemaObject() {
            if (!this.initializedSchemaObject) {
                CatalogType catalogType = this.dataDeclaration.getType();
                TypeDescription typeDescription = catalogType.getDelegate();
                try {
                    this.schemaObject = typeDescription.asSchemaObject();
                }
                catch (Exception e) {
                    this.schemaObject = null;
                }
                this.initializedSchemaObject = true;
            }
            return this.schemaObject;
        }
    }
}

