/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.io.File;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.bpel.services.common.util.JaxbUtil;
import oracle.bpel.services.workflow.metadata.config.model.ObjectFactory;
import oracle.bpel.services.workflow.metadata.config.model.OutcomesType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.GlobalConfigurationType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ManagementChainListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParallelCompletionCriteriaType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParameterType;
import oracle.bpel.services.workflow.metadata.routingslip.model.ParticipantsType;
import oracle.bpel.services.workflow.metadata.routingslip.model.Resource;
import oracle.bpel.services.workflow.metadata.routingslip.model.ResourceType;
import oracle.bpel.services.workflow.metadata.taskdefinition.TaskDefinitionUtil;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TranslatableValueType;
import oracle.bpm.fusion.soa.humantask.PayloadIOHandler;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.DictionaryBuilderUtil;
import oracle.tip.tools.ide.workflow.api.IPayloadContainer;
import oracle.tip.tools.ide.workflow.editor.data.CompoundTextData;
import oracle.tip.tools.ide.workflow.editor.data.OwnerData;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesDataUtil;
import oracle.tip.tools.ide.workflow.ide.jdeveloper.JDevWorkflowProject;
import oracle.tip.tools.ide.workflow.projectwizard.JDevProjectBuilder;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;
import oracle.xml.jaxb.JaxbNode;

public class HumanTaskUtils {
    private static final String TASK_EXTENSION = ".task";
    private static final String XPATH = "XPATH";
    private static final String BPM_PERFORMER = "bpm:getPerformer()";
    private static final String APPLICATION_ROLE = "application_role";
    private static final String IDENTITY_TYPE = "application_role";
    private static final String PROCESS_OWNER = "ProcessOwner";
    private static final String PARTICIPANT_NAME = "default.DefaultPerformer";
    private static final String STATIC = "STATIC";
    private static final String APPROVE = "APPROVE";
    private static final String BPM_NAMESPACE = "http://xmlns.oracle.com/bpmn20/extensions";
    private static final String BPM_PREFIX = "bpm";
    private static final String APPLICATION_CONTEXT = "OracleBPMProcessRolesApp";

    private HumanTaskUtils() {
    }

    public static URL createHumanTask(Project jdevProject, WizardData data, WFEditorData editorData, HumanTaskType humanTaskType) throws Exception {
        URL result = null;
        Workspace workspace = DictionaryBuilderUtil.getWorkspace((Project)jdevProject);
        JDevProjectBuilder builder = new JDevProjectBuilder(workspace);
        if (builder.createIDEProject(data)) {
            String name = data.getWorkflowName();
            URL projectUrl = data.getProjectDirectory();
            URL url = URLFactory.newURL((URL)projectUrl, (String)(name + TASK_EXTENSION));
            JDevWorkflowProject workflowProject = new JDevWorkflowProject(jdevProject, name);
            URL payloadFileURL = workflowProject.getPayloadXSD();
            File payloadFile = new File(payloadFileURL.getFile());
            HumanTaskUtils.updateHumanTask(url, editorData, humanTaskType, payloadFile);
            JDevHelper.refreshProjectInAppNavigator((Project)jdevProject);
            result = url;
        }
        return result;
    }

    public static WFEditorData createDefaultWFEditorData(String projectName) {
        WFEditorData data = new WFEditorData();
        OwnerData ownerData = data.getOwnerData();
        ownerData.setIsStatic(true);
        ownerData.setExpression(projectName + "." + PROCESS_OWNER);
        return data;
    }

    private static void updateHumanTask(URL taskUrl, WFEditorData editorData, HumanTaskType humanTaskType, File payloadFile) throws Exception {
        oracle.bpel.services.workflow.metadata.taskdefinition.model.ObjectFactory objectFactory;
        File taskFile = HumanTaskUtils.createFileFromUrl(taskUrl);
        TaskDefinition taskDefinition = HumanTaskUtils.loadTask(taskFile);
        if (taskDefinition instanceof JaxbNode) {
            JaxbUtil.setNamespaceDeclaration((JaxbNode)((JaxbNode)taskDefinition), (String)BPM_PREFIX, (String)BPM_NAMESPACE);
        }
        taskDefinition.setPriority(BigInteger.valueOf(editorData.getPriority()));
        WorkflowConfigurationType workflowConfiguration = taskDefinition.getWorkflowConfiguration();
        OutcomesType outcomesType = workflowConfiguration.getOutcomes();
        Collection outcomeString = OutComesDataUtil.customOutcomesToStrings((Collection)editorData.getOutComes());
        List outcome = outcomesType.getOutcome();
        outcome.clear();
        outcome.addAll(outcomeString);
        CompoundTextData titleTextData = editorData.getTaskTitle();
        if (titleTextData != null) {
            objectFactory = new oracle.bpel.services.workflow.metadata.taskdefinition.model.ObjectFactory();
            TranslatableValueType tvt = objectFactory.createTranslatableValueType();
            CompoundTextData.TYPE type = titleTextData.getType();
            if (CompoundTextData.TYPE.STATIC.equals((Object)type)) {
                tvt.setType(STATIC);
                tvt.setValue(titleTextData.getText());
            } else if (CompoundTextData.TYPE.XPATH.equals((Object)type)) {
                tvt.setType(XPATH);
                tvt.setValue(titleTextData.getText());
            } else if (CompoundTextData.TYPE.RESOURCE.equals((Object)type)) {
                tvt.setType("RESOURCE");
                tvt.setValue(titleTextData.getKey());
                Collection values = titleTextData.getValues();
                List param = tvt.getParam();
                param.clear();
                for (String s : values) {
                    param.add(s);
                }
            }
            taskDefinition.setTitle(tvt);
        }
        objectFactory = new ObjectFactory();
        IPayloadContainer payloadContainer = editorData.getPayloadContainer();
        PayloadIOHandler payloadIOHandler = new PayloadIOHandler(taskDefinition.getName());
        Collection list = payloadContainer.getPayloadData();
        payloadIOHandler.includePayloadData(taskDefinition, (ObjectFactory)objectFactory, list, payloadFile);
        switch (humanTaskType) {
            case COMPLEX: {
                HumanTaskUtils.includeComplexPattern(taskDefinition);
                break;
            }
            case FYI: {
                HumanTaskUtils.includeFYIPattern(taskDefinition);
                break;
            }
            case GROUP: {
                HumanTaskUtils.includeGroupPattern(taskDefinition);
                break;
            }
            case MANAGEMENT: {
                HumanTaskUtils.includeManagementPattern(taskDefinition);
                break;
            }
            case SIMPLE: {
                HumanTaskUtils.includeSimplePattern(taskDefinition);
                break;
            }
            case INITIATOR: {
                HumanTaskUtils.includeInitiatorPattern(workflowConfiguration, taskDefinition);
            }
        }
        HumanTaskUtils.includeApplicationRoleAndContext(taskDefinition, editorData.getOwnerData());
        TaskDefinitionUtil.getInstance().marshal((Object)taskDefinition, taskFile.getAbsolutePath());
    }

    private static void includeInitiatorPattern(WorkflowConfigurationType workflowConfiguration, TaskDefinition taskDefinition) {
        HumanTaskUtils.includeSimplePattern(taskDefinition);
        workflowConfiguration.setGlobalCreationTask(true);
    }

    private static File createFileFromUrl(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        return f;
    }

    private static void includeSimplePattern(TaskDefinition taskDefinition) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory objectFactory = new oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory();
        ParticipantsType.Participant participant = objectFactory.createParticipantsTypeParticipant();
        participant.setName(PARTICIPANT_NAME);
        list.add(participant);
        Resource resource = HumanTaskUtils.createBpmPermormerResource(objectFactory);
        participant.getResource().add(resource);
    }

    private static void includeManagementPattern(TaskDefinition taskDefinition) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory objectFactory = new oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory();
        ParticipantsType.SequentialParticipant sequentialParticipant = objectFactory.createParticipantsTypeSequentialParticipant();
        sequentialParticipant.setName(PARTICIPANT_NAME);
        ListType listType = objectFactory.createListType();
        ManagementChainListType managementChain = objectFactory.createManagementChainListType();
        Resource resource = HumanTaskUtils.createBpmPermormerResource(objectFactory);
        managementChain.getResource().add(resource);
        ParameterType levelType = objectFactory.createParameterType("3");
        levelType.setType(STATIC);
        managementChain.setLevels(levelType);
        listType.setManagementChain(managementChain);
        sequentialParticipant.setList(listType);
        list.add(sequentialParticipant);
    }

    private static Resource createBpmPermormerResource(oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory objectFactory) {
        Resource resource = objectFactory.createResource();
        resource.setType(XPATH);
        resource.setIdentityType("application_role");
        resource.setValue(BPM_PERFORMER);
        return resource;
    }

    private static void includeGroupPattern(TaskDefinition taskDefinition) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory objectFactory = new oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory();
        ParticipantsType.Parallel parallel = objectFactory.createParticipantsTypeParallel();
        parallel.setName(PARTICIPANT_NAME);
        parallel.setCollaboration(false);
        list.add(parallel);
        ParallelCompletionCriteriaType vote = objectFactory.createParallelCompletionCriteriaType();
        ParameterType defaultOutcome = objectFactory.createParameterType(APPROVE);
        defaultOutcome.setType(STATIC);
        vote.setDefaultOutcome(defaultOutcome);
        ParameterType percentageOfOutcome = objectFactory.createParameterType("50");
        percentageOfOutcome.setType(STATIC);
        vote.setPercentageOfOutcome(percentageOfOutcome);
        parallel.setVote(vote);
        Resource resource = HumanTaskUtils.createBpmPermormerResource(objectFactory);
        parallel.getResourceOrRoutingSlip().add(resource);
    }

    private static void includeApplicationRoleAndContext(TaskDefinition taskDefinition, OwnerData ownerData) {
        oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory objectFactory = new oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory();
        ResourceType taskOwner = objectFactory.createResourceType();
        taskOwner.setType(ownerData.isStatic() ? STATIC : XPATH);
        taskOwner.setIdentityType("application_role");
        taskOwner.setValue(ownerData.getExpression());
        GlobalConfigurationType globalConfiguration = objectFactory.createGlobalConfigurationType();
        globalConfiguration.setTaskOwner(taskOwner);
        globalConfiguration.setApplicationContext(APPLICATION_CONTEXT);
        taskDefinition.getRoutingSlip().setGlobalConfiguration(globalConfiguration);
    }

    private static void includeFYIPattern(TaskDefinition taskDefinition) {
        List list = HumanTaskUtils.getParticipantOrSequentialParticipantOrAdhoc(taskDefinition);
        oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory objectFactory = new oracle.bpel.services.workflow.metadata.routingslip.model.ObjectFactory();
        ParticipantsType.Fyi fyi = objectFactory.createParticipantsTypeFyi();
        fyi.setName(PARTICIPANT_NAME);
        list.add(fyi);
        Resource resource = HumanTaskUtils.createBpmPermormerResource(objectFactory);
        fyi.getResource().add(resource);
    }

    private static List getParticipantOrSequentialParticipantOrAdhoc(TaskDefinition taskDefinition) {
        ParticipantsType participantsType = taskDefinition.getRoutingSlip().getParticipants();
        ParticipantsType.Stage stage = (ParticipantsType.Stage)participantsType.getParticipantOrSequentialParticipantOrAdhoc().get(0);
        return stage.getParticipantOrSequentialParticipantOrAdhoc();
    }

    private static void includeComplexPattern(TaskDefinition taskDefinition) {
    }

    private static TaskDefinition loadTask(File taskFile) throws Exception {
        return (TaskDefinition)TaskDefinitionUtil.getInstance().unmarshal(taskFile.getAbsolutePath());
    }
}

