/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.net.URL;
import java.util.Collection;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.flowpanels.HumanTaskTypeCombo;
import oracle.bpm.designer.flowpanels.PriorityCombo;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.soa.humantask.ParametersPanel;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.workflow.editor.OutcomesComponent;
import oracle.tip.tools.ide.workflow.editor.data.CompoundTextData;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesDataUtil;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;
import oracle.tip.tools.ide.workflow.util.TaskDefinitionBuilder;

class HumanTaskGeneralPanel
extends Panel {
    private HumanTaskTypeCombo humanTaskTypeComboBox;
    private IdentifierTextField nameTextField;
    private OutcomesComponent outcomesComponent;
    private ParametersPanel parametersPanel;
    private PriorityCombo priorityComboBox;
    private TextField titleTextField;
    private UserTask userTask;
    private static final StringList INITIATOR_OUTCOMES = StringList.create("SUBMIT");

    HumanTaskGeneralPanel(UiContainer parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences, String defaultName) {
        super(parent);
        this.userTask = userTask;
        this.init(humanTaskPreferences, defaultName);
    }

    HumanTaskType getHumanTaskType() {
        return (HumanTaskType)this.humanTaskTypeComboBox.getSelectedItem();
    }

    boolean validateData() {
        return this.parametersPanel.validateData();
    }

    void applyToWizardData(WizardData data) {
        String taskName = this.getHumanTaskName();
        data.setProjectName(taskName);
        data.setWorkflowName(taskName);
        URL projectUrl = this.getProjectURL();
        data.setProjectDirectory(URLFileSystem.getParent((URL)projectUrl));
        data.setNamespace(this.getDefaultNamespace(taskName));
    }

    void applyToWFEditorData(WFEditorData data) {
        data.setOutComes(this.getOutcomes());
        data.setTaskTitle(this.getCompoundTextData());
        data.setPriority(this.getPriority());
        this.parametersPanel.applyToWFEditorData(data);
    }

    Sequence<Tuple<String, String>> createInputParameters() {
        return this.parametersPanel.createInputParameters();
    }

    Sequence<Tuple<String, String>> createOutputParameters() {
        return this.parametersPanel.createOutputParameters();
    }

    IdentifierTextField getNameTextField() {
        return this.nameTextField;
    }

    private String getHumanTaskName() {
        return this.nameTextField.getText().trim();
    }

    private Collection<OutComesData> getOutcomes() {
        return this.outcomesComponent.getOutcomes();
    }

    private CompoundTextData getCompoundTextData() {
        CompoundTextData textData = new CompoundTextData();
        textData.setType(CompoundTextData.TYPE.STATIC);
        textData.setText(this.getTitle());
        return textData;
    }

    private String getTitle() {
        return this.titleTextField.getText();
    }

    private void init(HumanTaskPreferences humanTaskPreferences, String defaultName) {
        this.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        this.nameTextField = new IdentifierTextField((UiContainer)this, defaultName, 30, true);
        HumanTaskType type = this.userTask.getHumanTaskType();
        HumanTaskType defaultHumanTaskType = type != null ? type : HumanTaskType.SIMPLE;
        this.humanTaskTypeComboBox = HumanTaskTypeCombo.create((UiContainer)this, (HumanTaskType)defaultHumanTaskType);
        this.humanTaskTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HumanTaskGeneralPanel.this.changeHumanTaskType((HumanTaskType)HumanTaskGeneralPanel.this.humanTaskTypeComboBox.getSelectedItem());
            }
        });
        this.priorityComboBox = new PriorityCombo((UiContainer)this);
        this.priorityComboBox.setSelectedItem((Object)humanTaskPreferences.getPriority());
        this.titleTextField = new TextField((UiContainer)this, 40);
        this.outcomesComponent = new OutcomesComponent();
        this.updateOutcomesComponent(defaultHumanTaskType);
        this.parametersPanel = new ParametersPanel((UiContainer)this, this.userTask);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
        this.add((UiComponent)this.nameTextField, "growx 70");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.VAR_PRIORITY_KEY));
        this.add((UiComponent)this.priorityComboBox, "growx 30, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PATTERN));
        this.add((UiComponent)this.humanTaskTypeComboBox, "spanx 3, growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TITLE));
        this.add((UiComponent)this.titleTextField, "spanx 3, growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.OUTCOMES));
        this.add(UiComponent.get((Object)this.outcomesComponent), "spanx 3, growx, wrap");
        this.add((UiComponent)this.parametersPanel, "spanx 4, grow");
    }

    private void changeHumanTaskType(HumanTaskType humanTaskType) {
        this.updateOutcomesComponent(humanTaskType);
    }

    private void updateOutcomesComponent(HumanTaskType humanTaskType) {
        Collection<OutComesData> outcomes = this.getDefaultOutcomes(humanTaskType);
        this.outcomesComponent.setData(outcomes);
        this.outcomesComponent.setPreActionOutcomes(outcomes);
    }

    private Collection<OutComesData> getDefaultOutcomes(HumanTaskType humanTaskType) {
        Collection<String> outcomes = humanTaskType.isInitiator() ? INITIATOR_OUTCOMES : TaskDefinitionBuilder.getDefaultOutcomes();
        return OutComesDataUtil.stringsToOutcomes((Collection)outcomes);
    }

    private int getPriority() {
        return (Integer)this.priorityComboBox.getSelectedItem();
    }

    private URL getProjectURL() {
        return this.getJDevProject().getURL();
    }

    private oracle.bpm.project.model.Project getProject() {
        return this.userTask.getProject();
    }

    private Project getJDevProject() {
        return ((Adaptable)this.getProject()).as(Project.class);
    }

    private String getDefaultNamespace(String workflowName) {
        URL url = URLFileSystem.getParent((URL)this.getJDevProject().getURL());
        URL parent = URLFileSystem.getParent((URL)url);
        String application = URLFileSystem.getName((URL)parent);
        String scaProject = URLFileSystem.getFileName((URL)url);
        String name = application + "/" + scaProject + "/" + workflowName;
        return TaskDefinitionBuilder.generateTargetNamespace((String)name);
    }
}

