/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.awt.Component;
import java.net.URL;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.HumanTaskData;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.fusion.soa.humantask.HumanTaskPanel;
import oracle.bpm.fusion.soa.humantask.HumanTaskUtils;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;
import oracle.tip.tools.ide.workflow.util.WorkflowResourceUtil;

class HumanTaskDialog
extends OkCancelDialog {
    private HumanTaskData humanTaskData;
    private HumanTaskPanel humanTaskPanel;
    private UserTask userTask;
    private static final String HUMANTASK = "Humantask";

    public HumanTaskDialog(UiWindow parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences) {
        super(parent, ProjectUiMsg.CREATE((Msg)ProjectModelMsg.HUMAN_TASK));
        this.userTask = userTask;
        this.init(humanTaskPreferences);
    }

    public void ok() {
        if (this.humanTaskPanel.validateData()) {
            final StatusGlassPane glass = new StatusGlassPane((Component)this.getContentPane().asSwing());
            glass.setVisibilityDelay(0);
            glass.enableUserInput(false);
            glass.setStatusMessage(WorkflowResourceUtil.getString((String)"PLEASE_WAIT") + "...", WorkflowResourceUtil.getString((String)"WF_CREATING_TASK"));
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        final Project jDevProject = HumanTaskDialog.this.getJDevProject();
                        final WizardData data = HumanTaskDialog.this.humanTaskPanel.getWizardData();
                        final WFEditorData editorData = HumanTaskDialog.this.humanTaskPanel.getWFEditorData();
                        final HumanTaskType humanTaskType = HumanTaskDialog.this.humanTaskPanel.getHumanTaskType();
                        final Any.Holder url = new Any.Holder();
                        VFileSystem dataFileSystem = HumanTaskDialog.this.getDataFileSystem();
                        final MutableComponentCatalog catalog = (MutableComponentCatalog)HumanTaskDialog.this.getProject().getComponentCatalog();
                        dataFileSystem.runWithEventsDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Transactable root = (Transactable)HumanTaskDialog.this.getProject().getCatalogRoot();
                                    try {
                                        root.beginTransaction();
                                        url.value = HumanTaskUtils.createHumanTask(jDevProject, data, editorData, humanTaskType);
                                    }
                                    finally {
                                        root.endTransaction();
                                    }
                                }
                                catch (Exception e) {
                                    MessageDialog.showError((Msg)FusionSoaMsg.ERROR_CREATING_HUMANTASK(data.getWorkflowName()), (Throwable)e);
                                }
                            }
                        });
                        if (url.value != null) {
                            dataFileSystem.runWithEventsDelayed(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        Transactable root = (Transactable)HumanTaskDialog.this.getProject().getCatalogRoot();
                                        try {
                                            root.beginTransaction();
                                            catalog.sync();
                                        }
                                        finally {
                                            root.endTransaction();
                                        }
                                    }
                                    catch (Exception e) {
                                        MessageDialog.showError((Msg)FusionSoaMsg.ERROR_CATALOGING_HUMANTASK(data.getWorkflowName()), (Throwable)e);
                                        HumanTaskDialog.this.closeDialog(false);
                                    }
                                }
                            });
                        }
                        if (url.value != null) {
                            Sequence<Tuple<String, String>> inputParameters = HumanTaskDialog.this.humanTaskPanel.createInputParameters();
                            Sequence<Tuple<String, String>> outputParameters = HumanTaskDialog.this.humanTaskPanel.createOutputParameters();
                            HumanTaskData humanTaskData = new HumanTaskData((URL)url.value, inputParameters, outputParameters);
                            HumanTaskDialog.this.setHumanTaskData(humanTaskData);
                            HumanTaskDialog.this.closeDialog(true);
                        }
                    }
                    finally {
                        glass.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        }
    }

    HumanTaskData getHumanTaskData() {
        return this.humanTaskData;
    }

    private VFileSystem getDataFileSystem() {
        return this.getProjectLoader().getProjectFileSystem().getDataFileSystem();
    }

    private ProjectLoader getProjectLoader() {
        return this.getProject().getLoader();
    }

    private void setHumanTaskData(HumanTaskData humanTaskData) {
        this.humanTaskData = humanTaskData;
    }

    private oracle.bpm.project.model.Project getProject() {
        return this.userTask.getProject();
    }

    private Project getJDevProject() {
        Project result = null;
        oracle.bpm.project.model.Project project = this.getProject();
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            result = adaptable.as(Project.class);
        }
        return result;
    }

    private void closeDialog(final boolean isOk) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HumanTaskDialog.this.setUserAccepted(isOk);
                HumanTaskDialog.this.close();
            }
        });
    }

    private void init(HumanTaskPreferences humanTaskPreferences) {
        UiContainer parent = this.getContentPane();
        this.humanTaskPanel = new HumanTaskPanel(parent, this.userTask, humanTaskPreferences, this.createUniqueName());
        parent.add((UiComponent)this.humanTaskPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private String createUniqueName() {
        DefaultNameGenerator nameGen = new DefaultNameGenerator(HUMANTASK, ".task", 1);
        URL projDir = URLFactory.newDirURL((String)this.getJDevProject().getBaseDirectory());
        String name = URLFileSystem.getFileName((URL)URLFactory.newUniqueURL((URL)projDir, (NameGenerator)nameGen));
        if (name.endsWith(".task")) {
            name = name.substring(0, name.length() - ".task".length());
        }
        return name;
    }
}

