/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.customization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.Sequence;
import oracle.bpm.fusion.soa.customization.CustomizableArgument;
import oracle.bpm.fusion.soa.customization.CustomizableBPMObjectData;
import oracle.bpm.fusion.soa.customization.CustomizableOperation;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.CatalogMemberImpl;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizedServiceUpdater {
    private CustomizableBPMObjectData customizedObjectData;
    private Map<String, CustomizableOperation> customizedOperations;
    private Set<CustomizableOperation> nonCustomizedOperations;
    private Project project;
    private InterfaceObject serviceObject;
    private final XObjectTypeDescription serviceOtd;

    private CustomizedServiceUpdater(@NotNull InterfaceObject serviceObject) {
        if (serviceObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.<init> must not be null");
        }
        this.serviceObject = serviceObject;
        this.serviceOtd = serviceObject.getDelegate().asBpmObject();
        this.project = serviceObject.getProject();
        this.initServiceData();
        this.initCustomizedOperations();
        this.initNotCustomizedOperations();
    }

    public static CustomizedServiceUpdater createCustomizedServiceUpdater(@NotNull InterfaceObject serviceObject) {
        if (serviceObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.createCustomizedServiceUpdater must not be null");
        }
        return new CustomizedServiceUpdater(serviceObject);
    }

    public CustomizableBPMObjectData getCustomizedObjectData() {
        return this.customizedObjectData;
    }

    public Collection<CustomizableOperation> getCustomizedOperations() {
        return this.customizedOperations.values();
    }

    public Collection<CustomizableOperation> getNonCustomizedOperations() {
        return this.nonCustomizedOperations;
    }

    public void updateServiceObjectData(@Nullable String description, CustomizableOperation ... operations) {
        if (operations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.updateServiceObjectData must not be null");
        }
        this.serviceOtd.setDescription(description);
        this.removeAllMethods(this.serviceOtd);
        TypeRef callbackRef = this.serviceOtd.findInnerType("Callback");
        XObjectTypeDescription callbackOtd = null;
        if (callbackRef != null) {
            callbackOtd = callbackRef.get().asBpmObject();
            this.removeAllMethods(callbackOtd);
        }
        for (CustomizableOperation operation : operations) {
            if (operation.isCallback()) {
                if (callbackOtd == null) continue;
                this.createDelegatedMethod(callbackOtd, operation, true);
                continue;
            }
            this.createDelegatedMethod(this.serviceOtd, operation, false);
        }
        ((ProjectObjectImpl)this.serviceObject).setErrors(Collections.emptyList());
        ((ResourceObject)this.serviceObject).setDirty(true);
    }

    private void initServiceData() {
        this.customizedObjectData = CustomizableBPMObjectData.loadExistingServiceObjectData(this.serviceObject);
    }

    private void initCustomizedOperations() {
        this.customizedOperations = new HashMap<String, CustomizableOperation>();
        this.addCustomizedOperations(this.serviceObject.getMethods(), false);
        InterfaceObject callbackService = this.getCallbackService(this.serviceObject);
        if (callbackService != null) {
            this.addCustomizedOperations(callbackService.getMethods(), true);
        }
    }

    private void addCustomizedOperations(Sequence<CatalogMember> methods, boolean callback) {
        for (CatalogMember catalogMember : methods) {
            if (catalogMember.getMemberType().isConstructor()) continue;
            boolean hasErrors = false;
            if (catalogMember instanceof CatalogMemberImpl) {
                hasErrors = ((CatalogMemberImpl)catalogMember).hasErrors();
            }
            if (hasErrors) continue;
            String description = catalogMember.getMemberType().getDescription();
            String name = catalogMember.getName();
            CustomizableOperation operation = CustomizableOperation.createOperation(catalogMember, name, description);
            operation.setCallback(callback);
            this.customizedOperations.put(operation.getDelegatedOperation().getQualifiedName(), operation);
        }
    }

    private void initNotCustomizedOperations() {
        this.nonCustomizedOperations = new HashSet<CustomizableOperation>();
        try {
            this.addNotCustomizedOperations(this.project.findCatalogObject(this.customizedObjectData.getService().getText()), false);
            TypeRef callbackServiceRef = this.customizedObjectData.getCallback();
            if (callbackServiceRef != null) {
                this.addNotCustomizedOperations(this.project.findCatalogObject(callbackServiceRef.getText()), true);
            }
        }
        catch (AmbiguousTypeNameException e) {
            Log.logSevere(e);
        }
    }

    private void addNotCustomizedOperations(@NotNull CatalogObject portTypeObject, boolean callback) {
        if (portTypeObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.addNotCustomizedOperations must not be null");
        }
        for (CatalogMember catalogMember : portTypeObject.getMethods()) {
            if (catalogMember.getMemberType().isConstructor()) continue;
            String name = catalogMember.getName();
            if (this.customizedOperations.containsKey(catalogMember.getMemberType().getQualifiedName())) continue;
            CustomizableOperation operation = CustomizableOperation.createOperation(catalogMember, name, null);
            operation.setCallback(callback);
            this.nonCustomizedOperations.add(operation);
        }
    }

    private InterfaceObject getCallbackService(@NotNull InterfaceObject service) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.getCallbackService must not be null");
        }
        for (InterfaceObject child : service.getChildrenByType(InterfaceObject.class)) {
            if (!child.isCallback()) continue;
            return child;
        }
        return null;
    }

    private void removeAllMethods(XObjectTypeDescription otd) {
        for (MethodTypeDescription mtd : otd.getMethods()) {
            if (mtd.isConstructor()) continue;
            otd.removeMember(mtd);
        }
    }

    private void createDelegatedMethod(@NotNull XObjectTypeDescription otd, @NotNull CustomizableOperation operation, boolean isCallback) {
        if (otd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.createDelegatedMethod must not be null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizedServiceUpdater.createDelegatedMethod must not be null");
        }
        MethodTypeDescription method = operation.getDelegatedOperation();
        String displayName = operation.getDisplayName();
        String description = operation.getDescription();
        TypeRef methodParentTypeRef = method.getParentRef();
        DelegatedMethodTypeDescription member = new DelegatedMethodTypeDescription(displayName, methodParentTypeRef, method.getSignature());
        member.setDescription(description);
        if (isCallback) {
            member.setProperty("is.callback", Boolean.TRUE.toString());
        }
        for (CustomizableArgument delegatedArgument : operation.getCustomizedArguments()) {
            TypeRef argumentTypeRef = delegatedArgument.getArgumentTypeRef();
            Argument newArgument = new Argument(delegatedArgument.getArgumentName(), argumentTypeRef.getRef(), delegatedArgument.getArgumentModifiers());
            newArgument.setDescription(delegatedArgument.getDescription());
            newArgument.setDefaultValue(delegatedArgument.getDefaultValue());
            newArgument.setProperty("nativeName", delegatedArgument.getNativeName());
            member.addArgument(newArgument);
        }
        otd.addMember((MethodTypeDescription)member);
    }
}

