/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.customization;

import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.ServiceUUID;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizableBPMObjectData {
    @Nullable
    private TypeRef callback;
    @Nullable
    private String description;
    @NotNull
    private String module;
    @NotNull
    private String name;
    @NotNull
    private TypeRef service;
    private boolean serviceObject;
    @NotNull
    private String target;
    @Nullable
    private String targetPort;

    private CustomizableBPMObjectData(@NotNull InterfaceObject catalogObject) {
        if (catalogObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.<init> must not be null");
        }
        ObjectTypeDescription otd = catalogObject.getDelegate().asObject();
        String module = otd.getParent().getText();
        String name = catalogObject.getName();
        String description = otd.getDescription();
        TypeRef callback = otd.findInnerType("Callback");
        ComponentCatalog catalog = otd.getCatalog();
        TypeRef delegatedService = this.findDelegatedService(otd, catalog);
        TypeRef delegatedCallback = null;
        if (callback != null) {
            delegatedCallback = this.findDelegatedService(callback.get().asObject(), catalog);
        }
        ServiceObject serviceObject = catalogObject.getDelegate().asServiceObject();
        String target = serviceObject.getTarget();
        String targetPort = serviceObject.getTargetPort();
        String interfaceObject = otd.getProperty("interface.object");
        this.init(module, name, description, delegatedService, delegatedCallback, target, targetPort, "service.object".equals(interfaceObject));
    }

    private CustomizableBPMObjectData(@NotNull String module, @NotNull String name, @Nullable String description, @NotNull CatalogObject catalogObject) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.<init> must not be null");
        }
        if (catalogObject == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.<init> must not be null");
        }
        ObjectTypeDescription otd = catalogObject.getDelegate().asObject();
        ServiceObject serviceObject = catalogObject.getDelegate().asServiceObject();
        TypeRef service = (TypeRef)otd.getTransientProperty("service.type.ref");
        TypeRef callback = (TypeRef)otd.getTransientProperty("callback.type.ref");
        String target = serviceObject.getTarget();
        String targetPort = serviceObject.getTargetPort();
        String interfaceObject = otd.getProperty("interface.object");
        this.init(module, name, description, service, callback, target, targetPort, "service.object".equals(interfaceObject));
    }

    public static CustomizableBPMObjectData createCustomizableBPMObjectData(@NotNull String module, @NotNull String name, @Nullable String description, @NotNull CatalogObject catalogObject) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.createCustomizableBPMObjectData must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.createCustomizableBPMObjectData must not be null");
        }
        if (catalogObject == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.createCustomizableBPMObjectData must not be null");
        }
        return new CustomizableBPMObjectData(module, name, description, catalogObject);
    }

    public static CustomizableBPMObjectData loadExistingServiceObjectData(@NotNull InterfaceObject catalogObject) {
        if (catalogObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.loadExistingServiceObjectData must not be null");
        }
        return new CustomizableBPMObjectData(catalogObject);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.getName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getModule() {
        String string = this.module;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.getModule must not return null");
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isServiceObject() {
        return this.serviceObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    TypeRef getService() {
        TypeRef typeRef = this.service;
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.getService must not return null");
        }
        return typeRef;
    }

    @Nullable
    TypeRef getCallback() {
        return this.callback;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    String getTarget() {
        String string = this.target;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.getTarget must not return null");
        }
        return string;
    }

    @Nullable
    String getTargetPort() {
        return this.targetPort;
    }

    private TypeRef findDelegatedService(ObjectTypeDescription otd, ComponentCatalog catalog) {
        String serviceId = otd.getProperty("service.object.id");
        ServiceUUID serviceUUID = UUIDFactory.parseServiceId((String)serviceId);
        String portTypeId = UUIDFactory.createPortTypeId((String)serviceUUID.getNamespace(), (String)serviceUUID.getNativeName()).getId();
        TypeRef result = catalog.findById(ComponentType.PORT_TYPE.getText(), portTypeId);
        if (result == null) {
            throw new IllegalStateException("Missing delegated service '" + serviceUUID.getQName() + "'");
        }
        return result;
    }

    private void init(@NotNull String module, @NotNull String name, @Nullable String description, @NotNull TypeRef service, @Nullable TypeRef callback, @NotNull String target, @Nullable String targetPort, boolean isServiceObject) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.init must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.init must not be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.init must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/fusion/soa/customization/CustomizableBPMObjectData.init must not be null");
        }
        this.name = name;
        this.module = module;
        this.description = description;
        this.service = service;
        this.callback = callback;
        this.target = target;
        this.targetPort = targetPort;
        this.serviceObject = isServiceObject;
    }
}

