/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.argumentmapping.transformation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.transformation.DataTransformationsTableModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.project.process.dataassociations.XSLTransformationImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.DropList;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.tip.tools.ide.tx.addin.MapperCreator;
import oracle.tip.tools.ide.tx.addin.MapperSource;
import oracle.tip.tools.ide.tx.addin.MapperTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataTransformationDialog
extends OkCancelDialog {
    private boolean createNewTransformation;
    private DataTransformation dataTransformation;
    private DataTransformationsTableModel model;
    private DropList<DataDeclaration> sourcesList;
    private ComboBox<DataDeclaration> targetComboBox;
    private ComboBox<XSLTransformation> tranformationComboBox;
    private TextField tranformationTextField;
    private static Predicate<DataDeclaration> VALID_DECLARATION_PREDICATE = new Predicate<DataDeclaration>(){

        @Override
        public boolean check(@Nullable DataDeclaration value) {
            return value != null && DataTransformationDialog.isValidDeclaration(value);
        }
    };

    public DataTransformationDialog(@NotNull UiWindow parent, @NotNull DataTransformationsTableModel model, DataTransformation dataTransformation) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.<init> must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.<init> must not be null");
        }
        super(parent);
        this.createNewTransformation = true;
        this.model = model;
        this.dataTransformation = dataTransformation;
        this.init();
    }

    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        if (this.createNewTransformation) {
            String name = this.tranformationTextField.getText();
            VFile newFile = this.getTransformationFile(name);
            URL fileURL = this.getFileURL(newFile);
            this.createNewXSLMap(this.sourcesList.getSelectedElements(), (DataDeclaration)this.targetComboBox.getSelectedItem(), fileURL);
            XSLTransformationImpl xslTransformation = new XSLTransformationImpl(this.getProject(), name, newFile);
            try {
                this.getProject().getResourceFilesContainer().getXSLTransformationsContainer().addChild((ProjectObject)xslTransformation);
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.isNew()) {
            DataTransformation transformation = this.createTransformation();
            this.model.addRow((Object)transformation);
        } else {
            this.updateTransformation(this.dataTransformation);
        }
        this.close();
    }

    private static boolean isValidDeclaration(@NotNull DataDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.isValidDeclaration must not be null");
        }
        SchemaObject schemaObject = declaration.getType().getDelegate().asSchemaObject();
        return DataTransformationDialog.isComplexElement(schemaObject);
    }

    private static boolean isComplexElement(@NotNull SchemaObject schemaObject) {
        if (schemaObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.isComplexElement must not be null");
        }
        return !schemaObject.isBasicType() && schemaObject.isElement();
    }

    private boolean isNew() {
        return this.dataTransformation == null;
    }

    private Msg validateInput() {
        if (this.sourcesList.getSelectedElements().isEmpty()) {
            return DesignerMsg.DATA_TRANSFORMATION_SOURCES_NOT_EMPTY;
        }
        for (DataDeclaration source : this.sourcesList.getSelectedElements()) {
            if (DataTransformationDialog.isValidDeclaration(source)) continue;
            return DesignerMsg.DATA_TRANSFORMATION_SOURCES_ELEMENT_SCHEMA;
        }
        DataDeclaration target = (DataDeclaration)this.targetComboBox.getSelectedItem();
        if (target == null) {
            return DesignerMsg.DATA_TRANSFORMATION_TARGET_NOT_NULL;
        }
        if (!DataTransformationDialog.isValidDeclaration(target)) {
            return DesignerMsg.DATA_TRANSFORMATION_TARGET_ELEMENT_SCHEMA;
        }
        for (DataTransformation modelTransformation : this.model.getData()) {
            if (!modelTransformation.getTargetRef().equals(target.getName()) || modelTransformation == this.dataTransformation) continue;
            return DesignerMsg.DATA_TRANSFORMATION_TARGET_ALREADY_USED;
        }
        if (this.createNewTransformation && Str.isEmpty(this.tranformationTextField.getText())) {
            return DesignerMsg.DATA_TRANSFORMATION_NAME_NOT_EMPTY;
        }
        return null;
    }

    private Project getProject() {
        return this.model.getProject();
    }

    private void updateTransformation(@NotNull DataTransformation transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.updateTransformation must not be null");
        }
        transformation.setSourceRefs(this.getSelectedSourceRefs());
        transformation.setTargetRef(this.getSelectedTargetRef());
        transformation.setTransformationName(this.getSelectedTransformationName());
    }

    private DataTransformation createTransformation() {
        return this.model.createTransformation(this.getSelectedSourceRefs(), this.getSelectedTargetRef(), this.getSelectedTransformationName());
    }

    private Sequence<String> getSelectedSourceRefs() {
        ArrayList<String> result = new ArrayList<String>();
        for (DataDeclaration source : this.sourcesList.getSelectedElements()) {
            result.add(source.getName());
        }
        return CollectionUtils.asSequence(result);
    }

    private String getSelectedTargetRef() {
        return this.targetComboBox.getSelectedItem() != null ? ((DataDeclaration)this.targetComboBox.getSelectedItem()).getName() : null;
    }

    private String getSelectedTransformationName() {
        return this.createNewTransformation ? this.tranformationTextField.getText() : ((XSLTransformation)this.tranformationComboBox.getSelectedItem()).getId();
    }

    private void init() {
        Panel editorPanel = this.createEditorPanel((UiContainer)this);
        this.getContentPane().add((UiComponent)editorPanel);
        this.setTitle(DesignerMsg.TRANSFORMATION.getString());
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private Panel createEditorPanel(UiContainer container) {
        Panel panel = Panel.createPanelWithBorder((UiContainer)container);
        MigLayout layout = new MigLayout("fill");
        panel.setLayout((Layout)layout);
        panel.add((UiComponent)this.createSourcesPanel((UiContainer)panel, this.model.getSourcesContainer(), this.dataTransformation), (Object)"grow, wrap");
        panel.add((UiComponent)this.createTargetPanel((UiContainer)panel, this.model.getTargetsContainer(), this.dataTransformation), (Object)"growx, wrap");
        panel.add((UiComponent)this.createTransformationPanel((UiContainer)panel, this.dataTransformation), (Object)"growx, wrap");
        return panel;
    }

    private Panel createSourcesPanel(@NotNull UiContainer container, @NotNull DataDeclarationContainer sourcesContainer, DataTransformation transformation) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createSourcesPanel must not be null");
        }
        if (sourcesContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createSourcesPanel must not be null");
        }
        Panel sourcesPanel = new Panel(container, DesignerMsg.SOURCES);
        sourcesPanel.setLayout((Layout)new MigLayout("fill"));
        DataDeclaration[] validSources = sourcesContainer.getDeclarations().select(VALID_DECLARATION_PREDICATE).toArray(new DataDeclaration[0]);
        this.sourcesList = new DropList((UiContainer)sourcesPanel, Arrays.asList(validSources), DesignerMsg.SOURCES, DesignerMsg.SELECTED_ELEMENTS);
        if (transformation != null) {
            ArrayList<DataDeclaration> selectedSources = new ArrayList<DataDeclaration>();
            for (String sourceName : transformation.getSourceRefs()) {
                DataDeclaration source = sourcesContainer.findDeclaration(sourceName);
                if (source == null) continue;
                selectedSources.add(source);
            }
            this.sourcesList.setSelectedElements(CollectionUtils.asSequence(selectedSources));
        }
        sourcesPanel.add(this.sourcesList, (Object)"grow");
        return sourcesPanel;
    }

    private Panel createTargetPanel(@NotNull UiContainer container, @NotNull DataDeclarationContainer targetsContainer, DataTransformation transformation) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createTargetPanel must not be null");
        }
        if (targetsContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createTargetPanel must not be null");
        }
        Label targetLabel = Label.create((UiContainer)container, (Msg)DesignerMsg.TARGET);
        Panel targetPanel = new Panel(container, DesignerMsg.TARGET);
        targetPanel.setLayout((Layout)new MigLayout("fill"));
        Object[] validTargets = targetsContainer.getDeclarations().select(VALID_DECLARATION_PREDICATE).toArray(new DataDeclaration[0]);
        this.targetComboBox = UiFactory.createComboBox((UiContainer)targetPanel, (Object[])validTargets);
        targetPanel.add((UiComponent)targetLabel);
        targetPanel.add(this.targetComboBox, (Object)"gapx 5, growx");
        if (transformation != null) {
            DataDeclaration target = targetsContainer.findDeclaration(transformation.getTargetRef());
            this.targetComboBox.setSelectedItem((Object)target);
        }
        return targetPanel;
    }

    private Panel createTransformationPanel(@NotNull UiContainer container, DataTransformation transformation) {
        XSLTransformation selectedTransformation;
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createTransformationPanel must not be null");
        }
        Panel transformationPanel = new Panel(container, DesignerMsg.TRANSFORMATION);
        transformationPanel.setLayout((Layout)new MigLayout("fill"));
        boolean createNewTransformation = transformation == null;
        ButtonGroup radioGroup = new ButtonGroup();
        final RadioButton createNewRadio = new RadioButton((UiContainer)transformationPanel, DesignerMsg.CREATE);
        createNewRadio.setSelected(createNewTransformation);
        this.tranformationTextField = new ValidFileTextField((UiContainer)transformationPanel, "", 0, 128, false);
        RadioButton useExistentRadio = new RadioButton((UiContainer)transformationPanel, DesignerMsg.USE_EXISTING);
        useExistentRadio.setSelected(!createNewTransformation);
        XSLTransformationsContainer xslTransformationsContainer = this.getProject().getResourceFilesContainer().getXSLTransformationsContainer();
        Sequence xslTransformationsSequence = xslTransformationsContainer.getChildrenByType(XSLTransformation.class);
        XSLTransformation[] xslTransformations = xslTransformationsSequence.toArray(new XSLTransformation[0]);
        this.tranformationComboBox = UiFactory.createComboBox((UiContainer)transformationPanel, Arrays.asList(xslTransformations));
        if (transformation != null && (selectedTransformation = (XSLTransformation)xslTransformationsContainer.findChild(XSLTransformation.class, transformation.getTransformationName())) != null) {
            this.tranformationComboBox.setSelectedItem((Object)selectedTransformation);
        }
        radioGroup.add((AbstractButton)createNewRadio);
        radioGroup.add((AbstractButton)useExistentRadio);
        createNewRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DataTransformationDialog.this.toogleCreateNewUseExistent(createNewRadio.isSelected());
            }
        });
        this.toogleCreateNewUseExistent(createNewTransformation);
        transformationPanel.add((UiComponent)createNewRadio);
        transformationPanel.add((UiComponent)this.tranformationTextField, (Object)"wrap, growx");
        transformationPanel.add((UiComponent)useExistentRadio);
        transformationPanel.add(this.tranformationComboBox, (Object)"wrap, growx");
        return transformationPanel;
    }

    private void toogleCreateNewUseExistent(boolean createNew) {
        this.tranformationTextField.setEnabled(createNew);
        this.tranformationComboBox.setEnabled(!createNew);
        this.createNewTransformation = createNew;
    }

    private void createNewXSLMap(@NotNull Sequence<DataDeclaration> sources, @NotNull DataDeclaration target, @NotNull URL fileURL) {
        if (sources == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createNewXSLMap must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createNewXSLMap must not be null");
        }
        if (fileURL == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.createNewXSLMap must not be null");
        }
        ArrayList<MapperSource> mapperSources = new ArrayList<MapperSource>();
        ArrayList<MapperTarget> mapperTargets = new ArrayList<MapperTarget>();
        for (DataDeclaration source : sources) {
            MapperElement mapperElement = this.getMapperElement(source.getType());
            if (mapperElement == null) continue;
            MapperSource mapperSource = new MapperSource(this.getMapperType(source), mapperElement.schemaURL, mapperElement.qName);
            QName paramQName = new QName(source.getName());
            mapperSource.setParam(paramQName);
            mapperSources.add(mapperSource);
        }
        MapperElement mapperElement = this.getMapperElement(target.getType());
        if (mapperElement != null) {
            MapperTarget mapperTarget = new MapperTarget(this.getMapperType(target), mapperElement.schemaURL, mapperElement.qName);
            mapperTargets.add(mapperTarget);
        }
        Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
        new MapperCreator(context).createMapper(fileURL, mapperSources, mapperTargets, true);
    }

    private VFile getTransformationFile(@NotNull String transformationName) {
        if (transformationName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.getTransformationFile must not be null");
        }
        VFileSystem fs = this.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        XSLTransformationsContainer container = this.getProject().getResourceFilesContainer().getXSLTransformationsContainer();
        VFile containerVFile = ((Adaptable)container).as(VFile.class);
        return fs.createFile(containerVFile, transformationName + ".xsl");
    }

    private MapperElement getMapperElement(@NotNull CatalogType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.getMapperElement must not be null");
        }
        MapperElement result = new MapperElement();
        SchemaObject schemaObject = type.getDelegate().asSchemaObject();
        if (DataTransformationDialog.isComplexElement(schemaObject)) {
            try {
                URL url = schemaObject.getResourceLocation() != null ? this.getFileURL(schemaObject.getResourceLocation()) : schemaObject.getResourceUri().toURL();
                result.schemaURL = url;
                result.qName = new QName(schemaObject.getNamespace(), schemaObject.getName());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private int getMapperType(@NotNull DataDeclaration element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.getMapperType must not be null");
        }
        return element.getType().getDelegate().asSchemaObject().isFromSchema() ? 1 : 2;
    }

    private URL getFileURL(@NotNull VFile file) {
        URL result;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/argumentmapping/transformation/DataTransformationDialog.getFileURL must not be null");
        }
        try {
            VFileSystem fs = file.getFileSystem();
            result = ((JavaFileSystem)fs).toJavaFile(file).toURI().toURL();
        }
        catch (MalformedURLException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private class MapperElement {
        public QName qName;
        public URL schemaURL;

        private MapperElement() {
        }
    }
}

