/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerContext;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class FusionSoaProjectRepository
extends FusionProjectRepository {
    public void setTechnologyScope(Project project) {
        TechnologyScope scope = new TechnologyScope();
        scope.setTechnologyKeys(new String[]{"SOA", "BPM"});
        ContentSet scaContentSet = ProjectContent.getInstance((PropertyStorage)project).getContentSet("oracle.tip.tools.ide.fabric.addin.SCAContentSetProvider/sca-content");
        scaContentSet.getURLPath().setEntries(null);
        scaContentSet.getPatternFilters().removeFilters();
        URLPath path = scaContentSet.getURLPath();
        try {
            URI uri = new File(project.getBaseDirectory()).toURI();
            path.add(uri.toURL());
        }
        catch (MalformedURLException e) {
            Log.logWarning(e);
        }
        TechnologyScopeConfiguration.getInstance((PropertyStorage)project).setTechnologyScope(scope);
    }

    protected void initJDevProject(@NotNull Project jdevProject, @NotNull ProjectFileSystem fileSystem) {
        if (jdevProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/FusionSoaProjectRepository.initJDevProject must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/FusionSoaProjectRepository.initJDevProject must not be null");
        }
        super.initJDevProject(jdevProject, fileSystem);
    }

    static class MySCAControllerContext
    extends SCAControllerContext {
        public MySCAControllerContext(Project project, SCAController scon) {
            super(project, scon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateCompositeName(String name) {
            try {
                XMLDocument compositeDoc = this.getCompositeDocument(true);
                Element compositeRoot = compositeDoc.getDocumentElement();
                compositeRoot.setAttribute("name", name);
                this.commitTransactions(null);
                try {
                    this.getScaComposite().getCompositeNode().save();
                }
                catch (IOException ioex) {
                    assert (Log.logDebug(ioex));
                }
            }
            finally {
                this.rollbackTransactions("");
            }
        }
    }
}

