/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.composite.util.FlowNodeFilter;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.ElementType;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.Direction;
import oracle.bpm.project.interfaces.ProcessOperationWrapper;
import oracle.bpm.project.interfaces.WsdlBuilder;
import oracle.bpm.project.interfaces.WsdlBuilderContext;
import oracle.bpm.project.interfaces.WsdlUtils;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.activities.EventTriggerTypeFeature;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessWsdlBuilder
extends WsdlBuilder<Process> {
    private WsdlBuilderContext builderContext = null;
    private static final String SCHEMAS_PARTNER_LINK_2003_05 = "http://schemas.xmlsoap.org/ws/2003/05/partner-link/";

    public ProcessWsdlBuilder(@NotNull Process process) {
        super(process);
        this.wsdlContext.addNamespace("plnk", SCHEMAS_PARTNER_LINK_2003_05);
        this.builderContext = WsdlBuilderContext.create();
    }

    @Override
    public String build() throws BuilderException {
        return this.buildServiceDefinition().getWsdl();
    }

    @Override
    protected void doBuild(@NotNull ServiceDefinition service) throws BuilderException {
        boolean hasSchemaImports;
        Process process = (Process)this.getModel();
        if (process.isCallableSubprocess()) {
            return;
        }
        this.generateWsdlElements(this.getAllInitiators(), Direction.REQUEST);
        this.generateWsdlElements(this.getAllContinuators(), Direction.RESPONSE);
        List<Import> wsdlImports = this.builderContext.getWsdlImports();
        if (!wsdlImports.isEmpty()) {
            for (Import anImport : wsdlImports) {
                anImport.setNSContext(service.getNSContext());
                service.addChild((Element)anImport);
            }
        }
        boolean hasDefinedElements = !this.builderContext.getDefinedElements().isEmpty();
        boolean bl = hasSchemaImports = !this.builderContext.getSchemaImports().isEmpty();
        if (hasDefinedElements || hasSchemaImports) {
            DefaultElement types = WsdlElementFactory.createTypes((NamespaceContext)service.getNSContext());
            service.addChild((Element)types);
            Schema schema = SchemaElementFactory.createSchema((String)this.getTargetNamespace());
            types.addChild((Element)schema);
            if (hasSchemaImports) {
                this.dumpImports(types, schema);
            }
            if (hasDefinedElements) {
                Collection<Element> definedElements = this.builderContext.getDefinedElements();
                for (Element definedElement : definedElements) {
                    schema.addChild(definedElement);
                }
            }
        }
        WsdlUtils.dumpElements(service, this.builderContext.getMessages());
        Collection<DefaultElement> portTypes = this.builderContext.getPortTypes();
        WsdlUtils.dumpElements(service, portTypes);
        for (DefaultElement portType : portTypes) {
            String portTypeName = portType.getAttribute(NAME_ATTR);
            if (portTypeName.endsWith("CallBack")) continue;
            this.buildParternLink(service, portTypeName);
        }
    }

    @Override
    protected String getTargetNamespace() {
        return ((Process)this.getModel()).getNamespace();
    }

    private Sequence<FlowNode> getAllNodes() {
        return ((Process)this.getModel()).getChildrenByType(FlowNode.class).select(PredicateUtils.or((Predicate)ModelUtils.ACTIVITY_FILTER, (Predicate)ModelUtils.EVENT_FILTER)).flatten(ModelUtils.SUB_PROCESS_TRAVERSAL);
    }

    private Sequence<ProcessOperationWrapper> getAllInitiators() {
        return this.getAllNodes().select(ModelUtils.INITIATOR_CONVERSATION_FILTER).map(FlowNodeFilter.NODE_OPERATION_MAPPER).select(FlowNodeFilter.SERVICE_FILTER);
    }

    private Sequence<ProcessOperationWrapper> getAllContinuators() {
        return this.getAllNodes().select(ModelUtils.CONTINUE_CONVERSATION_FILTER).map(FlowNodeFilter.NODE_OPERATION_MAPPER).select(FlowNodeFilter.SERVICE_FILTER);
    }

    private void buildParternLink(@NotNull ServiceDefinition service, @NotNull String portTypeName) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        attrs.put(NAME_ATTR, portTypeName + "PartnerLinkType");
        Element partnerLink = this.getWsdlElementFactory().create(SCHEMAS_PARTNER_LINK_2003_05, "partnerLinkType", attrs);
        this.addPartnerRole(partnerLink, portTypeName + "Provider", "tns:" + portTypeName);
        String callBackPortTypeName = this.builderContext.getCallBackPortTypeName(portTypeName);
        if (callBackPortTypeName != null) {
            this.addPartnerRole(partnerLink, callBackPortTypeName + "Requester", "tns:" + callBackPortTypeName);
        }
        service.addChild(partnerLink);
    }

    private void generateWsdlElements(@NotNull Sequence<ProcessOperationWrapper> operations, @NotNull Direction direction) throws BuilderException {
        for (ProcessOperationWrapper operationWrapper : operations) {
            this.generateWsdlElements(operationWrapper, direction);
        }
    }

    private void generateWsdlElements(@NotNull ProcessOperationWrapper operationWrapper, @NotNull Direction direction) throws BuilderException {
        int elementType;
        DefaultElement portTypeElement;
        if (operationWrapper.isReference() || !operationWrapper.isServiceDefiner()) {
            return;
        }
        String operationName = operationWrapper.getName();
        String modelId = ((Process)this.getModel()).getId();
        String portTypeName = this.buildPortTypeName(modelId);
        String directionSuffix = direction.getSuffix();
        String messageName = operationName + directionSuffix;
        if (operationWrapper.isInitiator()) {
            portTypeElement = this.buildPortType(portTypeName);
            elementType = 5;
        } else {
            ConversationEnabled conversationInitiator = operationWrapper.getConversationInitiator();
            if (conversationInitiator.getDefinedOperationName() == null) {
                return;
            }
            EventTriggerTypeFeature triggerTypeFeature = (EventTriggerTypeFeature)conversationInitiator.getFeature(EventTriggerTypeFeature.class);
            if (triggerTypeFeature != null && triggerTypeFeature.getValue() != EventTriggerType.MESSAGE) {
                return;
            }
            boolean isSync = conversationInitiator.isSync();
            if (isSync) {
                operationName = conversationInitiator.getDefinedOperationName();
                assert (operationName != null);
                portTypeElement = this.buildPortType(portTypeName);
                if (operationWrapper.hasErrors()) {
                    elementType = 3;
                    messageName = operationWrapper.getError().getName();
                } else {
                    elementType = 8;
                    messageName = operationName + directionSuffix;
                }
            } else {
                if (operationWrapper.hasErrors()) {
                    return;
                }
                operationName = operationWrapper.getName();
                messageName = operationName + directionSuffix;
                String portTypeCallBackName = portTypeName + "CallBack";
                this.builderContext.setHasCallBackPorType(portTypeName, portTypeCallBackName);
                portTypeElement = this.buildPortType(portTypeCallBackName);
                elementType = 5;
            }
        }
        Operation operation = this.buildOperation((Element)portTypeElement, operationName);
        String prefixedMessageName = ProcessWsdlBuilder.createTypeName("tns", messageName);
        if (elementType == 3) {
            this.buildFaultMessage(operationWrapper);
            this.createFault(operationWrapper, operation, prefixedMessageName);
        } else {
            DataAssociationSet associationSet = operationWrapper.getDataAssociationSet();
            this.buildMessage(operationName, messageName, associationSet);
            this.createOperationArgument(operation, prefixedMessageName, elementType);
        }
    }

    private void buildFaultMessage(@NotNull ProcessOperationWrapper operationWrapper) throws BuilderException {
        ErrorObject errorObject = operationWrapper.getError();
        String messageName = errorObject.getName();
        Message message = this.builderContext.getMessage(messageName);
        if (message == null) {
            Sequence attributes = errorObject.getAttributes();
            if (attributes.isEmpty() || attributes.toArray().length > 1) {
                throw new BuilderException((Msg)ProjectCatalogMsg.FAULT_INVALID_CONTENT((String)messageName));
            }
            CatalogMember member = (CatalogMember)attributes.iterator().next();
            if (!member.getName().equals("errorInfo")) {
                throw new BuilderException((Msg)ProjectCatalogMsg.FAULT_WITHOUT_ERRORINFO((String)messageName));
            }
            Map<QName, String> attr = WsdlUtils.createAttrMap(NAME_ATTR, messageName);
            message = (Message)this.createElement(6, attr);
            CatalogType type = member.getType();
            attr = WsdlUtils.createAttrMap(NAME_ATTR, "errorInfo");
            Element part = this.createMessagePart(attr, type.getDelegate().asSchemaObject());
            message.addChild(part);
            this.builderContext.addMessage(messageName, message);
        }
    }

    private void createOperationArgument(@NotNull Operation operation, @NotNull String prefixedMessageName, int argumentType) {
        Input input = operation.getInput();
        Output output = operation.getOutput();
        if (argumentType == 5 && input == null || argumentType == 8 && output == null) {
            Element argument = this.createOperationArgumentElement(prefixedMessageName, argumentType, null);
            operation.addChild(argument);
        }
    }

    private void createFault(@NotNull ProcessOperationWrapper operationWrapper, @NotNull Operation operation, @NotNull String prefixedMessageName) {
        List faultList = operation.getFaults();
        if (faultList.isEmpty()) {
            ErrorObject error = operationWrapper.getError();
            Element argument = this.createOperationArgumentElement(prefixedMessageName, 3, error.getName());
            operation.addChild(argument);
        }
    }

    private String buildPortTypeName(@NotNull String name) {
        return name + "PortType";
    }

    private Operation buildOperation(@NotNull Element portTypeElement, @NotNull String operationName) throws BuilderException {
        Map<String, Operation> operations = this.builderContext.getOperationFromPortType(portTypeElement);
        Operation operation = operations.get(operationName);
        if (operation == null) {
            operation = this.createOperation(operationName, null);
            portTypeElement.addChild((Element)operation);
            operations.put(operationName, operation);
        }
        return operation;
    }

    @NotNull
    private DefaultElement buildPortType(@NotNull String portTypeName) {
        DefaultElement portTypeElement = this.builderContext.getPortType(portTypeName);
        if (portTypeElement == null) {
            portTypeElement = this.createPortTypeElement(portTypeName);
            this.builderContext.addPortType(portTypeName, portTypeElement);
        }
        return portTypeElement;
    }

    private void buildMessage(@NotNull String operationName, @NotNull String messageName, @NotNull DataAssociationSet associationSet) {
        Message message = this.builderContext.getMessage(messageName);
        if (message == null) {
            message = this.createMessageElement(operationName, messageName, associationSet);
            this.builderContext.addMessage(messageName, message);
        }
    }

    private void addPartnerRole(Element partnerLink, String roleName, String portName) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        attrs.put(NAME_ATTR, roleName);
        Element partnerRole = this.getWsdlElementFactory().create(SCHEMAS_PARTNER_LINK_2003_05, "role", attrs);
        attrs = new HashMap();
        attrs.put(NAME_ATTR, portName);
        Element partnerPortType = this.getWsdlElementFactory().create(SCHEMAS_PARTNER_LINK_2003_05, "portType", attrs);
        partnerRole.addChild(partnerPortType);
        partnerLink.addChild(partnerRole);
    }

    private void dumpImports(@NotNull DefaultElement type, Schema schema) {
        List<oracle.bpm.project.catalog.parser.xsd.Import> elementList = this.builderContext.getSchemaImports();
        if (!elementList.isEmpty()) {
            for (oracle.bpm.project.catalog.parser.xsd.Import anImport : elementList) {
                anImport.setNSContext(new NamespaceContext(type.getNSContext()));
                schema.addChild((Element)anImport);
            }
        }
    }

    private DefaultElement createPortTypeElement(@NotNull String portTypeName) {
        Map<QName, String> attributes = WsdlUtils.createAttrMap(new QName("name"), portTypeName);
        return (DefaultElement)this.createElement(11, attributes);
    }

    private Message createMessageElement(@NotNull String operationName, @NotNull String name, @Nullable DataAssociationSet dataAssociationSet) {
        Map<QName, String> attributes = WsdlUtils.createAttrMap(NAME_ATTR, name);
        Message message = (Message)this.createElement(6, attributes);
        attributes = WsdlUtils.createAttrMap(NAME_ATTR, "parameters");
        attributes.put(ELEMENT_ATTR, ProcessWsdlBuilder.createTypeName("tns", name));
        Element part = this.createElement(9, attributes);
        message.addChild(part);
        if (dataAssociationSet != null) {
            Sequence dataDeclarationSequence = dataAssociationSet.getArguments();
            ElementDef element = SchemaElementFactory.createElement((String)name, (NamespaceContext)this.wsdlContext);
            ComplexType complexType = SchemaElementFactory.createComplexType((NamespaceContext)this.wsdlContext);
            oracle.bpm.project.catalog.parser.xsd.Sequence sequence = SchemaElementFactory.createSequence((NamespaceContext)this.wsdlContext);
            complexType.addChild((Element)sequence);
            element.addChild((Element)complexType);
            this.builderContext.addDefinedElement(name, (Element)element);
            for (DataDeclaration argument : dataDeclarationSequence) {
                CatalogType type = argument.getType();
                TypeDescription typeDescription = type.getDelegate();
                if (typeDescription.hasErrors()) {
                    Log.logWarning((Msg)ProjectCatalogMsg.TYPE_NOT_FOUND((String)type.getName(), (String)operationName));
                    continue;
                }
                SchemaObject schemaObject = typeDescription.asSchemaObject();
                String attributeValue = this.resolveType(schemaObject);
                ElementDef elementDef = schemaObject.isElement() ? SchemaElementFactory.createElementRef((String)attributeValue, (NamespaceContext)this.wsdlContext) : SchemaElementFactory.createElementWithType((String)argument.getName(), (String)attributeValue, (boolean)false, null);
                sequence.addChild((Element)elementDef);
            }
        }
        return message;
    }

    private Element createMessagePart(@NotNull Map<QName, String> attributesPart, @NotNull SchemaObject schemaObject) {
        String attributeValue = this.resolveType(schemaObject);
        if (schemaObject.isType()) {
            attributesPart.put(TYPE_ATTR, attributeValue);
        } else {
            attributesPart.put(new QName("element"), attributeValue);
        }
        return this.createElement(9, attributesPart);
    }

    private String resolveType(SchemaObject schemaObject) {
        String prefix;
        String schemaNamespace = schemaObject.getNamespace();
        Collection byUri = this.wsdlContext.findPrefixesByUri(schemaNamespace);
        if (byUri == null || byUri.isEmpty()) {
            prefix = "tns" + this.wsdlContext.getDeclaredPrefixCount();
            this.wsdlContext.addNamespace(prefix, schemaNamespace);
            if (schemaObject.isFromWsdl()) {
                this.builderContext.createWsdlImportFor(schemaObject);
            } else if (schemaObject.isFromSchema()) {
                this.builderContext.createchemalImportFor(schemaObject);
            }
        } else {
            prefix = (String)byUri.iterator().next();
        }
        return prefix + ":" + schemaObject.getName();
    }

    private Element createOperationArgumentElement(@NotNull String message, int argumentType, @Nullable String name) {
        QName qName = new QName(ElementType.findByType((int)6));
        Map<QName, String> attrs = WsdlUtils.createAttrMap(qName, message);
        if (name != null) {
            attrs.put(new QName("name"), name);
        }
        return this.createElement(argumentType, attrs);
    }
}

