/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.IntrospectionException;
import oracle.bpm.type.Introspector;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.xml.msg.XmlMsg;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlruntime.SoapFaultException;
import oracle.bpm.xmlruntime.XMLObject;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.Import;
import oracle.bpm.xmlschema.Include;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.SchemaParser;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.NamespaceModuleResolver;
import oracle.bpm.xmltype.XmlConstants;

@IntrospectorMetadata(type="xml")
public class XMLIntrospector
implements Introspector {
    private Map<String, TypeDescription> elements;
    private SchemaParser parser;
    public static final String XML_SCHEMA_STREAM = "xmlschema.stream";
    public static final String XML_SCHEMA = "xmlschema";
    public static final ObjectTypeDescription XMLOBJECT = XMLIntrospector.createNewOTD("XMLObject");
    public static final ObjectTypeDescription SOAPFAULT = XMLIntrospector.createNewExceptionOTD("SoapFaultException");

    public static ObjectTypeDescription create(String name, String namespace, boolean elementsAreQualified, boolean attributesAreQualified) {
        ObjectTypeDescription otd = XMLIntrospector.createNewOTD(name);
        return XMLIntrospector.load(otd, name, namespace, elementsAreQualified, attributesAreQualified);
    }

    public static void main(String[] args) throws Exception {
        XMLIntrospector xml = new XMLIntrospector();
        Map<String, Object> properties = xml.defaultProperties();
        properties.put(XML_SCHEMA, args[0]);
        ProgressMonitor monitor = new ProgressMonitor(){

            @Override
            public void error(Msg message) {
                System.err.println(message);
            }

            @Override
            public void info(Msg message) {
            }

            @Override
            public void info(int logLevel, Msg message) {
            }

            @Override
            public void phase(Msg message) {
            }

            @Override
            public void progress(int percent) {
            }

            @Override
            public void warning(Msg message) {
            }
        };
        MutableComponentCatalog catalog = TypeUtils.getDefaultCatalog(monitor);
        xml.introspect(properties, catalog, monitor);
    }

    public static String buildSignature(String name, String namespace, boolean elementsAreQualified, boolean attributesAreQualified) {
        return name + ';' + namespace + ';' + (elementsAreQualified ? "elementsQualified" : "N") + ";" + (attributesAreQualified ? "attributesQualified" : "N");
    }

    @Override
    public void setCustomProperties(Map<String, Object> properties, ObjectTypeDescription rootObject) {
        properties.put(XML_SCHEMA, rootObject.getProperty(XML_SCHEMA));
        properties.put("moduleName", rootObject.getName());
    }

    @Override
    public Map<String, Object> defaultProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(XML_SCHEMA, "");
        return properties;
    }

    @Override
    public void interrupt() {
        SchemaParser parser = this.parser;
        if (parser != null) {
            parser.interrupt();
        }
    }

    @Override
    public synchronized ObjectTypeDescription[] introspect(Map<String, Object> properties, ComponentCatalog catalog, ProgressMonitor monitor) throws IntrospectionException {
        boolean useNamespaceResolver;
        this.checkThread();
        monitor.progress(-1);
        InputStream xmlSchemaInputStream = (InputStream)properties.get(XML_SCHEMA_STREAM);
        String urlText = (String)properties.get(XML_SCHEMA);
        String moduleName = (String)properties.get("moduleName");
        File projectBaseDir = (File)properties.get("projectBaseDir");
        if (urlText == null || urlText.equals("")) {
            monitor.progress(-2);
            throw new IntrospectionException(XmlMsg.MISSING_PROPERTY_XMLSCHEMA);
        }
        ObjectTypeDescription root = new ObjectTypeDescription(moduleName);
        root.setComponentType(ComponentType.XML.getText());
        root.setProperty("invokeableClassName", XMLObject.class.getName());
        root.setModifiers(root.getModifiers() | 0x10000000L | 0x200L);
        ObjectTypeDescription parent = (ObjectTypeDescription)properties.get("parent_type_desc");
        root.setParent(parent);
        if (!urlText.startsWith("http:") && projectBaseDir != null) {
            String xmlFileName;
            String string = xmlFileName = urlText.startsWith("file:") ? urlText.substring("file:".length()) : urlText;
            if (xmlFileName.startsWith(projectBaseDir.getAbsolutePath())) {
                xmlFileName = "PROJECT_BASE_DIR" + xmlFileName.substring(projectBaseDir.getAbsolutePath().length());
            }
            root.setProperty(XML_SCHEMA, xmlFileName);
        } else {
            root.setProperty(XML_SCHEMA, urlText);
        }
        this.parser = new SchemaParser();
        this.parser.setMonitor(monitor);
        boolean bl = useNamespaceResolver = System.getProperty("useNamespaceResolver") != null;
        if (useNamespaceResolver) {
            this.parser.setModuleResolver(new NamespaceModuleResolver());
        }
        try {
            Schema[] schemas;
            monitor.phase(XmlMsg.INTROSPECTING);
            URL url = urlText.startsWith("http:") || urlText.startsWith("file:") ? new URL(urlText) : new File(urlText).toURL();
            if (xmlSchemaInputStream == null) {
                this.parser.compile(url);
            } else {
                this.parser.compile(url, xmlSchemaInputStream);
            }
            HashMap<String, String> elementMap = new HashMap<String, String>();
            this.elements = new HashMap<String, TypeDescription>();
            for (Schema schema : schemas = this.parser.getParsedSchemas()) {
                ExtendedNamespace nspace = schema.getContext().getTarget();
                if (!XmlUtils.isSFS(nspace.getUri())) {
                    ExtendedNamespace enspace = nspace;
                    Map<String, TypeDescription> definedTypes = enspace.getDefinedTypes();
                    for (Map.Entry<String, TypeDescription> entry : definedTypes.entrySet()) {
                        ObjectTypeDescription typeDescription;
                        TypeRef ref;
                        TypeDescription type = entry.getValue();
                        if (!type.isObject() && !type.isEnum() || (ref = root.findInnerType((typeDescription = (ObjectTypeDescription)type).getName())) == typeDescription) continue;
                        if (ref != null) {
                            String name = null;
                            int j = 2;
                            while (ref != null) {
                                name = typeDescription.getName() + j;
                                ref = root.findInnerType(name);
                                ++j;
                            }
                            typeDescription.setName(name);
                        }
                        monitor.info(XmlMsg.ADDING(typeDescription.getText()));
                        if (typeDescription.getParent() != null) continue;
                        ObjectTypeDescription module = this.parser.getModuleResolver().resolveModule(null, root, typeDescription);
                        module.addInnerType(typeDescription);
                    }
                    try {
                        Set<String> declaredElements = enspace.getDeclaredElementNames();
                        for (String declaredElement : declaredElements) {
                            ElementDef elementDef = enspace.lookupElement(declaredElement);
                            TypeDescription contentType = elementDef.getContentType();
                            String qName = nspace.getUri() + ":" + elementDef.getAttribute("name");
                            if (contentType != null) {
                                elementMap.put(qName, contentType.getName());
                            }
                            AttributeTypeDescription attr = elementDef.getTypeDescription().asAttribute();
                            this.elements.put(declaredElement, attr.getType());
                        }
                    }
                    catch (TypeException e) {
                        throw new IntrospectionException(XmlMsg.INTROSPECTIONEXCEPTION(e.getMessage()), (Throwable)e);
                    }
                }
                String targetNamespace = schema.getTargetNamespace();
                this.fixSchemaLocation(schema, root.getText());
                String key = XmlConstants.buildSchemaKey(targetNamespace, schema.getSchemaLocationKey());
                root.setProperty(key, schema.getXsdContent());
            }
            root.setProperty("elementsMapping", ((Object)elementMap).toString());
            ObjectTypeDescription[] objects = new ObjectTypeDescription[]{root};
            ObjectTypeDescription[] objectTypeDescriptionArray = objects;
            return objectTypeDescriptionArray;
        }
        catch (MalformedURLException e) {
            Msg message = XmlMsg.MALFORMED_URL(urlText);
            throw new IntrospectionException(message, (Throwable)e);
        }
        catch (ParserException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new IntrospectionException(XmlMsg.UNKNOWN_HOST(e.getCause().getMessage()));
            }
            throw new IntrospectionException(XmlMsg.PARSEREXCEPTION(e.getMessage()));
        }
        catch (TypeException e) {
            Msg message = XmlMsg.INTROSPECTIONEXCEPTION(e.getMessage());
            throw new IntrospectionException(message, (Throwable)e);
        }
        catch (IOException e) {
            Msg message = XmlMsg.INTROSPECTIONEXCEPTION(e.getMessage());
            throw new IntrospectionException(message, (Throwable)e);
        }
        finally {
            monitor.progress(-2);
        }
    }

    @Override
    public boolean supportsReIntrospection() {
        return true;
    }

    public Map<String, TypeDescription> getElements() {
        return this.elements;
    }

    static ObjectTypeDescription createNewOTD(String name) {
        ObjectTypeDescription otd = new ObjectTypeDescription(Identifier.classname(name));
        otd.setNativeName(name);
        otd.setModifiers(otd.getModifiers() | 0x10000000L);
        otd.setLocalEnabled(true);
        otd.setComponentType(ComponentType.XML.getText());
        otd.setProperty("invokeableClassName", XMLObject.class.getName());
        return otd;
    }

    static ObjectTypeDescription load(ObjectTypeDescription objType, String name, String namespace, boolean elementsAreQualified, boolean attributesAreQualified) {
        String signature = XMLIntrospector.buildSignature(name, namespace, elementsAreQualified, attributesAreQualified);
        name = Identifier.classname(name);
        objType.setSignature(signature);
        MethodTypeDescription defConstructor = new MethodTypeDescription(name);
        defConstructor.setResultType(objType);
        defConstructor.setSignature('D' + signature);
        defConstructor.setModifiers(32832L);
        MethodTypeDescription mapConstructor = new MethodTypeDescription(name);
        mapConstructor.setResultType(objType);
        mapConstructor.setSignature('F' + signature);
        mapConstructor.setModifiers(32832L);
        mapConstructor.addArgument(new Argument("name", TypeFactory.getString(), 1L));
        mapConstructor.addArgument(new Argument("attributes", TypeFactory.getMap(TypeFactory.getString(), TypeFactory.getString()), 1L));
        MethodTypeDescription xmlConstructor = new MethodTypeDescription(name);
        xmlConstructor.setResultType(objType);
        xmlConstructor.setSignature('X' + signature);
        xmlConstructor.addArgument(new Argument("xmlText", TypeFactory.getString(), 1L));
        xmlConstructor.setModifiers(32832L);
        objType.addMember(defConstructor);
        objType.addMember(mapConstructor);
        objType.addMember(xmlConstructor);
        if (name.equals("XMLObject")) {
            objType.setSuperTypes(SuperType.getAnySuperTypeList());
            XMLIntrospector.loadMemberForBaseType(objType);
            objType.setProperty("xmlObjectVersion", "2.0");
        } else {
            SuperType sclass = new SuperType(XMLOBJECT, 32768L);
            objType.setSuperTypes(new SuperType[]{sclass});
        }
        return objType;
    }

    static ObjectTypeDescription createNewExceptionOTD(String name) {
        ObjectTypeDescription otd = new ObjectTypeDescription(Identifier.classname(name));
        otd.setNativeName(name);
        otd.setModifiers(otd.getModifiers() | 0x10000000L | 0x40000L);
        otd.setLocalEnabled(true);
        otd.setComponentType(ComponentType.XML.getText());
        otd.setProperty("invokeableClassName", SoapFaultException.class.getName());
        return otd;
    }

    static ObjectTypeDescription loadSoapFault(ObjectTypeDescription objType, String name, String namespace, boolean elementsAreQualified, boolean attributesAreQualified) {
        SuperType sclass = new SuperType(XMLOBJECT, 32768L);
        objType.setSuperTypes(new SuperType[]{sclass});
        String signature = XMLIntrospector.buildSignature(name, namespace, elementsAreQualified, attributesAreQualified);
        name = Identifier.classname(name);
        objType.setSignature(signature);
        MethodTypeDescription simpleConstructor = new MethodTypeDescription(name);
        simpleConstructor.setResultType(objType);
        simpleConstructor.setSignature('T' + signature);
        simpleConstructor.setModifiers(32832L);
        simpleConstructor.addArgument(new Argument("faultCode", TypeFactory.getString(), 1L));
        simpleConstructor.addArgument(new Argument("faultString", TypeFactory.getString(), 1L));
        simpleConstructor.addArgument(new Argument("detailString", TypeFactory.getString(), 1L));
        objType.addMember(simpleConstructor);
        MethodTypeDescription xmlObjectConstructor = new MethodTypeDescription(name);
        xmlObjectConstructor.setResultType(objType);
        xmlObjectConstructor.setSignature('O' + signature);
        xmlObjectConstructor.setModifiers(32832L);
        xmlObjectConstructor.addArgument(new Argument("faultCode", TypeFactory.getString(), 1L));
        xmlObjectConstructor.addArgument(new Argument("faultString", TypeFactory.getString(), 1L));
        xmlObjectConstructor.addArgument(new Argument("xmlObjectDetail", XMLOBJECT, 1L));
        objType.addMember(xmlObjectConstructor);
        AttributeTypeDescription attribute = new AttributeTypeDescription("faultCode", TypeFactory.getString());
        attribute.setReadSignature(String.valueOf('8'));
        attribute.setWriteSignature(String.valueOf('8'));
        objType.addMember(attribute);
        attribute = new AttributeTypeDescription("faultString", TypeFactory.getString());
        attribute.setReadSignature(String.valueOf('9'));
        attribute.setWriteSignature(String.valueOf('9'));
        objType.addMember(attribute);
        return objType;
    }

    private static void createXPathMethods(ObjectTypeDescription objType) {
        MethodTypeDescription method = new MethodTypeDescription("select");
        method.setSignature(String.valueOf("SSN"));
        method.addArgument(new Argument("xpath", TypeFactory.getString(), 1L));
        method.setResultType(TypeFactory.getAny());
        objType.addMember(method);
        method = new MethodTypeDescription("querySelect");
        method.setSignature(String.valueOf("SQN"));
        method.setVisible(false);
        method.addArgument(new Argument("xpath", TypeFactory.getString(), 1L));
        method.setResultType(TypeFactory.getAny());
        objType.addMember(method);
        method = new MethodTypeDescription("selectNodes");
        method.setSignature(String.valueOf("SN"));
        method.addArgument(new Argument("xpath", TypeFactory.getString(), 1L));
        method.setResultType(TypeFactory.getArray(TypeFactory.getAny()));
        objType.addMember(method);
        method = new MethodTypeDescription("selectString");
        method.setSignature(String.valueOf("ST"));
        method.addArgument(new Argument("xpath", TypeFactory.getString(), 1L));
        method.setResultType(TypeFactory.getString());
        objType.addMember(method);
        method = new MethodTypeDescription("selectBoolean");
        method.setSignature(String.valueOf("SB"));
        method.addArgument(new Argument("xpath", TypeFactory.getString(), 1L));
        method.setResultType(TypeFactory.getString());
        objType.addMember(method);
        method = new MethodTypeDescription("selectNumber");
        method.setSignature(String.valueOf("SD"));
        method.addArgument(new Argument("xpath", TypeFactory.getString(), 1L));
        method.setResultType(TypeFactory.getDecimal());
        objType.addMember(method);
    }

    private static void loadMemberForBaseType(ObjectTypeDescription objType) {
        ArrayTypeDescription children = TypeFactory.getArray(XMLOBJECT);
        AttributeTypeDescription attribute = new AttributeTypeDescription("attributes", TypeFactory.getMap(TypeFactory.getString(), TypeFactory.getString()));
        attribute.setReadSignature(String.valueOf('M'));
        attribute.setWriteSignature(String.valueOf('M'));
        objType.addMember(attribute);
        attribute = new AttributeTypeDescription("children", children);
        attribute.setReadSignature(String.valueOf('S'));
        attribute.setWriteSignature(String.valueOf('S'));
        objType.addMember(attribute);
        attribute = new AttributeTypeDescription("tagName", TypeFactory.getString());
        attribute.setReadSignature(String.valueOf('T'));
        attribute.setWriteSignature(String.valueOf('T'));
        objType.addMember(attribute);
        attribute = new AttributeTypeDescription("namespace", TypeFactory.getString(), 32780L);
        attribute.setReadSignature(String.valueOf('B'));
        attribute.setWriteSignature(String.valueOf('B'));
        objType.addMember(attribute);
        attribute = new AttributeTypeDescription("isNil", TypeFactory.getBool(), 32780L);
        attribute.setReadSignature(String.valueOf('U'));
        attribute.setWriteSignature(String.valueOf('U'));
        objType.addMember(attribute);
        attribute = new AttributeTypeDescription("elementNamespace", TypeFactory.getString(), 33587212L);
        attribute.setReadSignature(String.valueOf('B'));
        attribute.setWriteSignature(String.valueOf('B'));
        objType.addMember(attribute);
        MethodTypeDescription method = new MethodTypeDescription("generateXmlFor");
        method.setSignature(String.valueOf('G'));
        method.setResultType(TypeFactory.getString());
        objType.addMember(method);
        method = new MethodTypeDescription("loadFromUrl");
        method.setSignature(String.valueOf("LU"));
        method.addArgument(new Argument("url", TypeFactory.getString(), 1L));
        method.setModifiers(32768L);
        objType.addMember(method);
        method = new MethodTypeDescription("load");
        method.setSignature(String.valueOf("LX"));
        method.addArgument(new Argument("xmlText", TypeFactory.getString(), 1L));
        method.setModifiers(32768L);
        objType.addMember(method);
        MethodTypeDescription store = new MethodTypeDescription("store");
        store.setSignature(String.valueOf("SS"));
        store.addArgument(new Argument("targetFile", TypeFactory.getString(), 1L));
        MethodTypeDescription storeEnc = new MethodTypeDescription("store");
        storeEnc.setSignature(String.valueOf("SE"));
        storeEnc.addArgument(new Argument("targetFile", TypeFactory.getString(), 1L));
        storeEnc.addArgument(new Argument("encoding", TypeFactory.getString(), 1L));
        store = MethodTypeDescription.appendMethod(store, storeEnc);
        objType.addMember(store);
        MethodTypeDescription validate = new MethodTypeDescription("validate");
        validate.setSignature(String.valueOf("V"));
        objType.addMember(validate);
        MethodTypeDescription getValue = new MethodTypeDescription("value");
        getValue.addArgument(new Argument("kind", TypeFactory.getInt(), 1L));
        getValue.setResultType(TypeFactory.getRootObject());
        getValue.setModifiers(0x2002000L);
        getValue.setSignature(String.valueOf("E"));
        objType.addMember(getValue);
        MethodTypeDescription validateNonTyped = new MethodTypeDescription("validate");
        validateNonTyped.addArgument(new Argument("fuegoTypeName", TypeFactory.getString(), 1L));
        validateNonTyped.setSignature(String.valueOf("VV"));
        validateNonTyped.setModifiers(0x2002000L);
        objType.addMember(validateNonTyped);
        XMLIntrospector.createXPathMethods(objType);
    }

    private void fixSchemaLocation(Schema schema, String fullModuleName) throws MalformedURLException {
        Import[] imports;
        Include[] includes;
        for (Include include : includes = schema.getIncludes()) {
            String includeLocation = include.getSchemaLocation();
            Schema schemaIncluded = this.getSchemaFromLocation(schema, includeLocation);
            String locationKey = schemaIncluded.getSchemaLocationKey();
            include.setSchemaLocation("albpmModule_" + fullModuleName + "#" + locationKey);
        }
        for (Import anImport : imports = schema.getImports()) {
            if (anImport.isInline()) continue;
            String importLocation = anImport.getSchemaLocation();
            Schema schemaImported = this.getSchemaFromLocation(schema, importLocation);
            String locationKey = schemaImported.getSchemaLocationKey();
            anImport.setSchemaLocation("albpmModule_" + fullModuleName + "#" + locationKey);
        }
    }

    private Schema getSchemaFromLocation(Schema parentSchema, String includeLocation) throws MalformedURLException {
        URL schemaLocation = parentSchema.getLocation();
        URL urlLocation = new URL(schemaLocation, includeLocation);
        return this.parser.getParsedFiles().get(urlLocation);
    }

    private void checkThread() {
        boolean condition;
        String threadName = Thread.currentThread().getClass().getName();
        boolean bl = condition = threadName.indexOf(".awt.") == -1 && threadName.indexOf(".swing.") == -1;
        assert (condition) : "Attempt to run time-consuming operation from AWT dispatcher";
    }

    static {
        XMLIntrospector.load(XMLOBJECT, "XMLObject", "", false, false);
        XMLIntrospector.loadSoapFault(SOAPFAULT, "SoapFaultException", null, false, false);
    }
}

