/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltype;

import java.io.File;
import java.net.MalformedURLException;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.IdentifierModuleTextField;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.FileFilter;
import oracle.bpm.util.Identifier;
import oracle.bpm.xml.msg.XmlMsg;

class URLStepPanel
extends WizardStepPanel {
    Button browseButton;
    IdentifierTextField moduleTextField;
    TextField urlTextField;

    public URLStepPanel(UiContainer parent, WizardStep wizardStep) {
        super(parent, wizardStep);
    }

    public String getModule() {
        return this.moduleTextField.getText();
    }

    public String getURL() {
        return this.urlTextField.getText();
    }

    public UiComponent createCenterPage(UiContainer parent) {
        String schema;
        this.setPageTitle(XmlMsg.XML_PROPERTIES);
        this.setPageDesc(XmlMsg.XML_PROPERTIES_DESCR);
        BorderPanel centerPanel = new BorderPanel(parent);
        centerPanel.setLayout((Layout)new GridBagLayout());
        this.urlTextField = new TextField((UiContainer)centerPanel);
        Wizard wizard = this.getWizardStep().getWizard();
        String fileToIntrospect = (String)wizard.getProperty("File_To_Introspect");
        String module = (String)wizard.getProperty("moduleName");
        boolean reintrospect = wizard.getProperty("reintrospecting") != null;
        File projectBaseDir = (File)wizard.getProperty("projectBaseDir");
        String string = schema = fileToIntrospect != null ? fileToIntrospect : (String)wizard.getProperty("xmlschema");
        if (!schema.startsWith("http:") && projectBaseDir != null && schema.startsWith("PROJECT_BASE_DIR")) {
            schema = projectBaseDir.getAbsolutePath() + schema.substring("PROJECT_BASE_DIR".length());
        }
        this.urlTextField.setText(schema);
        this.urlTextField.addDocumentListener((DocumentListener)new DocumentListener.Default(){

            public void anyUpdate(DocumentEvent e) {
                URLStepPanel.this.urlUpdated();
            }
        });
        this.browseButton = new Button((UiContainer)centerPanel);
        this.browseButton.setText("...");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLStepPanel.this.chooseFile();
            }
        });
        this.moduleTextField = new IdentifierModuleTextField((UiContainer)centerPanel);
        if (module != null) {
            this.moduleTextField.setText(module);
            this.moduleTextField.setEnabled(!reintrospect);
        } else {
            this.moduleTextField.setText("Unnamed");
        }
        Label label = Label.create((UiContainer)centerPanel, (Msg)LibMsg.TYPE_MODULE);
        LabelMultiline msgTextArea = URLStepPanel.createTextArea((UiContainer)centerPanel, (Msg)XmlMsg.URL_STEP_MSG);
        centerPanel.add((UiComponent)msgTextArea, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add(Box.createVerticalStrut((UiContainer)centerPanel, (int)20), (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add((UiComponent)Label.create((UiContainer)centerPanel, (Msg)XmlMsg.URL_STEP_WSDL_URL), (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        centerPanel.add((UiComponent)this.urlTextField, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 1), 0, 0));
        centerPanel.add((UiComponent)this.browseButton, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 1, 5, 5), 0, 0));
        centerPanel.add((UiComponent)label, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 1), 0, 0));
        centerPanel.add((UiComponent)this.moduleTextField, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 1), 0, 0));
        return centerPanel;
    }

    public boolean validateInput() {
        String url = this.urlTextField.getText().trim();
        String moduleName = this.moduleTextField.getText().trim();
        if ("".equals(url)) {
            MessageDialog.showError((Msg)XmlMsg.URL_STEP_EMTPY_ADDRESS);
            return false;
        }
        if ("".equals(moduleName)) {
            MessageDialog.showError((Msg)XmlMsg.EMPTY_MODULE);
            return false;
        }
        return true;
    }

    public Dimension getMinimumSize() {
        return Dimension.valueOf(350, 200);
    }

    private void chooseFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setFileFilter(FileFilter.create(UIMsg.XSD_FILES, "xsd"));
        int returnVal = fileChooser.showOpenDialog((UiComponent)Ui.getRoot());
        if (returnVal != 0) {
            return;
        }
        String fileChosen = null;
        try {
            fileChosen = fileChooser.getSelectedFile().toURL().toString();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.urlTextField.setText(fileChosen);
    }

    private void urlUpdated() {
        if ("Unnamed".equals(this.moduleTextField.getText())) {
            String text = this.urlTextField.getText();
            if ((text = Identifier.classnameFromUrl(text)) != null && text.length() > 0) {
                this.moduleTextField.setText(text);
            }
        }
    }
}

