/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmltype;

import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.bpm.xmlruntime.XmlUtils;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.ModuleResolver;

public class NamespaceModuleResolver
implements ModuleResolver {
    @Override
    public ObjectTypeDescription resolveModule(ObjectTypeDescription introspectionRootModule, ObjectTypeDescription wsdlRootModule, ObjectTypeDescription type) {
        ObjectTypeDescription module;
        String namespace = type.getProperty("namespace");
        if (namespace != null) {
            String moduleName = XmlUtils.getPackageFromNamespace(namespace, true);
            if (type.getParent() != null) {
                module = (ObjectTypeDescription)type.getParent();
            } else {
                TypeRef innerType = this.getRootModule(introspectionRootModule, wsdlRootModule).findInnerType(moduleName);
                if (innerType != null) {
                    module = (ObjectTypeDescription)innerType.get();
                } else {
                    module = new ObjectTypeDescription(moduleName);
                    module.setProperty("definitionModule", wsdlRootModule.getName());
                    type.setParent(module);
                    this.getRootModule(introspectionRootModule, wsdlRootModule).addInnerType(module);
                }
            }
        } else {
            module = wsdlRootModule;
        }
        return module;
    }

    @Override
    public TypeDescription resolveType(SchemaElement element, Context context) throws TypeException {
        TypeDescription type = null;
        try {
            String namespace = element.getTarget().getUri();
            String elementName = element.getAttribute("name");
            if (elementName == null) {
                elementName = Identifier.classname(((ElementDef)element.getParent()).getName());
            }
            ExtendedNamespace extendedNamespace = (ExtendedNamespace)context.findNamespaceByUri(namespace);
            type = extendedNamespace.getDefinedTypes().get(elementName);
        }
        catch (Exception exc) {
            // empty catch block
        }
        return type;
    }

    private ObjectTypeDescription getRootModule(ObjectTypeDescription introspectionRootModule, ObjectTypeDescription rootModule) {
        return introspectionRootModule != null ? introspectionRootModule : rootModule;
    }
}

