/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.Text;
import oracle.bpm.xmlruntime.XMLSignature;
import oracle.bpm.xmlschema.Annotation;
import oracle.bpm.xmlschema.AttrGroupTypeDescription;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.InvalidSchemaElement;
import oracle.bpm.xmlschema.SFSNamespace;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.SchemaParser;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.ModuleResolver;

public class SchemaElement
extends DefaultElement
implements XMLSignature {
    protected String javaType;
    protected TypeDescription type;
    private Annotation annotation;
    private boolean topLevel;

    SchemaElement() {
    }

    SchemaElement(SchemaElement element) {
        this.setNamespace(element.getNamespace());
        this.setNSContext(element.getNSContext());
    }

    public static String buildSignature(TypeDescription type) {
        String signature;
        switch (type.getKind()) {
            case 10: {
                signature = String.valueOf('A');
                break;
            }
            case 12: {
                String namespace;
                ArrayTypeDescription arrayType = (ArrayTypeDescription)type;
                boolean isSoap = Boolean.TRUE.toString().equals(arrayType.getProperty("soapArray"));
                TypeDescription elementType = type.getElementType();
                signature = (isSoap ? (char)'{' : '[') + SchemaElement.buildSignature(elementType);
                if (!elementType.isObject() || (namespace = elementType.asObject().getProperty("namespace")) == null) break;
                signature = signature + ":" + namespace;
                break;
            }
            case 8: {
                if (type == SFSNamespace.HEX_BINARY) {
                    signature = String.valueOf('H');
                    break;
                }
                signature = String.valueOf('Y');
                break;
            }
            case 1: {
                signature = String.valueOf('B');
                break;
            }
            case 3: {
                signature = String.valueOf('D');
                break;
            }
            case 2: {
                if (type == SFSNamespace.GDAY) {
                    signature = String.valueOf('5');
                    break;
                }
                if (type == SFSNamespace.GMONTH) {
                    signature = String.valueOf('6');
                    break;
                }
                signature = String.valueOf('I') + type.getLength() / 8;
                break;
            }
            case 7: {
                signature = String.valueOf('V');
                break;
            }
            case 4: {
                signature = String.valueOf('R') + type.getLength() / 8;
                break;
            }
            case 5: {
                signature = String.valueOf('S');
                break;
            }
            case 6: {
                if (type == SFSNamespace.TIME_TIME) {
                    signature = String.valueOf('1');
                    break;
                }
                if (type == SFSNamespace.GYEARMONTH_TIME) {
                    signature = String.valueOf('3');
                    break;
                }
                if (type == SFSNamespace.GMONTHDAY_TIME) {
                    signature = String.valueOf('4');
                    break;
                }
                if (type == SFSNamespace.DATE) {
                    signature = String.valueOf('7');
                    break;
                }
                signature = String.valueOf('2');
                break;
            }
            case 11: {
                String objectSignature = type.getSignature();
                int index = objectSignature.indexOf(59);
                if (index != -1) {
                    objectSignature = objectSignature.substring(0, index);
                }
                signature = String.valueOf('X') + objectSignature;
                break;
            }
            case 17: {
                signature = String.valueOf('E');
                int count = type.getMemberCount();
                for (int i = 0; i < count; ++i) {
                    MethodTypeDescription enumItem = type.getMemberType(i);
                    String nativeName = enumItem.getProperty("nativeName");
                    signature = signature + nativeName;
                    if (i + 1 >= count) continue;
                    signature = signature + ",";
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal type '" + type.getText() + "' (" + type.getClass().getName() + ")");
            }
        }
        return signature;
    }

    public Context getContext() {
        return (Context)this.getNSContext();
    }

    public String getJavaType() {
        return this.javaType != null ? this.javaType : this.type.getJavaType();
    }

    public TypeDescription getTypeDescription() throws TypeException {
        if (this.type == null) {
            this.type = this.buildType(null);
        }
        return this.type;
    }

    public TypeDescription getTypeIfCreated() {
        return this.type;
    }

    @Override
    public void addChild(Element element) {
        if (element instanceof Text) {
            Text text = (Text)element;
            this.setAttribute("content", text.getContent());
        } else if (element instanceof Annotation) {
            this.setAnnotation((Annotation)element);
        } else {
            super.addChild(element);
        }
    }

    public void reportError(TypeException e) {
        e.printStackTrace();
        super.reportError(e.getMessage());
    }

    @Override
    public void reportError(Exception e) {
        super.reportError(e.getMessage());
    }

    public Schema getSchema() {
        return this.findAncestorByClass(Schema.class);
    }

    public ExtendedNamespace getTarget() {
        return this.getContext().getTarget();
    }

    protected void resolveInclusions() {
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            element.resolveInclusions();
        }
    }

    protected final TypeDescription buildSubElements(TypeDescription current) throws TypeException {
        TypeDescription last = null;
        SchemaParser schemaParser = (SchemaParser)this.getXMLParser();
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            try {
                ModuleResolver moduleResolver = schemaParser.getModuleResolver();
                TypeDescription type = moduleResolver.resolveType(element, this.getContext());
                if (type == null) {
                    type = element.buildType(current);
                }
                if (type == null) continue;
                last = type;
                continue;
            }
            catch (TypeException e) {
                e.setElement(element);
                this.reportError(e);
                continue;
            }
            catch (RuntimeException e) {
                this.reportError("There was an internal error compiling " + this.getTarget());
                e.printStackTrace();
            }
        }
        return last;
    }

    protected boolean isAttribute(TypeDescription type) {
        return type != null && type.isAttribute();
    }

    protected boolean isObject(TypeDescription type) {
        return type != null && (type.isObject() || type.isEnum());
    }

    protected AttrGroupTypeDescription buildAttributes(TypeDescription current, boolean mergeGroups) throws TypeException {
        return this.buildAttributes(this.getFirst(), current, mergeGroups);
    }

    protected final AttrGroupTypeDescription buildAttributes(SchemaElement element, TypeDescription current, boolean mergeGroups) throws TypeException {
        AttrGroupTypeDescription group;
        ArrayList<TypeDescription> attributes = new ArrayList<TypeDescription>();
        boolean hasAnyAttribute = false;
        while (element != null) {
            try {
                TypeDescription type = element.buildType(current);
                if (type != null && type.isAttribute()) {
                    boolean isAttribute;
                    String name = type.getName();
                    boolean bl = isAttribute = type.getSignature().charAt(0) == 'A';
                    if (this.findAttributeByName(attributes, name) != null) {
                        if (type instanceof AttributeTypeDescription && type.getSignature() != null && isAttribute) {
                            AttributeTypeDescription attr = (AttributeTypeDescription)type;
                            attr = attr.clone();
                            attr.setName(name + "Attribute");
                            attributes.add(attr);
                        }
                    } else {
                        attributes.add(type);
                    }
                } else if (mergeGroups && type instanceof AttrGroupTypeDescription) {
                    AttributeTypeDescription[] elements;
                    group = (AttrGroupTypeDescription)type;
                    hasAnyAttribute = hasAnyAttribute || group.hasAnyAttribute();
                    for (AttributeTypeDescription attr : elements = group.getAttributes()) {
                        AttributeTypeDescription prev;
                        String name = attr.getName();
                        int number = 1;
                        String numberText = "";
                        while ((prev = this.findAttributeByName(attributes, name + numberText)) != null && !prev.getType().equals(attr.getType())) {
                            numberText = String.valueOf(++number);
                        }
                        if (prev != null) continue;
                        if (number > 1) {
                            attr = attr.clone();
                            attr.setName(name + numberText);
                        }
                        attributes.add(attr);
                    }
                }
            }
            catch (TypeException e) {
                this.reportError(e);
            }
            element = element.getNext();
        }
        group = new AttrGroupTypeDescription(attributes);
        group.setAnyAttribute(hasAnyAttribute);
        return group;
    }

    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        if (this.type != null) {
            return this.type;
        }
        return this.buildSubElements(current);
    }

    protected void declare() throws TypeException {
    }

    protected TypeDescription findType(String text, TypeDescription defType) {
        TypeDescription type;
        try {
            type = this.getContext().lookupType(text).buildType(null);
        }
        catch (TypeException e) {
            e.setElement(this);
            this.reportError(e);
            type = defType;
        }
        return type;
    }

    protected String localName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(58)) != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    @Override
    protected void dump(IndentedPrintWriter out, boolean root, boolean fuegoProcessingInstruction, NamespaceContext currentCtx, String encoding, DefaultElement.DumpParameters parameters) {
        boolean originalValue = parameters.isAddContextNamespaces();
        parameters.setAddContextNamespaces(true);
        super.dump(out, root, fuegoProcessingInstruction, currentCtx, encoding, parameters);
        parameters.setAddContextNamespaces(originalValue);
    }

    void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    Annotation getAnnotation() {
        return this.annotation;
    }

    SchemaElement getFirst() {
        DefaultElement firstElement = this.getFirstElement();
        if (firstElement != null && !(firstElement instanceof SchemaElement)) {
            firstElement = new InvalidSchemaElement(firstElement);
        }
        return (SchemaElement)firstElement;
    }

    void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    SchemaElement getNext() {
        DefaultElement nextElement = this.getNextElement();
        if (nextElement != null && !(nextElement instanceof SchemaElement)) {
            nextElement = new InvalidSchemaElement(nextElement);
        }
        return (SchemaElement)nextElement;
    }

    SchemaParser getSchemaParser() {
        return (SchemaParser)this.getXMLParser();
    }

    void setTopLevel(boolean tl) {
        this.topLevel = tl;
    }

    boolean isTopLevel() {
        return this.topLevel;
    }

    void setTypeDescription(TypeDescription type) {
        this.type = type;
    }

    void addAnnotations(TypeDescription type) throws TypeException {
        if (this.annotation != null) {
            this.annotation.buildType(type);
        }
    }

    void createXsd() {
        for (SchemaElement current = this.getFirst(); current != null; current = current.getNext()) {
            current.createXsd();
        }
    }

    private AttributeTypeDescription findAttributeByName(List attributes, String name) {
        AttributeTypeDescription result = null;
        for (Object attribute : attributes) {
            AttributeTypeDescription attr = (AttributeTypeDescription)attribute;
            if (!attr.getName().equals(name)) continue;
            result = attr;
            break;
        }
        return result;
    }
}

