/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.util.HashUtils;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlschema.BlockSet;
import oracle.bpm.xmlschema.ComplexType;
import oracle.bpm.xmlschema.ComponentDef;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.DerivationSet;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.Import;
import oracle.bpm.xmlschema.Include;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.SchemaParser;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmltype.XmlConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Schema
extends ComponentDef {
    private URL location;

    public Schema() {
    }

    public Schema(String targetNamespace) {
        this.setTagName("schema");
        this.setNamespace("");
        this.setTargetNamespace(targetNamespace);
        Context context = new Context(null);
        context.addNamespace("", "http://www.w3.org/2001/XMLSchema");
        context.addNamespace("tns", targetNamespace);
        this.setNSContext(context);
    }

    public static String resolveLocationKeyFromLocation(String location, String type) {
        String schemaKey;
        boolean referredToModule = location.startsWith("albpmModule_");
        if (referredToModule) {
            String[] parts = location.split("#");
            schemaKey = parts[1];
        } else {
            schemaKey = location.substring(type.length());
        }
        return schemaKey;
    }

    public void setTargetNamespace(String ns) {
        this.setAttribute("targetNamespace", ns);
    }

    public String getTargetNamespace() {
        String targetNamespace = this.getAttribute("targetNamespace");
        return targetNamespace == null ? "" : targetNamespace;
    }

    public String getSchemaLocationKey() {
        URL schemaLocation = this.getLocation();
        String key = this.getSchemaParser().getSchemaLocationKey(schemaLocation);
        if (key == null) {
            HashUtils.HashBuilder builder = HashUtils.buildMd5Builder();
            builder.update(this.getTargetNamespace());
            builder.update(schemaLocation.toString());
            key = builder.digest();
            this.getSchemaParser().putSchemaLocationKey(schemaLocation, key);
        }
        return key;
    }

    public boolean isInlineSchema() {
        return this.getLocation() == null;
    }

    public void addType(ObjectTypeDescription type) throws TypeException {
        ComplexType complexType = new ComplexType(this, type.getName());
        complexType.setTypeDescription(type);
        this.addChild(complexType);
    }

    @Override
    public TypeDescription buildType(TypeDescription current) throws TypeException {
        super.buildSubElements(null);
        return current;
    }

    @Override
    public void declare() throws TypeException {
        SchemaParser parser = this.getSchemaParser();
        if (this.location == null) {
            this.location = parser != null ? parser.getSourceLocation() : null;
        }
        Context ctx = this.getContext();
        String target = this.getTargetNamespace();
        if (target == null) {
            target = "";
        }
        if (ctx != null && ctx.getTarget() == null) {
            ctx.setTarget(target);
        }
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            try {
                element.setTopLevel(true);
                element.declare();
                continue;
            }
            catch (TypeException e) {
                this.reportError(e);
            }
        }
        this.resolveInclusions();
    }

    public boolean isElementQualified() {
        return "qualified".equals(this.getAttribute("elementFormDefault"));
    }

    public Import[] getImports() {
        ArrayList<Import> imports = new ArrayList<Import>();
        for (SchemaElement current = this.getFirst(); current != null; current = current.getNext()) {
            if (!(current instanceof Import)) continue;
            imports.add((Import)current);
        }
        Import[] imps = new Import[imports.size()];
        imports.toArray(imps);
        return imps;
    }

    public Include[] getIncludes() {
        ArrayList<Include> includes = new ArrayList<Include>();
        for (SchemaElement current = this.getFirst(); current != null; current = current.getNext()) {
            if (!(current instanceof Include)) continue;
            includes.add((Include)current);
        }
        Include[] imps = new Include[includes.size()];
        includes.toArray(imps);
        return imps;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public String getXsdContent() {
        StringWriter writer = new StringWriter();
        IndentedPrintWriter out = new IndentedPrintWriter(writer);
        this.dump(out, "UTF-8");
        out.close();
        return writer.getBuffer().toString();
    }

    public URL getLocation() {
        return this.location;
    }

    public String getSchemaName() {
        return this.getAttribute("name");
    }

    public void dumpSchema(@NotNull ObjectTypeDescription module) throws ParserException {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlschema/Schema.dumpSchema must not be null");
        }
        this.fixExternalLocationDeclarations(module.getText(), this.getLocation());
        String schemaTargetNamespace = this.getTargetNamespace();
        String key = this.isInlineSchema() ? XmlConstants.buildSchemaKey(schemaTargetNamespace) : XmlConstants.buildSchemaKey(schemaTargetNamespace, this.getSchemaLocationKey());
        module.setProperty(key, this.getXsdContent());
    }

    public void fixExternalLocationDeclarations(@NotNull String moduleName, @Nullable URL currentLocation) throws ParserException {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlschema/Schema.fixExternalLocationDeclarations must not be null");
        }
        try {
            Import[] imports;
            Include[] includes;
            for (Include include : includes = this.getIncludes()) {
                String includeLocation = include.getSchemaLocation();
                Schema schemaIncluded = this.getSchemaFromLocation(currentLocation, includeLocation);
                String locationKey = schemaIncluded.getSchemaLocationKey();
                include.setSchemaLocation("albpmModule_" + moduleName + '#' + locationKey);
            }
            for (Import anImport : imports = this.getImports()) {
                String importLocation;
                Schema schemaImported;
                if (anImport.isInline() || (schemaImported = this.getSchemaFromLocation(currentLocation, importLocation = anImport.getSchemaLocation())) == null) continue;
                String locationKey = schemaImported.getSchemaLocationKey();
                anImport.setSchemaLocation("albpmModule_" + moduleName + '#' + locationKey);
            }
        }
        catch (MalformedURLException e) {
            throw new ParserException(e);
        }
    }

    protected SchemaElement findHead() {
        boolean hasHead = false;
        SchemaElement head = null;
        for (SchemaElement element = this.getFirst(); element != null; element = element.getNext()) {
            if (!(element instanceof ElementDef)) continue;
            if (head == null) {
                head = element;
                hasHead = true;
                continue;
            }
            hasHead = false;
        }
        return hasHead ? head : null;
    }

    boolean isAttributeQualified() {
        return "qualified".equals(this.getAttribute("attributeFormDefault"));
    }

    BlockSet getBlockDefault() {
        return new BlockSet(this.getAttribute("blockDefault"));
    }

    DerivationSet getFinalDefault() {
        return new DerivationSet(this.getAttribute("finalDefault"));
    }

    String getId() {
        return this.getAttribute("id");
    }

    @Override
    String getName() {
        return "";
    }

    String getVersion() {
        return this.getAttribute("version");
    }

    private Schema getSchemaFromLocation(@NotNull URL schemaLocation, @NotNull String includeLocation) throws MalformedURLException {
        if (schemaLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/xmlschema/Schema.getSchemaFromLocation must not be null");
        }
        if (includeLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/xmlschema/Schema.getSchemaFromLocation must not be null");
        }
        URL urlLocation = new URL(schemaLocation, includeLocation);
        return this.getSchemaParser().getParsedFiles().get(urlLocation);
    }
}

