/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.SchemaElement;

public class SFSNamespace
extends ExtendedNamespace {
    private static Map<String, SFSNamespace> instances = new HashMap<String, SFSNamespace>();
    static final String S2001 = "http://www.w3.org/2001/XMLSchema";
    static final String S1999 = "http://www.w3.org/1999/XMLSchema";
    static final TypeDescription BASE64_BINARY = new TypeDescriptionImpl(8){};
    static final TypeDescription HEX_BINARY = new TypeDescriptionImpl(8){};
    static final TypeDescription TIME_TIME = new TypeDescriptionImpl(6){};
    static final TypeDescription DATE = new TypeDescriptionImpl(6){};
    static final TypeDescription DATETIME_TIME = new TypeDescriptionImpl(6){};
    static final TypeDescription GYEARMONTH_TIME = new TypeDescriptionImpl(6){};
    static final TypeDescription GMONTHDAY_TIME = new TypeDescriptionImpl(6){};
    static final TypeDescription GDAY = new TypeDescriptionImpl(2){};
    static final TypeDescription GMONTH = new TypeDescriptionImpl(2){};
    public static final SFSNamespace S2001_NAMESPACE = SFSNamespace.get("http://www.w3.org/2001/XMLSchema");
    static final long serialVersionUID = 4618604833645299491L;
    static final long serialCheck = 5323702424466743775L;

    private SFSNamespace(String uri) {
        super(uri);
        this.mappingXsdTypesToTypeDef();
        this.mappingTypeDefToXsdTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SFSNamespace get(String uri) {
        Map<String, SFSNamespace> map = instances;
        synchronized (map) {
            SFSNamespace result = instances.get(uri);
            if (result == null) {
                result = new SFSNamespace(uri);
                instances.put(uri, result);
            }
            return result;
        }
    }

    @Override
    void setTarget(boolean target) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareAnonymous(TypeDescription type) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareAttribute(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    void declareAttribute(String name, AttributeTypeDescription attr) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareAttributeGroup(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareElement(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    void declareElement(String name, AttributeTypeDescription attr) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareGroup(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    void declareGroup(String name, TypeDescription group) {
        throw new UnsupportedOperationException();
    }

    @Override
    void declareType(String name, SchemaElement element) {
        throw new UnsupportedOperationException();
    }

    private void addXsdToTypeDef(String name, TypeDescription type) {
        this.addXsdToTypeDef(name, type, null);
    }

    private void addXsdToTypeDef(String name, TypeDescription type, String javaType) {
        SchemaElement typeHolder = new SchemaElement();
        if (type.isReal() || type.isInt() && type != GDAY && type != GMONTH) {
            type = type.primitiveEquivalent(true);
        }
        typeHolder.setTypeDescription(type);
        typeHolder.setJavaType(javaType);
        typeHolder.setNamespace(this.getUri());
        typeHolder.setAttribute("name", name);
        this.types.put(name, typeHolder);
        if (!this.names.containsKey(type)) {
            this.names.put(type, name);
        }
    }

    private void addTypeDefToXsd(TypeDescription type, String xsdType) {
        if ((type.isReal() || type.isInt()) && type != GDAY && type != GMONTH) {
            type = type.primitiveEquivalent(true);
        }
        this.names.put(type, xsdType);
    }

    private void mappingTypeDefToXsdTypes() {
        this.addTypeDefToXsd(TypeFactory.getString(), "string");
        this.addTypeDefToXsd(TypeFactory.getArray(TypeFactory.getString()), "IDREFS");
        this.addTypeDefToXsd(TypeFactory.getInt(8), "byte");
        this.addTypeDefToXsd(TypeFactory.getInt(16), "short");
        this.addTypeDefToXsd(TypeFactory.getInt(32), "int");
        this.addTypeDefToXsd(TypeFactory.getInt(64), "integer");
        this.addTypeDefToXsd(TypeFactory.getDecimal(), "decimal");
        this.addTypeDefToXsd(TypeFactory.getReal(), "double");
        this.addTypeDefToXsd(TypeFactory.getReal(32), "float");
        this.addTypeDefToXsd(TypeFactory.getBool(), "boolean");
        this.addTypeDefToXsd(TypeFactory.getPrimitiveBool(), "boolean");
        this.addTypeDefToXsd(TypeFactory.getTime(), "timeInstant");
        this.addTypeDefToXsd(TypeFactory.getInterval(), "duration");
        this.addTypeDefToXsd(TypeFactory.getBinary(), "base64Binary");
        this.addTypeDefToXsd(TypeFactory.getAny(), "anyType");
    }

    private void mappingXsdTypesToTypeDef() {
        this.addXsdToTypeDef("string", TypeFactory.getString());
        this.addXsdToTypeDef("normalizedString", TypeFactory.getString());
        this.addXsdToTypeDef("token", TypeFactory.getString());
        this.addXsdToTypeDef("Name", TypeFactory.getString());
        this.addXsdToTypeDef("QName", TypeFactory.getString());
        this.addXsdToTypeDef("NCName", TypeFactory.getString());
        this.addXsdToTypeDef("anyURI", TypeFactory.getString());
        this.addXsdToTypeDef("language", TypeFactory.getString());
        this.addXsdToTypeDef("ID", TypeFactory.getString());
        this.addXsdToTypeDef("IDREF", TypeFactory.getString());
        this.addXsdToTypeDef("ENTITY", TypeFactory.getString());
        this.addXsdToTypeDef("NOTATION", TypeFactory.getString());
        this.addXsdToTypeDef("NMTOKEN", TypeFactory.getString());
        this.addXsdToTypeDef("uriReference", TypeFactory.getString());
        this.addXsdToTypeDef("IDREFS", TypeFactory.getArray(TypeFactory.getString()));
        this.addXsdToTypeDef("ENTITIES", TypeFactory.getArray(TypeFactory.getString()));
        this.addXsdToTypeDef("NMTOKENS", TypeFactory.getArray(TypeFactory.getString()));
        this.addXsdToTypeDef("byte", TypeFactory.getInt(8), "byte");
        this.addXsdToTypeDef("unsignedByte", TypeFactory.getInt(8), "byte");
        this.addXsdToTypeDef("integer", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("positiveInteger", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("negativeInteger", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("nonNegativeInteger", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("nonPositiveInteger", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("int", TypeFactory.getInt(32), "int");
        this.addXsdToTypeDef("unsignedInt", TypeFactory.getInt(32), "int");
        this.addXsdToTypeDef("long", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("unsignedLong", TypeFactory.getInt(64), "int");
        this.addXsdToTypeDef("short", TypeFactory.getInt(16), "short");
        this.addXsdToTypeDef("unsignedShort", TypeFactory.getInt(16), "short");
        this.addXsdToTypeDef("gMonth", GMONTH, "int");
        this.addXsdToTypeDef("gYear", TypeFactory.getInt(16), "int");
        this.addXsdToTypeDef("gDay", GDAY, "int");
        this.addXsdToTypeDef("decimal", TypeFactory.getDecimal());
        this.addXsdToTypeDef("float", TypeFactory.getReal(32), "float");
        this.addXsdToTypeDef("double", TypeFactory.getReal(), "double");
        this.addXsdToTypeDef("boolean", TypeFactory.getBool());
        this.addXsdToTypeDef("boolean", TypeFactory.getPrimitiveBool());
        this.addXsdToTypeDef("dateTime", DATETIME_TIME);
        this.addXsdToTypeDef("time", TIME_TIME);
        this.addXsdToTypeDef("date", DATE);
        this.addXsdToTypeDef("gYearMonth", GYEARMONTH_TIME);
        this.addXsdToTypeDef("gMonthDay", GMONTHDAY_TIME);
        this.addXsdToTypeDef("timeInstant", TypeFactory.getTime());
        this.addXsdToTypeDef("duration", TypeFactory.getInterval());
        this.addXsdToTypeDef("timeDuration", TypeFactory.getInterval());
        this.addXsdToTypeDef("base64Binary", BASE64_BINARY);
        this.addXsdToTypeDef("hexBinary", HEX_BINARY);
        this.addXsdToTypeDef("anySimpleType", TypeFactory.getString());
        this.addXsdToTypeDef("anyType", TypeFactory.getAny());
    }
}

