/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.xmlparser.Parser;
import oracle.bpm.xmlschema.Context;
import oracle.bpm.xmlschema.ExtendedNamespace;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.SchemaParser;
import oracle.bpm.xmltype.EntityResolver;
import oracle.bpm.xmltype.ImportType;

public class Import
extends SchemaElement {
    public void setSchemaLocation(String location) {
        this.setAttribute("schemaLocation", location);
    }

    public String getNamespaceAttribute() {
        return this.getAttribute("namespace");
    }

    public boolean isInline() {
        return this.getSchemaLocation() == null;
    }

    public void removeSchemaLocation() {
        Map<QName, String> attributes = this.getAttributes();
        attributes.remove(new QName("schemaLocation"));
    }

    public String getSchemaLocation() {
        return this.getAttribute("schemaLocation");
    }

    @Override
    protected void resolveInclusions() {
        String namespace = this.getNamespaceAttribute();
        String location = this.getSchemaLocation();
        if (ExtendedNamespace.isBuiltin(namespace) || this.getContext().isKnownSchema(namespace)) {
            return;
        }
        InputStream reader = null;
        Parser parser = this.getXMLParser();
        URL ctx = this.getSchema().getLocation();
        Context context = this.getContext();
        SchemaParser schemaParser = (SchemaParser)parser;
        try {
            URL url;
            EntityResolver resolver;
            if (parser instanceof SchemaParser && location != null && (resolver = schemaParser.getXsdImportResolver()) != null) {
                reader = resolver.resolveEntity(location, namespace, ImportType.IMPORT_TYPE_XSD10);
            }
            if (reader != null) {
                url = new URL(ctx, location);
                schemaParser.importSchema(context, url, reader);
            } else {
                if (location == null) {
                    location = namespace;
                }
                if (location != null) {
                    url = new URL(ctx, location);
                    schemaParser.importSchema(context, url);
                }
            }
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }
}

