/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.TypeDescription;
import oracle.bpm.xmlschema.ComponentDef;
import oracle.bpm.xmlschema.GroupNotFoundException;
import oracle.bpm.xmlschema.Particle;
import oracle.bpm.xmlschema.TypeException;

class Group
extends ComponentDef {
    Group() {
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        String ref = this.getRef();
        if (ref != null) {
            try {
                current = this.getContext().lookupGroup(ref).buildType(null);
            }
            catch (GroupNotFoundException e) {
                this.reportError(e);
                current = null;
            }
        } else {
            current = super.buildType(current);
            current = this.buildSubElements(current);
        }
        return current;
    }

    @Override
    protected void declare() throws TypeException {
        String name = this.getName();
        if (name != null) {
            this.getTarget().declareGroup(name, this);
        }
    }

    int getMaxOccurs() {
        return Particle.getMaxOccurs(this);
    }

    int getMinOccurs() {
        return Particle.getMinOccurs(this);
    }

    String getRef() {
        return this.getAttribute("ref");
    }
}

