/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.xmlparser.Namespace;
import oracle.bpm.xmlschema.AttrGroupNotFoundException;
import oracle.bpm.xmlschema.Attribute;
import oracle.bpm.xmlschema.AttributeGroup;
import oracle.bpm.xmlschema.AttributeNotFoundException;
import oracle.bpm.xmlschema.ElementDef;
import oracle.bpm.xmlschema.ElementNotFoundException;
import oracle.bpm.xmlschema.Group;
import oracle.bpm.xmlschema.GroupNotFoundException;
import oracle.bpm.xmlschema.InvalidLocalNameException;
import oracle.bpm.xmlschema.SOAPNamespace;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;
import oracle.bpm.xmlschema.TypeNotFoundException;

public class ExtendedNamespace
extends Namespace {
    protected Map<String, TypeDescription> anonymous;
    protected Map<String, SchemaElement> attrGroups;
    protected Map<String, SchemaElement> attributes;
    protected Map<String, SchemaElement> elements = new HashMap<String, SchemaElement>();
    protected Map<String, SchemaElement> groups;
    protected Map<TypeDescription, String> names;
    protected Map<String, SchemaElement> types;
    private ExtendedNamespace defaultNS;
    private boolean isTarget = false;
    private TypeDescription topLevel;
    static final long serialVersionUID = -8201071003951645032L;
    static final long serialCheck = -8836663093734694832L;

    ExtendedNamespace(String uri) {
        super(uri);
        this.attrGroups = new HashMap<String, SchemaElement>();
        this.attributes = new HashMap<String, SchemaElement>();
        this.types = new HashMap<String, SchemaElement>();
        this.names = new HashMap<TypeDescription, String>();
        this.groups = new HashMap<String, SchemaElement>();
        this.anonymous = new HashMap<String, TypeDescription>();
    }

    public static boolean isBuiltin(String namespaceUri) {
        return namespaceUri != null && (XmlUtils.isSFS(namespaceUri) || SOAPNamespace.isSOAPSchema(namespaceUri));
    }

    public Map<String, TypeDescription> getDefinedTypes() {
        HashMap<String, TypeDescription> definedTypes = new HashMap<String, TypeDescription>();
        for (String name : this.types.keySet()) {
            try {
                TypeDescription type = this.lookupType(name).buildType(null);
                definedTypes.put(type.getName(), type);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        for (TypeDescription typeDescription : this.anonymous.values()) {
            String name = typeDescription.getName();
            definedTypes.put(name, typeDescription);
        }
        return definedTypes;
    }

    public Attribute lookupAttribute(String name) throws TypeException {
        Attribute attr = (Attribute)this.attributes.get(name);
        if (attr == null) {
            if (this.defaultNS == null) {
                throw new AttributeNotFoundException(name, this);
            }
            attr = this.defaultNS.lookupAttribute(name);
        }
        return attr;
    }

    public AttributeGroup lookupAttributeGroup(String name) throws TypeException {
        AttributeGroup group = (AttributeGroup)this.attrGroups.get(name);
        if (group == null) {
            if (this.defaultNS == null) {
                throw new AttrGroupNotFoundException(name, this);
            }
            group = this.defaultNS.lookupAttributeGroup(name);
        }
        return group;
    }

    public Group lookupGroup(String name) throws TypeException {
        Group group = (Group)this.groups.get(name);
        if (group == null) {
            if (this.defaultNS == null) {
                throw new GroupNotFoundException(name, this);
            }
            group = this.defaultNS.lookupGroup(name);
        }
        return group;
    }

    public boolean hasType(String name) {
        return this.types.get(name) != null;
    }

    public SchemaElement lookupType(String name) throws TypeException {
        SchemaElement type = this.types.get(name);
        if (type == null) {
            if (this.defaultNS == null) {
                throw new TypeNotFoundException(name, this);
            }
            type = this.defaultNS.lookupType(name);
        }
        return type;
    }

    public String lookupTypeName(TypeDescription type) {
        return this.names.get(type);
    }

    public ElementDef lookupElement(String name) throws TypeException {
        ElementDef element = (ElementDef)this.elements.get(name);
        if (element == null) {
            if (this.defaultNS == null) {
                throw new ElementNotFoundException(name, this);
            }
            element = this.defaultNS.lookupElement(name);
        }
        return element;
    }

    public Set<String> getDeclaredElementNames() {
        return this.elements.keySet();
    }

    public Set<String> getDeclaredAttributeNames() {
        return this.attributes.keySet();
    }

    public Set<String> getDeclaredGroupNames() {
        return this.groups.keySet();
    }

    public TypeDescription getAnonymousElementByParentName(String parentName) {
        TypeDescription typeDescription = null;
        if (this.anonymous != null) {
            typeDescription = this.anonymous.get(parentName);
        }
        return typeDescription;
    }

    void setDefault(ExtendedNamespace ns) {
        this.defaultNS = ns;
    }

    ExtendedNamespace getDefault() {
        return this.defaultNS;
    }

    void setTarget(boolean target) {
        this.isTarget = target;
    }

    boolean isTarget() {
        return this.isTarget;
    }

    void setTopLevelType(TypeDescription type) {
        this.topLevel = type;
    }

    TypeDescription getTopLevelType() {
        return this.topLevel;
    }

    void declareAnonymous(TypeDescription type) throws TypeException {
        this.checkDeclaration(type);
        String name = type.getName();
        this.ensureLocalName(name);
        int suffix = 1;
        String suffixText = "";
        while (this.anonymous.containsKey(name + suffixText) || this.types.containsKey(name + suffixText)) {
            suffixText = String.valueOf(++suffix);
        }
        if (suffix > 1) {
            name = name + suffixText;
            type.asObject().setName(name);
        }
        this.anonymous.put(name, type);
    }

    void declareAttribute(String name, SchemaElement element) throws TypeException {
        this.checkDeclaration(element);
        this.ensureLocalName(name);
        this.attributes.put(name, element);
    }

    void declareAttributeGroup(String name, SchemaElement element) throws TypeException {
        this.checkDeclaration(element);
        this.ensureLocalName(name);
        this.attrGroups.put(name, element);
    }

    void declareElement(String name, SchemaElement element) throws TypeException {
        this.checkDeclaration(element);
        this.ensureLocalName(name);
        this.elements.put(name, element);
    }

    void declareGroup(String name, SchemaElement element) throws TypeException {
        this.checkDeclaration(element);
        this.ensureLocalName(name);
        this.groups.put(name, element);
    }

    void declareType(String name, SchemaElement element) throws TypeException {
        this.checkDeclaration(element);
        this.ensureLocalName(name);
        this.types.put(name, element);
        TypeDescription type = element.getTypeIfCreated();
        if (type != null) {
            this.names.put(type, type.getName());
        }
    }

    void updateFrom(ExtendedNamespace ns) {
        this.elements = new HashMap<String, SchemaElement>(ns.elements);
        this.attributes = new HashMap<String, SchemaElement>(ns.attributes);
        this.attrGroups = new HashMap<String, SchemaElement>(ns.attrGroups);
        this.groups = new HashMap<String, SchemaElement>(ns.groups);
        this.types = new HashMap<String, SchemaElement>(ns.types);
        this.anonymous = new HashMap<String, TypeDescription>(ns.anonymous);
    }

    private void checkDeclaration(Object element) {
        assert (this.isTarget()) : "This is not a target namespace: '" + this + "'";
        assert (element != null) : "Attempt to declare a null element";
    }

    private void ensureLocalName(String name) throws TypeException {
        if (name == null || name.indexOf(58) != -1) {
            throw new InvalidLocalNameException(name);
        }
    }
}

