/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xmlschema;

import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlschema.AttrGroupTypeDescription;
import oracle.bpm.xmlschema.ComponentDef;
import oracle.bpm.xmlschema.Content;
import oracle.bpm.xmlschema.DerivationSet;
import oracle.bpm.xmlschema.Schema;
import oracle.bpm.xmlschema.SchemaElement;
import oracle.bpm.xmlschema.TypeException;

class ComplexType
extends ComponentDef {
    public ComplexType() {
    }

    public ComplexType(Schema context, String name) {
        super(context);
        this.setTagName("complexType");
        this.setAttribute("name", name);
    }

    @Override
    protected TypeDescription buildType(TypeDescription current) throws TypeException {
        if (this.type != null) {
            return this.type;
        }
        TypeDescription object = super.buildType(current);
        SchemaElement first = this.getFirst();
        this.type = object;
        String elementType = "complexType";
        DefaultElement parent = this.getParent();
        if (parent != null && parent.getTagName().equals("element")) {
            elementType = "elementType";
        }
        ((ObjectTypeDescription)this.type).setProperty("elementType", elementType);
        ((ObjectTypeDescription)this.type).setProperty("schemaLocationKey", this.getSchema().getSchemaLocationKey());
        if (first instanceof Content) {
            if (!(object = first.buildType(object)).isObject()) {
                this.type = object;
            } else {
                ObjectTypeDescription source = object.asObject();
                ObjectTypeDescription target = this.type.asObject();
                for (SuperType superType : source.getSuperTypes()) {
                    if (superType.getType().getText().equals("Fuego.Xml.XMLObject")) continue;
                    target.addSuperType(superType);
                }
                boolean implementsAbstracType = Boolean.TRUE.toString().equals(source.getProperty("implementsAbstractType"));
                if (implementsAbstracType) {
                    target.setProperty("implementsAbstractType", Boolean.TRUE.toString());
                }
                int count = source.getMemberCount();
                for (int i = 0; i < count; ++i) {
                    MethodTypeDescription memberType = source.getMemberType(i);
                    if (!memberType.isAttribute() || target.getMemberIndex(memberType.getName()) != -1) continue;
                    AttributeTypeDescription attr = new AttributeTypeDescription(memberType.getName(), memberType.getResultType());
                    attr.setModifiers(memberType.getModifiers());
                    attr.setReadSignature(memberType.getSignature());
                    attr.setWriteSignature(memberType.asAttribute().getWriteSignature());
                    attr.setProperties(memberType.getProperties());
                    target.addMember(attr);
                }
                object = target;
            }
        } else {
            AttrGroupTypeDescription attributes;
            if (current != null && current.isAttribute()) {
                current.asAttribute().setType(object);
            }
            if ((attributes = this.buildAttributes(object, true)) != null) {
                if (this.isMixed()) {
                    // empty if block
                }
                try {
                    attributes.addTo(object.asObject());
                }
                catch (ValidationException e) {
                    this.reportError(e);
                }
            }
        }
        if (object instanceof ObjectTypeDescription && this.isAbstract()) {
            ((ObjectTypeDescription)object).addModifier(512L);
        }
        this.type = object;
        return object;
    }

    @Override
    boolean isAbstract() {
        return Boolean.TRUE.toString().equals(this.getAttribute("abstract"));
    }

    DerivationSet getBlock() {
        return new DerivationSet(this.getAttribute("block"));
    }

    DerivationSet getFinal() {
        return new DerivationSet(this.getAttribute("final"));
    }

    boolean isMixed() {
        return "true".equals(this.getAttribute("mixed"));
    }
}

